@extends('layouts.main')

@section('page-title')
    {{ __('Theme Setup') }}
@endsection

@section('page-breadcrumb')
    {{ __('System Setup') }}, {{ __('Theme Setup') }}
@endsection

@push('css')
    <link rel="stylesheet" href="{{ asset('packages/workdo/MobileServiceManagement/src/Resources/assets/css/style.css') }}">
@endpush

@section('content')
    <div class="row">
        <div class="col-sm-12">
            @include('mobile-service-management::theme-setup.sections')

            <div class="card mt-4">
                <div class="card-header">
                    <h5>{{ __('Home Page') }}</h5>
                </div>
                <div class="card-body">
                    <div class="justify-content-center">
                        <div class="col-sm-12 col-md-10 col-xxl-12">
                            <div class="accordion accordion-flush setting-accordion" id="accordionExample">

                                {{-- Banner --}}
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="heading-1">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                            data-bs-target="#collapse1" aria-expanded="false" aria-controls="collapse1">
                                            <span class="d-flex align-items-center">
                                                {{ __('Banner') }}
                                            </span>
                                            <div class="d-flex align-items-center">
                                                <span class="me-2">{{ __('On/Off') }}:</span>
                                                <div class="form-check form-switch custom-switch-v1">
                                                    <input type="hidden" name="is_banner_section_active" value="off">
                                                    <input type="checkbox" class="form-check-input input-primary section-toggle"
                                                        name="is_banner_section_active" id="is_banner_section_active"
                                                        {{ !empty($settings['is_banner_section_active']) && $settings['is_banner_section_active'] == 'on' ? 'checked="checked"' : '' }}>
                                                </div>
                                            </div>
                                        </button>
                                    </h2>
                                    <div id="collapse1" class="accordion-collapse collapse" aria-labelledby="heading-1"
                                        data-bs-parent="#accordionExample">
                                        <div class="accordion-body">
                                            <div class="row gy-4">
                                                <div class="col-md-12">
                                                    @include('mobile-service-management::theme-setup.home-setup.banner')
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                {{-- Service Tracking --}}
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="heading-5">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                            data-bs-target="#collapse5" aria-expanded="false" aria-controls="collapse5">
                                            <span class="d-flex align-items-center">
                                                {{ __('Service Tracking') }}
                                            </span>
                                        </button>
                                    </h2>
                                    <div id="collapse5" class="accordion-collapse collapse" aria-labelledby="heading-5"
                                        data-bs-parent="#accordionExample">
                                        <div class="accordion-body">
                                            <div class="row gy-4">
                                                <div class="col-md-12">
                                                    @include('mobile-service-management::theme-setup.home-setup.tracking')
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                {{-- expertise --}}
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="heading-2">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                            data-bs-target="#collapse2" aria-expanded="false" aria-controls="collapse2">
                                            <span class="d-flex align-items-center">
                                                {{ __('Our Expertise') }}
                                            </span>
                                            <div class="d-flex align-items-center">
                                                <span class="me-2">{{ __('On/Off') }}:</span>
                                                <div class="form-check form-switch custom-switch-v1">
                                                    <input type="hidden" name="is_expertise_section_active" value="off">
                                                    <input type="checkbox" class="form-check-input input-primary section-toggle"
                                                        name="is_expertise_section_active" id="is_expertise_section_active"
                                                        {{ !empty($settings['is_expertise_section_active']) && $settings['is_expertise_section_active'] == 'on' ? 'checked="checked"' : '' }}>
                                                </div>
                                            </div>
                                        </button>
                                    </h2>
                                    <div id="collapse2" class="accordion-collapse collapse" aria-labelledby="heading-2"
                                        data-bs-parent="#accordionExample">
                                        <div class="accordion-body">
                                            <div class="row gy-4">
                                                <div class="col-md-12">
                                                    @include('mobile-service-management::theme-setup.home-setup.expertise')
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                {{-- About --}}
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="heading-3">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                            data-bs-target="#collapse3" aria-expanded="false" aria-controls="collapse3">
                                            <span class="d-flex align-items-center">
                                                {{ __('About') }}
                                            </span>
                                            <div class="d-flex align-items-center">
                                                <span class="me-2">{{ __('On/Off') }}:</span>
                                                <div class="form-check form-switch custom-switch-v1">
                                                    <input type="hidden" name="is_about_section_active" value="off">
                                                    <input type="checkbox" class="form-check-input input-primary section-toggle"
                                                        name="is_about_section_active" id="is_about_section_active"
                                                        {{ !empty($settings['is_about_section_active']) && $settings['is_about_section_active'] == 'on' ? 'checked="checked"' : '' }}>
                                                </div>
                                            </div>
                                        </button>
                                    </h2>
                                    <div id="collapse3" class="accordion-collapse collapse" aria-labelledby="heading-3"
                                        data-bs-parent="#accordionExample">
                                        <div class="accordion-body">
                                            <div class="row gy-4">
                                                <div class="col-md-12">
                                                    @include('mobile-service-management::theme-setup.home-setup.about')
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                {{-- Testimonials --}}
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="heading-4">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                            data-bs-target="#collapse4" aria-expanded="false" aria-controls="collapse4">
                                            <span class="d-flex align-items-center">
                                                {{ __('Testimonials') }}
                                            </span>
                                            <div class="d-flex align-items-center">
                                                <span class="me-2">{{ __('On/Off') }}:</span>
                                                <div class="form-check form-switch custom-switch-v1">
                                                    <input type="hidden" name="is_testimonials_section_active" value="off">
                                                    <input type="checkbox" class="form-check-input input-primary section-toggle"
                                                        name="is_testimonials_section_active" id="is_testimonials_section_active"
                                                        {{ !empty($settings['is_testimonials_section_active']) && $settings['is_testimonials_section_active'] == 'on' ? 'checked="checked"' : '' }}>
                                                </div>
                                            </div>
                                        </button>
                                    </h2>
                                    <div id="collapse4" class="accordion-collapse collapse" aria-labelledby="heading-4"
                                        data-bs-parent="#accordionExample">
                                        <div class="accordion-body">
                                            <div class="row gy-4">
                                                <div class="col-md-12">
                                                    @include('mobile-service-management::theme-setup.home-setup.testimonials')
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                {{-- CTA --}}
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="heading-6">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                            data-bs-target="#collapse6" aria-expanded="false" aria-controls="collapse6">
                                            <span class="d-flex align-items-center">
                                                {{ __('CTA') }}
                                            </span>
                                            <div class="d-flex align-items-center">
                                                <span class="me-2">{{ __('On/Off') }}:</span>
                                                <div class="form-check form-switch custom-switch-v1">
                                                    <input type="hidden" name="is_cta_section_active" value="off">
                                                    <input type="checkbox" class="form-check-input input-primary section-toggle"
                                                        name="is_cta_section_active" id="is_cta_section_active"
                                                        {{ !empty($settings['is_cta_section_active']) && $settings['is_cta_section_active'] == 'on' ? 'checked="checked"' : '' }}>
                                                </div>
                                            </div>
                                        </button>
                                    </h2>
                                    <div id="collapse6" class="accordion-collapse collapse" aria-labelledby="heading-6"
                                        data-bs-parent="#accordionExample">
                                        <div class="accordion-body">
                                            <div class="row gy-4">
                                                <div class="col-md-12">
                                                    @include('mobile-service-management::theme-setup.home-setup.cta')
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        // Section toggle functionality
        $(document).ready(function() {
            $('.section-toggle').on('change', function() {
                var checkbox = $(this);
                var checkboxName = checkbox.attr('name');
                var checkboxStatus = checkbox.is(':checked') ? 'on' : 'off';

                $.ajax({
                    url: '{{ route('mobileservice.theme-setup.toggle') }}',
                    method: 'POST',
                    data: {
                        [checkboxName]: checkboxStatus,
                        _token: $('meta[name="csrf-token"]').attr('content')
                    },
                    success: function(response) {
                        toastrs('success', response.success, 'success');
                    },
                    error: function(xhr) {
                        let message = xhr.responseJSON?.error || __('Something went wrong!');
                        toastrs('Error', message, 'error');
                    }
                });
            });
        });

        function previewImage(input) {
            const preview = $(input).closest('.d-flex, .row').find('.image-preview').first();
            const img = preview.find('img');
            if (input.files && input.files[0]) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    img.attr('src', e.target.result);
                    preview.show();
                };
                reader.readAsDataURL(input.files[0]);
            } else {
                preview.hide();
                img.attr('src', '');
            }
        }
    </script>
@endpush
