@extends('layouts.main')

@section('page-title')
    {{ __('Theme Setup') }}
@endsection

@section('page-breadcrumb')
    {{ __('System Setup') }}, {{ __('Theme Setup') }}
@endsection

@section('content')
    <div class="row">
        <div class="col-sm-12">
            @include('mobile-service-management::theme-setup.sections')

            <div class="card mt-4">
                <div class="card-header">
                    <h5>{{ __('Site Settings') }}</h5>
                </div>
                {{ Form::open(['route' => 'mobileservice.site-setup.store', 'method' => 'post', 'enctype' => 'multipart/form-data']) }}
                <div class="card-body">
                    <div class="row row-gap">
                        <div class="col-md-4 col-12 d-flex">
                            <div class="card w-100">
                                <div class="card-header py-3">
                                    <h5 class="small-title">{{ __('Site Logo') }}</h5>
                                </div>
                                <div class="card-body setting-card setting-logo-box p-3">
                                    <div class="logo-content img-fluid logo-set-bg text-center">
                                        @php
                                            $logo_image = $settings['logo'] ?? '';
                                            if (isset($logo_image) && $logo_image != '' && check_file($logo_image)) {
                                                $logo_path = get_file($logo_image);
                                            } else {
                                                $logo_path = asset('packages/workdo/MobileServiceManagement/src/Resources/assets/images/logo.png');
                                            }
                                        @endphp
                                        <img alt="image" src="{{ $logo_path }}{{ '?' . time() }}" id="logo-preview">
                                    </div>
                                    <div class="choose-files text-center mt-3">
                                        <label for="logo">
                                            <div class="bg-primary"> <i class="ti ti-upload px-1"></i>{{ __('Choose file here') }}</div>
                                            <input type="file" class="form-control file" name="logo" id="logo" data-filename="logo"
                                                onchange="document.getElementById('logo-preview').src = window.URL.createObjectURL(this.files[0])">
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4 col-12 d-flex">
                            <div class="card w-100">
                                <div class="card-header py-3">
                                    <h5 class="small-title">{{ __('Footer Logo') }}</h5>
                                </div>
                                <div class="card-body setting-card setting-logo-box p-3">
                                    <div class="logo-content img-fluid logo-set-bg dark-logo text-center">
                                        @php
                                            $footer_logo_image = $settings['footer_logo'] ?? '';
                                            if (isset($footer_logo_image) && $footer_logo_image != '' && check_file($footer_logo_image)) {
                                                $footer_logo_path = get_file($footer_logo_image);
                                            } else {
                                                $footer_logo_path = asset('packages/workdo/MobileServiceManagement/src/Resources/assets/images/footer-logo.png');
                                            }
                                        @endphp
                                        <img alt="image" src="{{ $footer_logo_path }}{{ '?' . time() }}" id="footer-logo-preview">
                                    </div>
                                    <div class="choose-files text-center mt-3">
                                        <label for="footer_logo">
                                            <div class="bg-primary"> <i class="ti ti-upload px-1"></i>{{ __('Choose file here') }}</div>
                                            <input type="file" class="form-control file" name="footer_logo" id="footer_logo" data-filename="footer_logo"
                                                onchange="document.getElementById('footer-logo-preview').src = window.URL.createObjectURL(this.files[0])">
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4 col-12 d-flex">
                            <div class="card w-100">
                                <div class="card-header py-3">
                                    <h5 class="small-title">{{ __('Favicon') }}</h5>
                                </div>
                                <div class="card-body setting-card setting-logo-box p-3">
                                    <div class="logo-content img-fluid logo-set-bg text-center">
                                        @php
                                            $favicon_image = $settings['favicon'] ?? '';
                                            if (isset($favicon_image) && $favicon_image != '' && check_file($favicon_image)) {
                                                $favicon_path = get_file($favicon_image);
                                            } else {
                                                $favicon_path = asset('packages/workdo/MobileServiceManagement/src/Resources/assets/images/favicon.png');
                                            }
                                        @endphp
                                        <img alt="image" src="{{ $favicon_path }}{{ '?' . time() }}" id="favicon-preview">
                                    </div>
                                    <div class="choose-files text-center mt-3">
                                        <label for="favicon">
                                            <div class="bg-primary"> <i class="ti ti-upload px-1"></i>{{ __('Choose file here') }}</div>
                                            <input type="file" class="form-control file" name="favicon" id="favicon" data-filename="favicon"
                                                onchange="document.getElementById('favicon-preview').src = window.URL.createObjectURL(this.files[0])">
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row mt-2">
                        <div class="col-md-4">
                            <div class="form-group">
                                {{ Form::label('site_title', __('Site Title'), ['class' => 'form-label']) }}
                                {{ Form::text('site_title', $settings['site_title'] ?? '', ['class' => 'form-control', 'placeholder' => __('Enter site title')]) }}
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                {{ Form::label('footer_text', __('Footer Text'), ['class' => 'form-label']) }}
                                {{ Form::text('footer_text', $settings['footer_text'] ?? '', ['class' => 'form-control', 'placeholder' => __('Enter footer text')]) }}
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                {{ Form::label('footer_description', __('Footer Description'), ['class' => 'form-label']) }}
                                {{ Form::textarea('footer_description', $settings['footer_description'] ?? '', ['class' => 'form-control', 'rows' => 3, 'placeholder' => __('Enter footer description')]) }}
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-footer text-end">
                    <input class="btn btn-primary" type="submit" value="{{ __('Save Changes') }}">
                </div>
                {{ Form::close() }}
            </div>
        </div>
    </div>
@endsection
