<?php

namespace CareerfyElementor\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit;


/**
 * @since 1.1.0
 */
class CareerfyButton extends Widget_Base
{

    /**
     * Retrieve the widget name.
     *
     * @since 1.1.0
     *
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name()
    {
        return 'careerfy-btn';
    }

    /**
     * Retrieve the widget title.
     *
     * @since 1.1.0
     *
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title()
    {
        return __('Button', 'careerfy-frame');
    }

    /**
     * Retrieve the widget icon.
     *
     * @since 1.1.0
     *
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon()
    {
        return 'fa fa-pencil';
    }

    /**
     * Retrieve the list of categories the widget belongs to.
     *
     * Used to determine where to display the widget in the editor.
     *
     * Note that currently Elementor supports only one category.
     * When multiple categories passed, Elementor uses the first one.
     *
     * @since 1.1.0
     *
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories()
    {
        return ['careerfy'];
    }

    /**
     * Register the widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.1.0
     *
     * @access protected
     */
    protected function register_controls()
    {
        global $rand_num;
        $rand_num = rand(10000000, 99909999);
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Button Settings', 'careerfy-frame'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'btn_styl',
            [
                'label' => __('Style', 'careerfy-frame'),
                'type' => Controls_Manager::SELECT2,
                'default' => 'view1',
                'options' => [
                    'view1' => __('Style 1', 'careerfy-frame'),
                    'view2' => __('Style 2', 'careerfy-frame'),
                ],
            ]
        );

        $this->add_control(
            'btn_txt',
            [
                'label' => __('Button Text', 'careerfy-frame'),
                'type' => Controls_Manager::TEXT,
            ]
        );
        $this->add_control(
            'btn_url',
            [
                'label' => __('Button URL', 'careerfy-frame'),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $atts = $this->get_settings_for_display();
        ob_start();

        $btn_styl = $atts['btn_styl'];
        $btn_txt = $atts['btn_txt'];
        $btn_url = $atts['btn_url'];

        $btn_class = 'careerfy-modren-btn';

        if ($btn_styl == 'view2') {
            $btn_class = 'careerfy-more-view4-btn';
        }

        if ($btn_txt != '') { ?>
            <div class="<?php echo($btn_class) ?>"><a href="<?php echo($btn_url) ?>"><?php echo($btn_txt) ?></a></div>
            <?php
        }

        $html = ob_get_clean();
        echo $html;
    }

    protected function content_template()
    { ?>
        <#
        var btn_styl = settings.btn_styl;
        var btn_txt = settings.btn_txt;
        var btn_url = settings.btn_url;
        var btn_class = 'careerfy-modren-btn';

        if (btn_styl == 'view2') {
        btn_class = 'careerfy-more-view4-btn';
        }

        #>
        <# if(btn_txt != '') { #>
        <div class="{{{btn_class}}}"><a href="#">{{{btn_txt}}}</a></div>
        <# } #>
    <?php }

}