<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Metro;

use \Redux;

$opt_name = Constants::$theme_options;

Redux::setSection( $opt_name,
	array(
		'title'   => 'Blog Settings',
		'id'      => 'blog_settings_section',
		'icon'    => 'el el-tags',
		'heading' => '',
		'fields'  => array(
			array(
				'id'       =>'blog_style',
				'type'     => 'image_select',
				'title'    => 'Blog/Archive Layout',
				'default'  => '1',
				'options'  => array(
					'1' => array(
						'title' => '<b>Layout 1</b>',
						'img'   => Helper::get_img( 'blog1.jpg' ),
					),
					'2' => array(
						'title' => '<b>Layout 2</b>',
						'img'   => Helper::get_img( 'blog2.jpg' ),
					),
					'3' => array(
						'title' => '<b>Layout 3</b>',
						'img'   => Helper::get_img( 'blog3.png' ),
					),
				),
			),
			array(
				'id'       => 'blog_date',
				'type'     => 'switch',
				'title'    => 'Display Date',
				'on'       => 'On',
				'off'      => 'Off',
				'default'  => true,
			),
			array(
				'id'       => 'blog_author_name',
				'type'     => 'switch',
				'title'    => 'Display Author Name',
				'on'       => 'On',
				'off'      => 'Off',
				'default'  => true,
			),
			array(
				'id'       => 'blog_comment_num',
				'type'     => 'switch',
				'title'    => 'Display Comment Number',
				'on'       => 'On',
				'off'      => 'Off',
				'default'  => true,
			),
			array(
				'id'       => 'blog_cats',
				'type'     => 'switch',
				'title'    => 'Display Categories',
				'on'       => 'On',
				'off'      => 'Off',
				'default'  => true,
			),
		)
	)
);
