<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Metro;

use \Redux;

$opt_name = Constants::$theme_options;

Redux::setSection( $opt_name,
	array(
		'title'   => 'Header',
		'id'      => 'header_section',
		'heading' => '',
		'icon'    => 'el el-flag',
		'fields'  => array(
			array(
				'id'       => 'resmenu_width',
				'type'     => 'slider',
				'title'    => 'Responsive Header Screen Width',
				'subtitle' => 'Screen width in which mobile menu activated. Recommended value is: 991',
				'default'  => 991,
				'min'      => 0,
				'step'     => 1,
				'max'      => 2000,
			),
			array(
				'id'       => 'sticky_menu',
				'type'     => 'switch',
				'title'    => 'Sticky Header',
				'on'       => 'Enabled',
				'off'      => 'Disabled',
				'default'  => true,
				'subtitle' => 'Show header at the top when scrolling down',
			),
			array(
				'id'       => 'top_bar',
				'type'     => 'switch',
				'title'    => 'Top Bar',
				'on'       => 'Enabled',
				'off'      => 'Disabled',
				'default'  => false,
			),
			array(
				'id'       => 'offcanvas_logo',
				'type'     => 'switch',
				'title'    => 'Offcanvas Logo',
				'on'       => 'Enabled',
				'off'      => 'Disabled',
				'default'  => true,
			),
			array(
				'id'       => 'side_logo_typo',
				'type'     => 'typography',
				'title'    => 'Logo typography',
				'text-align'  => false,
				'output' => array( '.main-header .additional-logo .logo' ),
				'required' => array( 'offcanvas_logo', '=', true )
			),
			array(
				'id'       => 'offcanvas_title',
				'type'     => 'text',
				'title'    => 'Offcanvas Menu Title',
				'default'  => '',
			),
			array(
				'id'       => 'offcanvas_sub_title',
				'type'     => 'text',
				'title'    => 'Offcanvas Sub Title',
				'default'  => 'Follow Us',
			),
			array(
				'id'       => 'offcanvas_socials',
				'type'     => 'switch',
				'title'    => 'Offcanvas Socials Icon',
				'on'       => 'Enabled',
				'off'      => 'Disabled',
				'default'  => true,
			),
			array(
				'id'       => 'top_bar_style',
				'type'     => 'image_select',
				'title'    => 'Top Bar Layout',
				'default'  => '1',
				'options' => array(
					'1' => array('title' => '<b>Layout 1</b>', 'img' => Helper::get_img( 'top1.png' )),
					'2' => array('title' => '<b>Layout 2</b>', 'img' => Helper::get_img( 'top2.png' )),
					'3' => array('title' => '<b>Layout 3</b>', 'img' => Helper::get_img( 'top3.png' )),
					'4' => array('title' => '<b>Layout 4</b>', 'img' => Helper::get_img( 'top3.png' )),
				),
				'required' => array( 'top_bar', '=', true )
			),
			array(
				'id'       => 'header_style',
				'type'     => 'image_select',
				'title'    => 'Header Layout',
				'default'  => '1',
				'options' => array(
					'1' => array('title' => '<b>Layout 1</b>', 'img' => Helper::get_img( 'header-1.png' )),
					'2' => array('title' => '<b>Layout 2</b>', 'img' => Helper::get_img( 'header-2.png' )),
					'3' => array('title' => '<b>Layout 3</b>', 'img' => Helper::get_img( 'header-3.png' )),
					'4' => array('title' => '<b>Layout 4</b>', 'img' => Helper::get_img( 'header-4.png' )),
					'5' => array('title' => '<b>Layout 5</b>', 'img' => Helper::get_img( 'header-5.png' )),
					'6' => array('title' => '<b>Layout 6</b>', 'img' => Helper::get_img( 'header-6.png' )),
					'7' => array('title' => '<b>Layout 7( Transparent Header )</b>', 'img' => Helper::get_img( 'header-7.png' )),
					'8' => array('title' => '<b>Layout 8</b>', 'img' => Helper::get_img( 'header-8.png' )),
					'9' => array('title' => '<b>Layout 9</b>', 'img' => Helper::get_img( 'header-8.png' )),
					'10' => array('title' => '<b>Layout 10</b>', 'img' => Helper::get_img( 'header-8.png' )),
					'11' => array('title' => '<b>Layout 11</b>', 'img' => Helper::get_img( 'header-8.png' )),
				),
			),
			array(
				'id'       => 'search_icon',
				'type'     => 'switch',
				'title'    => 'Search Icon',
				'on'       => 'Enabled',
				'off'      => 'Disabled',
				'default'  => true,
			),
			array(
				'id'       => 'account_icon',
				'type'     => 'switch',
				'title'    => 'Login/Account Icon',
				'on'       => 'Enabled',
				'off'      => 'Disabled',
				'default'  => true,
			),
			array(
				'id'       => 'ajax_sidebar',
				'type'     => 'switch',
				'title'    => 'Ajax cart sidebar',
				'on'       => 'Enabled',
				'off'      => 'Disabled',
				'default'  => true,
			),
			array(
				'id'       => 'carticon',
				'type'     => 'button_set',
				'title'    => 'Cart Icon',
				'options'  => array(
					'offscreen' => 'Offscreen',
					'link' => 'Link',
					'hidden' => 'Hidden',
				),
				'default' => 'offscreen',
			),
			array(
				'id'       => 'wishlist_icon',
				'type'     => 'switch',
				'title'    => 'Wishlist Icon',
				'on'       => 'Enabled',
				'off'      => 'Disabled',
				'default'  => true,
			),
			array(
				'id'       => 'wishlist_icon_mobile',
				'type'     => 'switch',
				'title'    => 'Show Wishlist Icon at Mobile',
				'on'       => 'Enabled',
				'off'      => 'Disabled',
				'default'  => false,
				'required' => array( 'wishlist_icon', 'equals', true )
			),
			array(
				'id'       => 'banner',
				'type'     => 'switch',
				'title'    => 'Banner',
				'on'       => 'Enabled',
				'off'      => 'Disabled',
				'default'  => true,
			),
			array(
				'id'       => 'breadcrumb',
				'type'     => 'switch',
				'title'    => 'Breadcrumb',
				'on'       => 'Enabled',
				'off'      => 'Disabled',
				'default'  => true,
				'required' => array( 'banner', 'equals', true )
			),
			array(
				'id'       => 'banner_search',
				'type'     => 'switch',
				'title'    => 'Banner Search',
				'on'       => 'Enabled',
				'off'      => 'Disabled',
				'default'  => true,
				'required' => array( 'banner', 'equals', true )
			),
			array(
				'id'       => 'bgtype',
				'type'     => 'button_set',
				'title'    => 'Banner Background Type',
				'options'  => array(
					'bgcolor' => 'Background Color',
					'bgimg'   => 'Background Image',
				),
				'default' => 'bgcolor',
				'required' => array( 'banner', 'equals', true )
			),
			array(
				'id'       => 'bgcolor',
				'type'     => 'color',
				'title'    => 'Banner Background Color',
				'validate' => 'color',
				'transparent' => false,
				'default' => '#f2f2f2',
				'required' => array( 'bgtype', 'equals', 'bgcolor' )
			),
			array(
				'id'       => 'bgimg',
				'type'     => 'media',
				'title'    => 'Banner Background Image',
				'default'  => array(
					'url'=> Helper::get_img( 'banner.jpg' )
				),
				'required' => array( 'bgtype', 'equals', 'bgimg' )
			),
			array(
				'id'       => 'bgopacity',
				'type'     => 'slider',
				'title'    => 'Banner Background Opacity (in %)',
				'min'      => 0,
				'max'      => 100,
				'step'     => 1,
				'default'  => 0,
				'display_value' => 'label',
				'required' => array( 'bgtype', 'equals', 'bgimg' )
			),
		)
	)
);
