<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Metro;

use \Redux;

$opt_name = Constants::$theme_options;

Redux::setSection( $opt_name, array(
	'title'   => 'Post Settings',
	'id'      => 'post_settings_section',
	'icon'    => 'el el-file-edit',
	'heading' => '',
	'fields'  => array(
		array(
			'id'      => 'post_date',
			'type'    => 'switch',
			'title'   => 'Display Post Date',
			'on'      => 'On',
			'off'     => 'Off',
			'default' => true,
		),
		array(
			'id'      => 'post_author_name',
			'type'    => 'switch',
			'title'   => 'Display Author Name',
			'on'      => 'On',
			'off'     => 'Off',
			'default' => true,
		),
		array(
			'id'      => 'post_comment_num',
			'type'    => 'switch',
			'title'   => 'Display Comment Number',
			'on'      => 'On',
			'off'     => 'Off',
			'default' => true,
		),
		array(
			'id'      => 'post_cats',
			'type'    => 'switch',
			'title'   => 'Display Categories',
			'on'      => 'On',
			'off'     => 'Off',
			'default' => true,
		),
		array(
			'id'      => 'post_tags',
			'type'    => 'switch',
			'title'   => 'Display Tags',
			'on'      => 'On',
			'off'     => 'Off',
			'default' => true,
		),
		array(
			'id'      => 'post_social',
			'type'    => 'switch',
			'title'   => 'Display Social Sharing',
			'on'      => 'On',
			'off'     => 'Off',
			'default' => true,
		),
		array(
			'id'      => 'post_share',
			'type'    => 'checkbox',
			'class'   => 'redux-custom-inline',
			'title'   => 'Social Sharing Icons',
			'options' => array(
				'facebook'  => 'Facebook',
				'twitter'   => 'Twitter',
				'linkedin'  => 'Linkedin',
				'pinterest' => 'Pinterest',
				'tumblr'    => 'Tumblr',
				'reddit'    => 'Reddit',
				'vk'        => 'Vk',
			),
			'default' => array(
				'facebook'  => '1',
				'twitter'   => '1',
				'linkedin'  => '1',
				'pinterest' => '1',
				'tumblr'    => '0',
				'reddit'    => '0',
				'vk'        => '0',
			),
			'required' => array( 'post_social', '=', true )
		),
		array(
			'id'      => 'post_about_author',
			'type'    => 'switch',
			'title'   => 'Display About Author',
			'on'      => 'On',
			'off'     => 'Off',
			'default' => false,
		),
		array(
			'id'      => 'post_pagination',
			'type'    => 'switch',
			'title'   => 'Display Previous/Next Post Link',
			'on'      => 'On',
			'off'     => 'Off',
			'default' => false,
		),
	)
) );
