<?php
/**
 *
 * @author RadiusTheme
 * @since 1.6
 * @version 1.0.1
 *
 */

// Security check
defined( 'ABSPATH' ) || die();

final class RtAjaxTemplateFileLoader {

	public function __construct() {
		// Hook Initialization
		add_action( 'wp_ajax_nopriv_load_template', [ $this, 'load_template' ] );
		add_action( 'wp_ajax_load_template', [ $this, 'load_template' ] );
	}

	public function load_template() {
        $template = isset($_GET['template']) ? sanitize_text_field($_GET['template']) : '';
        $part = isset($_GET['part']) ? sanitize_text_field($_GET['part']) : '';
        if ($template && $part) {
            wc_get_template_part('ajax/' . $template, $part);
        }
		wp_die();
	}

}

new RtAjaxTemplateFileLoader();