<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Metro;

use \Redux;

$opt_name = Constants::$theme_options;

Redux::setSection( $opt_name,
	array(
		'title'   => 'Colors',
		'id'      => 'color_section',
		'heading' => '',
		'icon'    => 'el el-eye-open',
		'fields'  => array(
			array(
				'id'       => 'section-color-sitewide',
				'type'     => 'section',
				'title'    => 'Sitewide Colors',
				'indent'   => true,
			),
			array(
				'id'       => 'color_type',
				'type'     => 'select',
				'title'    => 'Primary Color Scheme',
				'options'  => array(
					'black'  => 'Black',
					'red'    => 'Red',
					'orange' => 'Orange',
					'tomato' => 'Tomato',
					'custom' => 'Custom',
				),
				'default'  => 'black',
			),
			array(
				'id'       => 'primary_color',
				'type'     => 'color',
				'transparent' => false,
				'title'    => 'Primary Color',
				'default'  => '#e53935',
				'required' => array( 'color_type', '=', 'custom' )
			),
			array(
				'id'       => 'sitewide_color',
				'type'     => 'button_set',
				'title'    => 'Other Colors',
				'options'  => array(
					'primary' => 'Primary Color',
					'custom'  => 'Custom',
				),
				'default'  => 'primary',
				'subtitle' => 'Selecting Primary Color will hide some color options from the below settings and replace them with Primary Color',
			),
			array(
				'id'       => 'section-color-menu',
				'type'     => 'section',
				'title'    => 'Main Menu',
				'indent'   => true,
				'required' => array( 'sitewide_color', '=', 'custom' )
			),
			array(
				'id'       => 'menu_color',
				'type'     => 'color',
				'transparent' => false,
				'title'    => 'Menu Color',
				'default'  => '#111111',
				'required' => array( 'sitewide_color', '=', 'custom' )
			),
			array(
				'id'       => 'section-color-submenu',
				'type'     => 'section',
				'title'    => 'Sub Menu',
				'indent'   => true,
			),
			array(
				'id'       => 'submenu_color',
				'type'     => 'color',
				'transparent' => false,
				'title'    => 'Submenu Color',
				'default'  => '#111111',
				'required' => array( 'sitewide_color', '=', 'custom' )
			),
			array(
				'id'       => 'submenu_hover_color',
				'type'     => 'color',
				'transparent' => false,
				'title'    => 'Submenu Hover Color',
				'default'  => '#ffffff',
			),
			array(
				'id'       => 'submenu_hover_bgcolor',
				'type'     => 'color',
				'transparent' => false,
				'title'    => 'Submenu Hover Background Color',
				'default'  => '#111111',
				'required' => array( 'sitewide_color', '=', 'custom' )
			),
			array(
				'id'       => 'section-color-banner',
				'type'     => 'section',
				'title'    => 'Banner/Breadcrumb Area',
				'indent'   => true,
			),
			array(
				'id'       => 'banner_title_color',
				'type'     => 'color',
				'transparent' => false,
				'title'    => 'Banner Title Color',
				'default'  => '#000',
			),
			array(
				'id'       => 'breadcrumb_link_color',
				'type'     => 'color',
				'transparent' => false,
				'title'    => 'Breadcrumb Link Color',
				'default'  => '#949494',
			),
			array(
				'id'       => 'breadcrumb_link_hover_color',
				'type'     => 'color',
				'transparent' => false,
				'title'    => 'Breadcrumb Link Hover Color',
				'default'  => '#111111',
				'required' => array( 'sitewide_color', '=', 'custom' )
			),
			array(
				'id'       => 'breadcrumb_active_color',
				'type'     => 'color',
				'transparent' => false,
				'title'    => 'Active Breadcrumb Color',
				'default'  => '#000000',
			),
			array(
				'id'       => 'breadcrumb_seperator_color',
				'type'     => 'color',
				'transparent' => false,
				'title'    => 'Breadcrumb Seperator Color',
				'default'  => '#686868',
			),
			array(
				'id'       => 'section-color-footer',
				'type'     => 'section',
				'title'    => 'Footer Area',
				'indent'   => true,
			),
			array(
				'id'       => 'footer_bgcolor',
				'type'     => 'color',
				'transparent' => false,
				'title'    => 'Footer Background Color',
				'default'  => '#111111',
			),
			array(
				'id'       => 'footer_title_color',
				'type'     => 'color',
				'transparent' => false,
				'title'    => 'Footer Title Text Color',
				'default'  => '#ffffff',
			),
			array(
				'id'       => 'footer_color',
				'type'     => 'color',
				'transparent' => false,
				'title'    => 'Footer Body Text Color',
				'default'  => '#cccccc',
			),
			array(
				'id'       => 'footer_link_color',
				'type'     => 'color',
				'transparent' => false,
				'title'    => 'Footer Body Link Color',
				'default'  => '#cccccc',
			),
			array(
				'id'       => 'footer_link_hover_color',
				'type'     => 'color',
				'transparent' => false,
				'title'    => 'Footer Body Link Hover Color',
				'default'  => '#ffffff',
			),
		)
	)
);
