@if(isset($report['results'][$name]))
    <div class="border-top">
        <div class="card-body">
            <div class="row">
                <div class="col">
                    <div class="row">
                        <div class="col-12 col-lg-4">
                            <div class="d-flex align-items-center">
                                @include('reports.partials.status')

                                <div class="text-truncate font-weight-medium">{{ __('Favicon') }}</div>
                            </div>
                        </div>

                        <div class="col-12 col-lg-8">
                            @if($report['results'][$name]['passed'])
                                <div>
                                    {{ __('The webpage has a favicon.') }}
                                </div>

                                <div class="small text-muted mt-1">
                                    <a href="{{ $report['results'][$name]['value'] }}" rel="nofollow noreferrer noopener" target="_blank" class="text-break">{{ $report['results'][$name]['value'] }}</a>
                                </div>
                            @else
                                @if($report->user_id == 0)
                                    @include('reports.partials.limited')
                                @else
                                    @foreach($report['results'][$name]['errors'] as $error => $details)
                                        <div class="{{ (!$loop->first) ? 'mt-3' : ''}}">
                                            @if($error == 'missing')
                                                {{ __('The webpage does not have a favicon.') }}
                                            @endif
                                        </div>
                                    @endforeach
                                @endif
                            @endif
                        </div>
                    </div>
                </div>

                <div class="col-auto">
                    <a href="#collapse{{ $name }}" class="text-secondary d-flex align-items-center" data-toggle="collapse" role="button" aria-expanded="false" aria-controls="collapse{{ $name }}" data-tooltip="true" title="{{ __('More') }}">
                        @include('icons.info', ['class' => 'fill-current width-4 height-4'])&#8203;
                    </a>
                </div>
            </div>
        </div>
    </div>

    <div class="collapse{{ Auth::check() && Auth::user()->default_export_detailed ? ' d-print-block' : '' }}" id="collapse{{ $name }}">
        <div class="card-body pt-0">
            <div class="alert alert-secondary mb-0">
                {{ __('The favicon is the icon that is being displayed in the browser\'s tab, when the webpage is being bookmarked, and sometimes even in search engine results.') }}<hr>

                <div class="row">
                    <div class="col-12 col-md">
                        {{ __('Learn more') }}
                    </div>
                    <div class="col-12 col-md-auto">
                        <a href="https://developers.google.com/search/docs/advanced/appearance/favicon-in-search" class="alert-link font-weight-medium d-flex align-items-center" target="_blank" rel="nofollow noreferrer noopener">Google @include('icons.external', ['class' => 'fill-current width-3 height-3 ' . (__('lang_dir') == 'rtl' ? 'mr-1' : 'ml-1')])</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endif
