<?php
if ( post_password_required() ) {
	return;
}?>

<div id="comments" class="comments-area"><?php
	if ( have_comments() ) : ?>

	    <h3><?php comments_number(esc_html__('No Comments','accu'), esc_html__('Comment ( 1 )','accu'), esc_html__('Comments ( % )','accu') );?></h3>

		<?php the_comments_navigation(); ?>

        <ul class="commentlist">
     		<?php wp_list_comments( array( 'callback' => 'accu_comment_style' ) ); ?>
        </ul>

        <?php the_comments_navigation();

    endif;

	if ( ! comments_open() && get_comments_number() && post_type_supports( get_post_type(), 'comments' ) ) : ?>
        <p class="nocomments"><?php esc_html_e( 'Comments are closed.','accu'); ?></p><?php
    endif;

	$req = get_option( 'require_name_email' );


    $fields = array(
		'author' => "<div class='column dt-sc-one-half'>
			<p>
				<label for='author'>".esc_html__("Name",'accu'). ( $req ? ' <span class="required">*</span>' : '' ) ."</label>
				<input id='author' name='author' type='text' required />
			</p>",

		'email'  => "<p>
				<label for='author'>".esc_html__("Email",'accu'). ( $req ? ' <span class="required">*</span>' : '' ) ."</label>
				<input id='email' name='email' type='email' required />
			</p>
		</div>"
    );

    $comment = "<div class='column dt-sc-one-half first'>
    	<label for='comment'>" . esc_html__( 'Comment', 'accu' ) . "</label>
    	<textarea id='comment' name='comment' cols='5' rows='3'></textarea>
    </div>";

	if( cs_get_option('privacy-commentform') == "true" ) {
		$content = do_shortcode( cs_get_option('privacy-commentform-msg') );
		$fields['comment-form-dt-privatepolicy'] = '<p class="comment-form-dt-privatepolicy">
			<input id="comment-form-dt-privatepolicy" name="comment-form-dt-privatepolicy" type="checkbox" value="yes">
			<label for="comment-form-dt-privatepolicy">'.$content.'</label>
		</p>';
	}    
	
	comment_form( array(
		'title_reply'          => esc_html__( 'Leave a Comment','accu' ),
		'fields'               => $fields,
		'comment_field'        => $comment,
		'comment_notes_before' => '',
		'comment_notes_after'  => '',
		'label_submit'         => esc_html__('Comment','accu')
	) );?></div><!-- .comments-area -->