<?php
/**
 * Theme Functions
 *
 * @package DTtheme
 * @author DesignThemes
 * @link http://wedesignthemes.com
 */
define( 'ACCU_THEME_DIR', get_template_directory() );
define( 'ACCU_THEME_URI', get_template_directory_uri() );
define( 'ACCU_CORE_PLUGIN', WP_PLUGIN_DIR.'/designthemes-core-features' );

if (function_exists ('wp_get_theme')) :
	$themeData = wp_get_theme();
	define( 'ACCU_THEME_NAME', $themeData->get('Name'));
	define( 'ACCU_THEME_VERSION', $themeData->get('Version'));
endif;

add_action( 'after_setup_theme', 'accu_i18n' );
if (! function_exists('accu_i18n')) {
    function accu_i18n() {
        load_theme_textdomain( 'accu', ACCU_THEME_DIR . '/languages' );
    }
}

if (! function_exists('accu_load_theme_files')) {
    function accu_load_theme_files() {
/* ---------------------------------------------------------------------------
 * Loads Kirki
 * ---------------------------------------------------------------------------*/
require_once( ACCU_THEME_DIR .'/kirki/index.php' );

/* ---------------------------------------------------------------------------
 * Loads Codestar
 * ---------------------------------------------------------------------------*/
require_once ACCU_THEME_DIR .'/cs-framework/cs-framework.php';

if( !defined( 'CS_ACTIVE_TAXONOMY' ) ) { define( 'CS_ACTIVE_TAXONOMY',   false ); }
if( !defined( 'CS_ACTIVE_SHORTCODE' ) ) { define( 'CS_ACTIVE_SHORTCODE',  false ); }
if( !defined( 'CS_ACTIVE_CUSTOMIZE' ) ) { define( 'CS_ACTIVE_CUSTOMIZE',  false ); }

/* ---------------------------------------------------------------------------
 * Create function to get theme options
 * --------------------------------------------------------------------------- */
function accu_cs_get_option($key, $value = '') {

	$v = cs_get_option( $key );

	if ( !empty( $v ) ) {
		return $v;
	} else {
		return $value;
	}
}

/* ---------------------------------------------------------------------------
 * Loads Theme Textdomain
 * ---------------------------------------------------------------------------*/ 


/* ---------------------------------------------------------------------------
 * Loads the Admin Panel Style
 * ---------------------------------------------------------------------------*/
function accu_admin_scripts() {
	wp_enqueue_style('accu-admin', ACCU_THEME_URI .'/cs-framework-override/style.css');
}
add_action( 'admin_enqueue_scripts', 'accu_admin_scripts' );

/* ---------------------------------------------------------------------------
 * Loads Theme Functions
 * ---------------------------------------------------------------------------*/

// Functions --------------------------------------------------------------------
require_once( ACCU_THEME_DIR .'/framework/register-functions.php' );

// Header -----------------------------------------------------------------------
require_once( ACCU_THEME_DIR .'/framework/register-head.php' );

// Hooks ------------------------------------------------------------------------
require_once( ACCU_THEME_DIR .'/framework/register-hooks.php' );

// Post Functions ---------------------------------------------------------------
require_once( ACCU_THEME_DIR .'/framework/register-post-functions.php' );
new accu_post_functions;

// Widgets ----------------------------------------------------------------------
add_action( 'widgets_init', 'accu_widgets_init' );
function accu_widgets_init() {
	require_once( ACCU_THEME_DIR .'/framework/register-widgets.php' );
}

// Plugins ---------------------------------------------------------------------- 
require_once( ACCU_THEME_DIR .'/framework/register-plugins.php' );

// WooCommerce ------------------------------------------------------------------
if( function_exists( 'is_woocommerce' ) && ! class_exists ( 'DTWooPlugin' ) ){
	require_once( ACCU_THEME_DIR .'/framework/register-woocommerce.php' );
}

// WP Store Locator -------------------------------------------------------------
if( class_exists( 'WP_Store_locator' ) ){
	require_once( ACCU_THEME_DIR .'/framework/register-storelocator.php' );
}

// Register Gutenberg -----------------------------------------------------------
require_once( ACCU_THEME_DIR .'/framework/register-gutenberg-editor.php' );

    }
}
add_action( 'after_setup_theme', 'accu_load_theme_files', 20 );