<?php
function accu_kirki_config() {
	return 'accu_kirki_config';
}

function accu_defaults( $key = '' ) {
	$defaults = array();

	# site identify
	$defaults['use-custom-logo'] = '1';
	$defaults['custom-logo'] = ACCU_THEME_URI.'/images/logo.png';
	$defaults['custom-light-logo'] = ACCU_THEME_URI.'/images/light-logo.png';
	$defaults['site_icon'] = ACCU_THEME_URI.'/images/favicon.ico';

	# site layout
	$defaults['site-layout'] = 'wide';

	# site skin
	$defaults['primary-color']      = '#a7b3ab';
	$defaults['secondary-color']    = '#68605e';
	$defaults['tertiary-color']     = '#e9f3e1';
	$defaults['body-bg-color']      = '';
	$defaults['body-content-color'] = '#1f1f1f';
	$defaults['body-a-color']       = '#535353';
	$defaults['body-a-hover-color'] = '#a7b3ab';	

	$defaults['custom-title-color'] = '#ffffff';

	# site breadcrumb
	$defaults['customize-breadcrumb-title-typo'] = '1';
	$defaults['breadcrumb-title-typo'] = array( 'font-family' => 'Quicksand',
		'variant' => '500',
		'subsets' => array( 'latin-ext' ),
		'font-size' => '40px',
		'line-height' => 'normal',
		'letter-spacing' => '1px',
		'color' => '#535353',
		'text-align' => 'unset',
		'text-transform' => 'none' );
	$defaults['customize-breadcrumb-typo'] = '0';
	$defaults['breadcrumb-typo'] = array( 'font-family' => 'Raleway',
		'variant' => 'regular',
		'subsets' => array( 'latin-ext' ),
		'font-size' => '14px',
		'line-height' => 'normal',
		'letter-spacing' => '0px',
		'color' => '#2a2929',
		'text-align' => 'unset',
		'text-transform' => 'none' );

	# site footer
	$defaults['customize-footer-title-typo'] = '1';
	$defaults['footer-title-typo'] = array( 'font-family' => 'Quicksand',
		'variant' => 'regular',
		'subsets' => array( 'latin-ext' ),
		'font-size' => '20px',
		'line-height' => '36px',
		'letter-spacing' => '0',
		'color' => '#535353',
		'text-align' => 'left',
		'text-transform' => 'capitalize' );
	$defaults['customize-footer-content-typo'] = '1';
	$defaults['footer-content-typo'] = array( 'font-family' => 'Raleway',
		'variant' => 'regular',
		'subsets' => array( 'latin-ext' ),
		'font-size' => '14px',
		'line-height' => '26px',
		'letter-spacing' => '0px',
		'color' => '#1f1f1f',
		'text-align' => 'left',
		'text-transform' => 'none' );
	$defaults['footer-content-a-color'] = '#1f1f1f';

	# site typography
	$defaults['customize-body-h1-typo'] = '1';
	$defaults['h1'] = array(
		'font-family' => 'Quicksand',
		'variant' => '500',
		'font-size' => '30px',
		'line-height' => 'normal',
		'letter-spacing' => '1px',
		'color' => '#535353',
		'text-align' => 'unset',
		'text-transform' => 'none'
	);
	$defaults['customize-body-h2-typo'] = '1';
	$defaults['h2'] = array(
		'font-family' => 'Quicksand',
		'variant' => '500',
		'font-size' => '24px',
		'line-height' => 'normal',
		'letter-spacing' => '1px',
		'color' => '#535353',
		'text-align' => 'unset',
		'text-transform' => 'none'
	);
	$defaults['customize-body-h3-typo'] = '1';
	$defaults['h3'] = array(
		'font-family' => 'Quicksand',
		'variant' => '500',
		'font-size' => '18px',
		'line-height' => 'normal',
		'letter-spacing' => '1px',
		'color' => '#535353',
		'text-align' => 'unset',
		'text-transform' => 'none'
	);
	$defaults['customize-body-h4-typo'] = '1';
	$defaults['h4'] = array(
		'font-family' => 'Quicksand',
		'variant' => '500',
		'font-size' => '16px',
		'line-height' => 'normal',
		'letter-spacing' => '1px',
		'color' => '#535353',
		'text-align' => 'unset',
		'text-transform' => 'none'
	);
	$defaults['customize-body-h5-typo'] = '1';
	$defaults['h5'] = array(
		'font-family' => 'Quicksand',
		'variant' => '500',
		'font-size' => '14px',
		'line-height' => 'normal',
		'letter-spacing' => '1px',
		'color' => '#535353',
		'text-align' => 'unset',
		'text-transform' => 'none'
	);
	$defaults['customize-body-h6-typo'] = '1';
	$defaults['h6'] = array(
		'font-family' => 'Quicksand',
		'variant' => 'regular',
		'font-size' => '13px',
		'line-height' => 'normal',
		'letter-spacing' => '0px',
		'color' => '#1c1c1c',
		'text-align' => 'unset',
		'text-transform' => 'none'
	);
	$defaults['customize-body-content-typo'] = '1';
	$defaults['body-content-typo'] = array(
		'font-family' => 'Raleway',
		'variant' => 'normal',
		'font-size' => '14px',
		'line-height' => '26px',
		'letter-spacing' => 'normal',
		'color' => '#1f1f1f',
		'text-align' => 'unset',
		'text-transform' => 'none'
	);

	$defaults['footer-content-a-color'] = '';
	$defaults['footer-content-a-hover-color'] = '';	

	if( !empty( $key ) && array_key_exists( $key, $defaults) ) {
		return $defaults[$key];
	}

	return '';
}

function accu_image_positions() {

	$positions = array( "top left" => esc_attr__('Top Left','accu'),
		"top center"    => esc_attr__('Top Center','accu'),
		"top right"     => esc_attr__('Top Right','accu'),
		"center left"   => esc_attr__('Center Left','accu'),
		"center center" => esc_attr__('Center Center','accu'),
		"center right"  => esc_attr__('Center Right','accu'),
		"bottom left"   => esc_attr__('Bottom Left','accu'),
		"bottom center" => esc_attr__('Bottom Center','accu'),
		"bottom right"  => esc_attr__('Bottom Right','accu'),
	);

	return $positions;
}

function accu_image_repeats() {

	$image_repeats = array( "repeat" => esc_attr__('Repeat','accu'),
		"repeat-x"  => esc_attr__('Repeat in X-axis','accu'),
		"repeat-y"  => esc_attr__('Repeat in Y-axis','accu'),
		"no-repeat" => esc_attr__('No Repeat','accu')
	);

	return $image_repeats;
}

function accu_border_styles() {

	$image_repeats = array(
		"none"	 => esc_attr__('None','accu'),
		"dotted" => esc_attr__('Dotted','accu'),
		"dashed" => esc_attr__('Dashed','accu'),
		"solid"	 => esc_attr__('Solid','accu'),
		"double" => esc_attr__('Double','accu'),
		"groove" => esc_attr__('Groove','accu'),
		"ridge"	 => esc_attr__('Ridge','accu'),
	);

	return $image_repeats;
}

function accu_animations() {

	$animations = array(
		'' 					 => esc_html__('Default','accu'),	
		"bigEntrance"        =>  esc_attr__("bigEntrance",'accu'),
        "bounce"             =>  esc_attr__("bounce",'accu'),
        "bounceIn"           =>  esc_attr__("bounceIn",'accu'),
        "bounceInDown"       =>  esc_attr__("bounceInDown",'accu'),
        "bounceInLeft"       =>  esc_attr__("bounceInLeft",'accu'),
        "bounceInRight"      =>  esc_attr__("bounceInRight",'accu'),
        "bounceInUp"         =>  esc_attr__("bounceInUp",'accu'),
        "bounceOut"          =>  esc_attr__("bounceOut",'accu'),
        "bounceOutDown"      =>  esc_attr__("bounceOutDown",'accu'),
        "bounceOutLeft"      =>  esc_attr__("bounceOutLeft",'accu'),
        "bounceOutRight"     =>  esc_attr__("bounceOutRight",'accu'),
        "bounceOutUp"        =>  esc_attr__("bounceOutUp",'accu'),
        "expandOpen"         =>  esc_attr__("expandOpen",'accu'),
        "expandUp"           =>  esc_attr__("expandUp",'accu'),
        "fadeIn"             =>  esc_attr__("fadeIn",'accu'),
        "fadeInDown"         =>  esc_attr__("fadeInDown",'accu'),
        "fadeInDownBig"      =>  esc_attr__("fadeInDownBig",'accu'),
        "fadeInLeft"         =>  esc_attr__("fadeInLeft",'accu'),
        "fadeInLeftBig"      =>  esc_attr__("fadeInLeftBig",'accu'),
        "fadeInRight"        =>  esc_attr__("fadeInRight",'accu'),
        "fadeInRightBig"     =>  esc_attr__("fadeInRightBig",'accu'),
        "fadeInUp"           =>  esc_attr__("fadeInUp",'accu'),
        "fadeInUpBig"        =>  esc_attr__("fadeInUpBig",'accu'),
        "fadeOut"            =>  esc_attr__("fadeOut",'accu'),
        "fadeOutDownBig"     =>  esc_attr__("fadeOutDownBig",'accu'),
        "fadeOutLeft"        =>  esc_attr__("fadeOutLeft",'accu'),
        "fadeOutLeftBig"     =>  esc_attr__("fadeOutLeftBig",'accu'),
        "fadeOutRight"       =>  esc_attr__("fadeOutRight",'accu'),
        "fadeOutUp"          =>  esc_attr__("fadeOutUp",'accu'),
        "fadeOutUpBig"       =>  esc_attr__("fadeOutUpBig",'accu'),
        "flash"              =>  esc_attr__("flash",'accu'),
        "flip"               =>  esc_attr__("flip",'accu'),
        "flipInX"            =>  esc_attr__("flipInX",'accu'),
        "flipInY"            =>  esc_attr__("flipInY",'accu'),
        "flipOutX"           =>  esc_attr__("flipOutX",'accu'),
        "flipOutY"           =>  esc_attr__("flipOutY",'accu'),
        "floating"           =>  esc_attr__("floating",'accu'),
        "hatch"              =>  esc_attr__("hatch",'accu'),
        "hinge"              =>  esc_attr__("hinge",'accu'),
        "lightSpeedIn"       =>  esc_attr__("lightSpeedIn",'accu'),
        "lightSpeedOut"      =>  esc_attr__("lightSpeedOut",'accu'),
        "pullDown"           =>  esc_attr__("pullDown",'accu'),
        "pullUp"             =>  esc_attr__("pullUp",'accu'),
        "pulse"              =>  esc_attr__("pulse",'accu'),
        "rollIn"             =>  esc_attr__("rollIn",'accu'),
        "rollOut"            =>  esc_attr__("rollOut",'accu'),
        "rotateIn"           =>  esc_attr__("rotateIn",'accu'),
        "rotateInDownLeft"   =>  esc_attr__("rotateInDownLeft",'accu'),
        "rotateInDownRight"  =>  esc_attr__("rotateInDownRight",'accu'),
        "rotateInUpLeft"     =>  esc_attr__("rotateInUpLeft",'accu'),
        "rotateInUpRight"    =>  esc_attr__("rotateInUpRight",'accu'),
        "rotateOut"          =>  esc_attr__("rotateOut",'accu'),
        "rotateOutDownRight" =>  esc_attr__("rotateOutDownRight",'accu'),
        "rotateOutUpLeft"    =>  esc_attr__("rotateOutUpLeft",'accu'),
        "rotateOutUpRight"   =>  esc_attr__("rotateOutUpRight",'accu'),
        "shake"              =>  esc_attr__("shake",'accu'),
        "slideDown"          =>  esc_attr__("slideDown",'accu'),
        "slideExpandUp"      =>  esc_attr__("slideExpandUp",'accu'),
        "slideLeft"          =>  esc_attr__("slideLeft",'accu'),
        "slideRight"         =>  esc_attr__("slideRight",'accu'),
        "slideUp"            =>  esc_attr__("slideUp",'accu'),
        "stretchLeft"        =>  esc_attr__("stretchLeft",'accu'),
        "stretchRight"       =>  esc_attr__("stretchRight",'accu'),
        "swing"              =>  esc_attr__("swing",'accu'),
        "tada"               =>  esc_attr__("tada",'accu'),
        "tossing"            =>  esc_attr__("tossing",'accu'),
        "wobble"             =>  esc_attr__("wobble",'accu'),
        "fadeOutDown"        =>  esc_attr__("fadeOutDown",'accu'),
        "fadeOutRightBig"    =>  esc_attr__("fadeOutRightBig",'accu'),
        "rotateOutDownLeft"  =>  esc_attr__("rotateOutDownLeft",'accu')
    );

	return $animations;
}

function accu_custom_fonts( $standard_fonts ){

	$custom_fonts = array();

	$fonts = cs_get_option('custom_font_fields');
	if( is_countable( $fonts ) && count( $fonts ) > 0 ):
		foreach( $fonts as $font ):
			$custom_fonts[$font['custom_font_name']] = array(
				'label' => $font['custom_font_name'],
				'variants' => array( '100', '100italic', '200', '200italic', '300', '300italic', 'regular', 'italic', '500', '500italic', '600', '600italic', '700', '700italic', '800', '800italic', '900', '900italic' ),
				'stack' => $font['custom_font_name'] . ', sans-serif'
			);
		endforeach;
	endif;

	return array_merge_recursive( $custom_fonts, $standard_fonts );
}
add_filter( 'kirki/fonts/standard_fonts', 'accu_custom_fonts', 20 );