<?php
/**
 * View: Default Template for Events
 *
 * Override this template in your own theme by creating a file at:
 * [your-theme]/tribe/events/v2/default-template.php
 *
 * See more documentation about our views templating system.
 *
 * @link http://evnt.is/1aiy
 *
 * @version 5.0.0
 */

use Tribe\Events\Views\V2\Template_Bootstrap;

get_header();

$global_breadcrumb = cs_get_option( 'show-breadcrumb' );
$container_class = 'container';

	if( is_singular('tribe_events') ) { 

		$settings = get_post_meta(get_the_ID(),'_custom_settings',TRUE);
		$settings = is_array( $settings ) ?  array_filter( $settings )  : array();

		if( !empty( $global_breadcrumb ) ) {

			if( isset( $settings['enable-sub-title'] ) && $settings['enable-sub-title'] ) {
				$header_class = $settings['breadcrumb_position'];
			}
		}

		$post_style = array_key_exists( "event-post-style", $settings ) ? $settings['event-post-style'] : "type1";
		switch( $post_style ):
			case 'type2':
                $container_class = "event-type2-fullwidth";
            break;
            case 'type5':
                $container_class = "event-type5-fullwidth";
            break;
            default:
                $container_class = "container";
            break;
        endswitch;
	}

    $settings = get_post_meta($post->ID,'_tpl_default_settings',TRUE);
    $settings = is_array( $settings ) ?  array_filter( $settings )  : array();
    $bcsettings = isset( $settings['breadcrumb_background'] ) ? $settings['breadcrumb_background'] : array();
    $inline_style = accu_breadcrumb_css( $bcsettings );
    $global_breadcrumb = cs_get_option( 'show-breadcrumb' );

    $header_class = '';
    if( !isset( $settings['enable-sub-title'] ) || !$settings['enable-sub-title']  ) {
        if( isset( $settings['show_slider'] ) && $settings['show_slider'] ) {
            if( isset( $settings['slider_type'] ) ) {
                $header_class =  $settings['slider_position'];
            }
        }
    }
    
    if( !empty( $global_breadcrumb ) ) {
        if( isset( $settings['enable-sub-title'] ) && $settings['enable-sub-title'] ) {
            $header_class = $settings['breadcrumb_position'];
		} else {
			$header_class = cs_get_option( 'breadcrumb-position' );
		}
	}?>
<!-- ** Header Wrapper ** -->
<div id="header-wrapper" class="<?php echo esc_attr($header_class); ?>">

    <!-- **Header** -->
    <header id="header" class="<?php echo esc_attr($header_class); ?>">

        <div class="container"><?php
            /**
             * accu_header hook.
             * 
             * @hooked accu_vc_header_template - 10
             *
             */
            do_action( 'accu_header' ); ?>
        </div>
    </header><!-- **Header - End ** -->

    <!-- ** Breadcrumb ** -->
    <?php
    	if( !empty( $global_breadcrumb ) ) {

    		$bstyle = accu_cs_get_option( 'breadcrumb-style', 'default' );

    		if( is_singular('tribe_events') ) {

    			if( isset( $settings['enable-sub-title'] ) && $settings['enable-sub-title'] ) {

    				$breadcrumbs = array();

                	$category = tribe_get_event_taxonomy( get_the_ID(), array( 'before' => '', 'sep' => ',', 'after' => '') );
                	if( $category ) {
                    	$breadcrumbs[] = $category;
                	}

                	$breadcrumbs[] = the_title( '<span class="current">', '</span>', false );
                	$style = accu_breadcrumb_css( $settings['breadcrumb_background'] );

                	echo '<section class="main-title-section-wrapper '.esc_attr($bstyle).'" style="'.esc_attr($style).'">';
                    echo '  <div class="main-title-section-bg" '. $style.'></div>';
                	echo '  <div class="container">';
                	echo '      <div class="main-title-section">'.the_title( '<h1>', '</h1>',false ).'</div>';
                	echo        accu_new_breadcrumbs( $breadcrumbs );
                	echo '  </div>';
                	echo '</section>';    				
    			}
    		} else {

    			$separator = '<span class="'.accu_cs_get_option( 'breadcrumb-delimiter', 'fa default' ).'"></span>';
    			$breadcrumbs[] = str_replace( ' &#8250; ', $separator . '<span class="current">', tribe_get_events_title().'</span>' );
    			$title = accu_events_title();
				echo '<section class="main-title-section-wrapper '.esc_attr($bstyle).'">';
                echo '  <div class="main-title-section-bg" style="'. $inline_style.'"></div>';
    			echo '  <div class="container">';
    			echo '      <div class="main-title-section"> <h1>'.$title.' </h1> </div>';
    			echo        accu_new_breadcrumbs( $breadcrumbs );
    			echo '  </div>';
    			echo '</section>';
    		}
    	}
    ?>
    <!-- ** Breadcrumb End ** -->
    </div>
</div><!-- ** Header Wrapper - End ** -->

<!-- **Main** -->
<div id="main">

    <!-- ** Container ** -->
    <div class="<?php echo esc_attr($container_class); ?>">
    	<div id="tribe-events-pg-template" class="tribe-events-pg-template">
<?php 
echo tribe( Template_Bootstrap::class )->get_view_html(); ?>

</div> <!-- #tribe-events-pg-template -->
    </div>
    <!-- ** Container End ** -->

</div><!-- **Main - End ** -->
<?php get_footer(); ?>
