;(function($) {
    "use strict"

    var customTypography  = function() {
    	var typographyCLS = '[class^="font-size-"], [class*=" font-size-"], ' +
        	'[class^="mobi-font-size-"], [class*=" mobi-font-size-"], ' +
        	'[class^="smobi-font-size-"], [class*=" smobi-font-size-"], ' +
        	'[class^="line-height-"], [class*=" line-height-"], ' +
        	'[class^="mobi-line-height-"], [class*=" mobi-line-height-"], ' +
        	'[class^="smobi-line-height-"], [class*=" smobi-line-height-"]';
        $(typographyCLS).each(function () {
        	var t = $(this),
	    	 	cls = t.attr("class").split(" "),
	    	 	desktopFS, mobiFS, smobiFS, desktopLH, mobiLH, smobiLH;
	    	$(cls).each(function(i, e) {
	    		( e.indexOf("font-size-") == 0 ) && ( desktopFS = e.replace("font-size-", "") ),
	    		( e.indexOf("mobi-font-size-") == 0 ) && ( mobiFS = e.replace("mobi-font-size-", "") ),
	    		( e.indexOf("smobi-font-size-") == 0 ) && ( smobiFS = e.replace("smobi-font-size-", "") ),
	    		( e.indexOf("line-height-") == 0 ) && ( desktopLH = e.replace("line-height-", "") ),
	    		( e.indexOf("mobi-line-height-") == 0 ) && ( mobiLH = e.replace("mobi-line-height-", "") ),
	    		( e.indexOf("smobi-line-height-") == 0 ) && ( smobiLH = e.replace("smobi-line-height-", "") )
	    	});

	    	( desktopFS && !mobiFS ) && ( mobiFS = desktopFS ),
	    	( mobiFS && !smobiFS ) && ( smobiFS = mobiFS ),
	    	( desktopLH && !mobiLH ) && ( mobiLH = desktopLH ),
	    	( mobiLH && !smobiLH ) && ( smobiLH = mobiLH )

        	$(window).on("load resize", function () {
        		var mode = 'desktop';

        	    if ( matchMedia( 'only screen and (max-width: 991px)' ).matches )
	                mode = 'mobile';

	            if ( matchMedia( 'only screen and (max-width: 767px)' ).matches )
	                mode = 'smobile';

	            if ( 'desktop' == mode ) {
	            	desktopFS && t.css("font-size", desktopFS)
	            	desktopLH && t.css("line-height", desktopLH)
	            }

	            if ( 'mobile' == mode ) {
	            	mobiFS && t.css("font-size", mobiFS)
	            	mobiLH && t.css("line-height", mobiLH)
	            }

	            if ( 'smobile' == mode ) {
	            	smobiFS && t.css("font-size", smobiFS)
	            	smobiLH && t.css("line-height", smobiLH)
	            }
		    })
        })
    };

    var customMaxWidth  = function() {
    	var cls = '[class^="max-width-"], [class*=" max-width-"], ' +
        	'[class^="mobi-max-width-"], [class*=" mobi-max-width-"], ' +
        	'[class^="smobi-max-width-"], [class*=" smobi-max-width-"]';
        $(cls).each(function () {
        	var t = $(this),
	    	 	cls = t.attr("class").split(" "),
	    	 	desktopMW, mobiMW, smobiMW;
	    	$(cls).each(function(i, e) {
	    		( e.indexOf("max-width-") == 0 ) && ( desktopMW = e.replace("max-width-", "") ),
	    		( e.indexOf("mobi-max-width-") == 0 ) && ( mobiMW = e.replace("mobi-max-width-", "") ),
	    		( e.indexOf("smobi-max-width-") == 0 ) && ( smobiMW = e.replace("smobi-max-width-", "") )
	    	});

	    	( desktopMW && !mobiMW ) && ( mobiMW = desktopMW ),
	    	( mobiMW && !smobiMW ) && ( smobiMW = mobiMW )

        	$(window).on("load resize", function () {
        		var mode = 'desktop';

        	    if ( matchMedia( 'only screen and (max-width: 991px)' ).matches )
	                mode = 'mobile';

	            if ( matchMedia( 'only screen and (max-width: 767px)' ).matches )
	                mode = 'smobile';

	            if ( 'desktop' == mode ) {
	            	desktopMW && t.css("max-width", desktopMW)
	            }

	            if ( 'mobile' == mode ) {
	            	mobiMW && t.css("max-width", mobiMW)
	            }

	            if ( 'smobile' == mode ) {
	            	smobiMW && t.css("max-width", smobiMW)
	            }
		    })
        })
    };

    // Dom Ready
    $(function() {
        $(".master-accordion").masterAccordion();
        $(".master-spacer").masterSpacer();
        $(".master-carousel-box").masterCarouselBox();
        $(".master-portfolio-grid").masterPortfolio();
        $(".master-wrap-box").masterWrap();
        $(".master-slide-text").masterSlideText();
        
        customTypography();
        customMaxWidth();
        $("body").addClass("loading")

        $(window).load(function() {
            Royal_Preloader.config({
                showPercentage: true,
                onComplete: function() {
                    // Init before recall element
                    //$(".master-animated-text .text-animate span").css("opacity", 0)
                    setTimeout(function() {
                        $("body").removeClass("loading").addClass("loaded")
                        //$(".master-accordion").masterAccordion();
                        $(".master-animate").masterAnimate();
                        $(".master-animated-text").masterAnimatedText();
                        //$(".master-spacer").masterSpacer();
                        //$(".master-carousel-box").masterCarouselBox();
                        $(".master-counter").masterCounter();
                        $(".master-parallax-background").masterParallaxBG();
                        $(".master-fancy-image").masterFancyImage();
                        $(".master-portfolio-grid").masterPortfolio();
                        $(".master-portfolio-slider").masterPortfolioSlider();
                        $(".master-progress").masterProgress();
                        //$(".master-wrap-box").masterWrap();

                        $(".master-image-hover").masterImageHover();
                        $(".master-image-effect").masterImageEffect();
                        $(".master-hero-bg-list").masterHeroBgList();

                        // Slick slider
                        $(".master-hero-nav").masterHeroNav();
                        $(".master-hero-carousel").masterHeroCarousel();
                        $(".master-hero-swiper").masterHeroSwiper();

                        // Master slider
                        $(".master-slider.slider1").masterSlider();
                    }, 700 )
                    
                }
            });
        });

        //$(window).ready(function() {
            //$("body").jpreloader();
            
        //})
    });

})(jQuery);

