<?php
Redux::setSection( $opt_name, array(
	'title' => esc_html__('General Options', 'constix'),
	'icon' => 'el-icon-wrench',
	'fields' => array(
		array(
			'id'           => 'page_layout',
			'type'         => 'button_set',
			'title'        => esc_html__('Page Layout', 'constix'),
			'subtitle'     => esc_html__('Select the page layout type', 'constix'),
			'options'      => array(
				'boxed'     => esc_html__('Boxed', 'constix'),
				'fullwidth' => esc_html__('Fullwidth', 'constix')
			),
			'default' => 'fullwidth'
		),
		array(
		  'id' => 'map_api_key',
		  'type' => 'text',
		  'title' => esc_html__('Google Map API key', 'constix'),
		  'default' => ''
		),
		// Contact Settings
		array(
			'id'     => 'contact',
			'type'   => 'info',
			'icon'   => true,
			'raw'    => '<h3 class="margin-bottom-0">' . esc_html__('Conact Information', 'constix') . '</h3>',
		),
		array(
		  'id'      => 'contact_email', 
		  'type'    => 'text',
		  'url'     => true,
		  'title'   => esc_html__('Email', 'constix'), 
		  'default' => ''
		), 
		array(
		  'id'      => 'contact_phone', 
		  'type'    => 'text',
		  'url'     => true,
		  'title'   => esc_html__('Phone', 'constix'), 
		  'default' => ''
		),
		array(
		  'id'      => 'contact_location_text', 
		  'type'    => 'text',
		  'url'     => true,
		  'title'   => esc_html__('Location Text', 'constix'), 
		  'default' => ''
		), 
		array(
		  'id'      => 'contact_location_link', 
		  'type'    => 'text',
		  'url'     => true,
		  'title'   => esc_html__('Location Link', 'constix'), 
		  'default' => ''
		), 
		// Logo Default Settings
		array(
			'id'     => 'logo_default',
			'type'   => 'info',
			'icon'   => true,
			'raw'    => '<h3 class="margin-bottom-0">' . esc_html__('Logo Default', 'constix') . '</h3>',
		),
		array(
		  'id'      => 'header_logo', 
		  'type'    => 'media',
		  'url'     => true,
		  'title'   => esc_html__('Logo in header default', 'constix'), 
		  'default' => ''
		), 
		// Breadcrumb Default Settings
		array(
			'id'     => 'breadcrumb_default',
			'type'   => 'info',
			'icon'   => true,
			'raw'    => '<h3 class="margin-bottom-0">' . esc_html__('Breadcrumb Settings Without Elementor', 'constix') . '</h3>',
		),
		array(
			'id'        => 'breadcrumb_title',
			'type'      => 'button_set',
			'title'     => esc_html__('Breadcrumb Title', 'constix'),
			'options'   => array(
				1 => esc_html__('Enable', 'constix'),
				0 => esc_html__('Disable', 'constix')
			),
			'default'   => 1
		),
		array(
			'id'        => 'breadcrumb_bg_color',
			'type'      => 'color',
			'title'     => esc_html__('Background Overlay Color', 'constix'),
			'default'   => ''
		),
		array(
			'id'        => 'breadcrumb_bg_opacity',
			'type'      => 'slider',
			'title'     => esc_html__('Breadcrumb Ovelay Color Opacity', 'constix'),
			'default'   => 50,
			'min'       => 0,
			'max'       => 100,
			'step'      => 2,
			'display_value' => 'text',
		),
		array(
			'id'        => 'breadcrumb_bg_image',
			'type'      => 'media',
			'url'       => true,
			'title'     => esc_html__('Breadcrumb Background Image', 'constix'),
			'default'   => '',
		),
		array(
			'id'        => 'breadcrumb_text_stype',
			'type'      => 'select',
			'title'     => esc_html__('Breadcrumb Text Stype', 'constix'),
			'options'   => 
			array(
				'text-light'     => esc_html__('Light', 'constix'),
				'text-dark'      => esc_html__('Dark', 'constix')
			),
			'default' => 'text-light'
		),
	)
));