<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;

use \FW_Ext_Backups_Demo;


if ( ! defined( 'ABSPATH' ) ) exit;

class Demo_Importer {

	public function __construct() {
		add_filter( 'plugin_action_links_rt-demo-importer/rt-demo-importer.php', array( $this, 'add_action_links' ) ); // Link from plugins page 
		add_filter( 'rt_demo_installer_warning', array( $this, 'data_loss_warning' ) );
		add_filter( 'fw:ext:backups-demo:demos', array( $this, 'demo_config' ) );
		add_action( 'fw:ext:backups:tasks:success:id:demo-content-install', array( $this, 'after_demo_install' ) );
	}

	public function add_action_links( $links ) {
		$mylinks = array(
			'<a href="' . esc_url( admin_url( 'tools.php?page=fw-backups-demo-content' ) ) . '">'.__( 'Install Demo Contents', 'finbuzz-core' ).'</a>',
		);
		return array_merge( $links, $mylinks );
	}

	public function data_loss_warning( $links ) {
		$html  = '<div style="margin-top:20px;color:#f00;font-size:20px;line-height:1.3;font-weight:600;margin-bottom:40px;border-color: #f00;border-style: dashed;border-width: 1px 0;padding:10px 0;">';
		$html .= __( 'Warning: All your old data will be lost if you install One Click demo data from here, so it is suitable only for a new website.', 'finbuzz-core');
		$html .= __( ' ( If one click demo import does not work please try manual demo import <a href="https://radiustheme.com/demo/wordpress/themes/finbuzz/docs/#section-4-2" target="__blank" style="text-decoration:none; color:#1b3452;">check documentation</a> )', 'finbuzz-core' );
		$html .= '</div>';
		return $html;
	}

	public function demo_config( $demos ) {
		$demos_array = array(
			'demo1' => array(
				'title' => __( 'Home 1', 'finbuzz-core' ),
				'screenshot' => plugins_url( 'screenshots/screenshot1.jpg', __FILE__ ),
				'preview_link' => 'https://radiustheme.com/demo/wordpress/themes/finbuzz/',
			),
			'demo2' => array(
				'title' => __( 'Home 2', 'finbuzz-core' ),
				'screenshot' => plugins_url( 'screenshots/screenshot2.jpg', __FILE__ ),
				'preview_link' => 'https://radiustheme.com/demo/wordpress/themes/finbuzz/home-2/',
			),
			'demo3' => array(
				'title' => __( 'Home 3', 'finbuzz-core' ),
				'screenshot' => plugins_url( 'screenshots/screenshot3.jpg', __FILE__ ),
				'preview_link' => 'https://radiustheme.com/demo/wordpress/themes/finbuzz/home-3/',
			),
			'demo4' => array(
				'title' => __( 'Home 4', 'finbuzz-core' ),
				'screenshot' => plugins_url( 'screenshots/screenshot4.jpg', __FILE__ ),
				'preview_link' => 'https://radiustheme.com/demo/wordpress/themes/finbuzz/home-4/',
			),
			'demo5' => array(
				'title' => __( 'Home 5', 'finbuzz-core' ),
				'screenshot' => plugins_url( 'screenshots/screenshot5.jpg', __FILE__ ),
				'preview_link' => 'https://radiustheme.com/demo/wordpress/themes/finbuzz/home-5/',
			),
			'demo6' => array(
				'title' => __( 'Home 6', 'finbuzz-core' ),
				'screenshot' => plugins_url( 'screenshots/screenshot6.jpg', __FILE__ ),
				'preview_link' => 'https://radiustheme.com/demo/wordpress/themes/finbuzz/home-6/',
			),
			'demo7' => array(
				'title' => __( 'Home 7', 'finbuzz-core' ),
				'screenshot' => plugins_url( 'screenshots/screenshot7.jpg', __FILE__ ),
				'preview_link' => 'https://radiustheme.com/demo/wordpress/themes/finbuzz/home-7/',
			),
			'demo8' => array(
				'title' => __( 'Home 8', 'finbuzz-core' ),
				'screenshot' => plugins_url( 'screenshots/screenshot8.jpg', __FILE__ ),
				'preview_link' => 'https://radiustheme.com/demo/wordpress/themes/finbuzz/home-8/',
			),
			'demo9' => array(
				'title' => __( 'Home 9', 'finbuzz-core' ),
				'screenshot' => plugins_url( 'screenshots/screenshot9.jpg', __FILE__ ),
				'preview_link' => 'https://radiustheme.com/demo/wordpress/themes/finbuzz/home-9/',
			),
			'demo10' => array(
				'title' => __( 'Home 10', 'finbuzz-core' ),
				'screenshot' => plugins_url( 'screenshots/screenshot10.jpg', __FILE__ ),
				'preview_link' => 'https://radiustheme.com/demo/wordpress/themes/finbuzz/home-10/',
			),
			'demo11' => array(
				'title' => __( 'Home 11', 'finbuzz-core' ),
				'screenshot' => plugins_url( 'screenshots/screenshot11.jpg', __FILE__ ),
				'preview_link' => 'https://radiustheme.com/demo/wordpress/themes/finbuzz/home-11/',
			),
			'demo12' => array(
				'title' => __( 'Home 12', 'finbuzz-core' ),
				'screenshot' => plugins_url( 'screenshots/screenshot12.jpg', __FILE__ ),
				'preview_link' => 'https://radiustheme.com/demo/wordpress/themes/finbuzz/home-12/',
			),
			'demo13' => array(
				'title' => __( 'Home 13', 'finbuzz-core' ),
				'screenshot' => plugins_url( 'screenshots/screenshot13.jpg', __FILE__ ),
				'preview_link' => 'https://radiustheme.com/demo/wordpress/themes/finbuzz/home-13/',
			),
			
		);

		$download_url = 'http://demo.radiustheme.com/wordpress/demo-content/finbuzz/';

		foreach ($demos_array as $id => $data) {
			$demo = new FW_Ext_Backups_Demo($id, 'piecemeal', array(
				'url' => $download_url,
				'file_id' => $id,
			));
			$demo->set_title($data['title']);
			$demo->set_screenshot($data['screenshot']);
			$demo->set_preview_link($data['preview_link']);

			$demos[ $demo->get_id() ] = $demo;

			unset($demo);
		}

		return $demos;
	}

	public function after_demo_install( $collection ){
		// Update front page id
		$demos = array(
			'demo1'  => 3591,
			'demo2'  => 3709,
			'demo3'  => 6868,
			'demo4'  => 6903,
			'demo5'  => 7113,
			'demo6'  => 7380,
			'demo7'  => 7436,
			'demo8'  => 7494,
			'demo9'  => 7817,
			'demo10' => 7838,
			'demo11' => 7902,
			'demo12' => 7949,
			'demo13' => 8096,
		);

		$data = $collection->to_array();

		foreach( $data['tasks'] as $task ) {
			if( $task['id'] == 'demo:demo-download' ){
				$demo_id = $task['args']['demo_id'];
				$page_id = $demos[$demo_id];
				update_option( 'page_on_front', $page_id );
				flush_rewrite_rules();
				break;
			}
		}

		
	}
}

new Demo_Importer;