<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;

use FinbuzzTheme;
use FinbuzzTheme_Helper;
use Elementor\Group_Control_Image_Size;
use Elementor\Utils;
extract($data);


//image
$getimg = Group_Control_Image_Size::get_attachment_image_html( $data, 'icon_image_size', 'rt_image' );
$signature_image = wp_get_attachment_image( $data['signature_image']['id'], 'full' );

?>
<div class="about-image-text style-2">
	<div class="row">
		<div class="col-lg-12">
			<div class="author-info">
				<div class="about-image">
					<?php echo wp_kses_post($getimg);?>				
				</div>
				<div class="about-content">
                    <div class="item-signature">
                    <?php if($signature_image){
                        echo wp_kses_post($signature_image);
                    } else { ?>
                        <img src="<?php echo FINBUZZ_ASSETS_URL . 'element/shape33.png'; ?>" width="121" height="59" alt="">
                    <?php } ?>
                    
                    </div>
					<?php if ( !empty( $data['title'] ) ) { ?>
					<h4 class="rtin-title"><?php echo wp_kses_post( $data['title'] );?></h4>
					<?php } ?>
					<?php if ( !empty( $data['sub_title'] ) ) { ?>
					<span class="sub-rtin-title"><?php echo wp_kses_post( $data['sub_title'] );?></span>
					<?php } ?>
				</div>
			</div>
		</div>
	</div>
</div>