<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */


namespace radiustheme\Finbuzz_Core;

extract($data);
?>

<div class="country-location">
    <div class="location-item">
        <div class="map-icon">
        <img src="<?php echo FINBUZZ_ASSETS_URL . 'img/figure10.png'; ?>" alt="figure" width="805" height="377">
        <?php if (!empty( $data['location_info']) ) { 
            ?>
            <ul>
                <?php foreach ( $data['location_info'] as $index => $location ) { ?>
                        <?php
                            extract($location);
                            $final_icon_class       = "fas fa-map-marker-alt";
                            $final_icon_image_url   = '';
                            if ( is_string( $location_icon['value'] ) && $dynamic_icon_class = $location_icon['value']  ) {
                            $final_icon_class     = $dynamic_icon_class;
                            }
                            if ( is_array( $location_icon['value'] ) ) {
                            $final_icon_image_url = $location_icon['value']['url'];
                            }
                        ?>
                <?php if ( $final_icon_image_url ): ?>
                        <li style="top:<?php  echo esc_attr( $location['icon_position_top']['size'] );?>%; left:<?php  echo esc_attr( $location['icon_position_left']['size'] ); ?>%"><img src="<?php echo esc_url( $final_icon_image_url ); ?>" alt="SVG Icon"></li>
                <?php else: ?>
                        <li style="top:<?php  echo esc_attr( $location['icon_position_top']['size'] );?>%; left:<?php  echo esc_attr( $location['icon_position_left']['size'] ); ?>%"><i class="<?php  echo esc_attr( $final_icon_class ); ?>"></i></li>
                <?php endif ?>
                <?php } ?>
            </ul>
        <?php } ?>
        </div>
    </div>
</div>
