<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;
use Elementor\Group_Control_Image_Size;
extract($data);
$btn = $attr = '';

$svg='<svg 
		xmlns="http://www.w3.org/2000/svg"
		xmlns:xlink="http://www.w3.org/1999/xlink"
		width="24px" height="24px" viewBox="0 0 24 24">
		<path fill-rule="evenodd" fill="#FA360A" d="M11.998 23.997c-6.617 0-11.999-5.383-11.999-11.999 0-6.616 5.382-11.999 11.999-11.999 6.616 0 11.999 5.383 11.999 11.999 0 6.616-5.383 11.999-11.999 11.999Zm0-21.816c-5.414 0-9.818 4.404-9.818 9.817 0 5.414 4.404 9.817 9.818 9.817 5.413 0 9.817-4.403 9.817-9.817 0-5.413-4.404-9.817-9.817-9.817Zm5.37 10.234a1.11 1.11 0 0 1-.237.355l-4.362 4.362c-.213.214-.492.32-.771.32a1.09 1.09 0 0 1-.772-1.862l2.502-2.501H7.634a1.092 1.092 0 0 1 0-2.182h6.094l-2.502-2.501a1.091 1.091 0 0 1 1.543-1.543l4.362 4.363a1.095 1.095 0 0 1 .237 1.189Z"/>
		</svg>';
if ( !empty( $data['buttonurl']['url'] ) ) {
	$attr  = 'href="' . $data['buttonurl']['url'] . '"';
	$attr .= !empty( $data['buttonurl']['is_external'] ) ? ' target="_blank"' : '';
	$attr .= !empty( $data['buttonurl']['nofollow'] ) ? ' rel="nofollow"' : '';
	
}

if ( !empty( $data['buttontext'] ) ) {
    $btn = '<a class="btn-style1" ' . $attr . '>' . $data['buttontext'] .$svg. '</a>';
}

?>
<div class="cta-default cta-<?php echo esc_attr( $data['style'] ); ?>">
	<ul class="element-list d-none d-xl-block">
		<li>
		  <img src="<?php echo FINBUZZ_ASSETS_URL . 'element/shape37.png'; ?>" width="161" height="255" alt="">
		</li>	
		<li>
			<img src="<?php echo FINBUZZ_ASSETS_URL . 'element/shape38.png'; ?>" width="161" height="201" alt="">
		</li>
		<li>
			<img src="<?php echo FINBUZZ_ASSETS_URL . 'element/shape39.png'; ?>" width="179" height="43" alt="">
		</li>
		<li>
			<img src="<?php echo FINBUZZ_ASSETS_URL . 'element/shape40.png'; ?>" width="253" height="60" alt="">
		</li>
	</ul>
	<div class="action-box">
		<div class="cta-content">
			<div class="title">
				<h2 class="rtin-title"><?php echo wp_kses_post( $data['title'] );?></h2>
			</div>
		</div>
		<div class="button-area">
			<?php if ( $btn ) { ?>
				<div class="rtin-button "><?php echo wp_kses_post( $btn );?></div>		
			<?php } ?>
		</div>	
	</div>
</div>