<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;

use FinbuzzTheme_Helper;
use Elementor\Utils;
use Elementor\Group_Control_Image_Size;
extract($data);

$attr = '';
if ( !empty( $data['url']['url'] ) ) {
	$attr  = 'href="' . $data['url']['url'] . '"';
	$attr .= !empty( $data['url']['is_external'] ) ? ' target="_blank"' : '';
	$attr .= !empty( $data['url']['nofollow'] ) ? ' rel="nofollow"' : '';
	
}
//image
if ( $attr ) {
  $getimg = '<a ' . $attr . '>' .Group_Control_Image_Size::get_attachment_image_html( $data, 'icon_image_size' , 'rt_image' ).'</a>';
}
else {
	$getimg = Group_Control_Image_Size::get_attachment_image_html( $data, 'icon_image_size', 'rt_image' );
}

$shape_image=Group_Control_Image_Size::get_attachment_image_html( $data, 'icon_image_size', 'image_shape_style10' );


?>

<div class="image-default image-<?php echo esc_attr( $data['style'] );?>">
	<div class="image-box">
		<?php echo wp_kses_post($getimg);?>
	</div>
    <ul class="shape-element d-none d-xl-block">
        <li><?php if($shape_image){ echo wp_kses_post($shape_image); } else{ ?>
            <img src="<?php echo FINBUZZ_ASSETS_URL . 'element/image10_figure.png'; ?>" width="577" width="520" alt="">
        <?php } ?></li>
        <li><img src="<?php echo FINBUZZ_ASSETS_URL . 'element/shape58.png'; ?>" width="594" width="511" alt=""></li>
    </ul>
    <ul class="shape-element-2 d-none d-xl-block">
        <li class="paralax1"><img src="<?php echo FINBUZZ_ASSETS_URL . 'element/shape59.png'; ?>" width="78" width="78" alt=""></li>
        <li class="paralax2"><img src="<?php echo FINBUZZ_ASSETS_URL . 'element/shape60.png'; ?>" width="78" width="78" alt=""></li>
        <li class="paralax3"><img src="<?php echo FINBUZZ_ASSETS_URL . 'element/shape61.png'; ?>" width="78" width="78" alt=""></li>
    </ul>   
</div>