<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;
use FinbuzzTheme_Helper;
use Elementor\Icons_Manager;
use Elementor\Utils;
use Elementor\Group_Control_Image_Size;
extract($data);

$attr = '';
if ( !empty( $data['url']['url'] ) ) {
	$attr  = 'href="' . $data['url']['url'] . '"';
	$attr .= !empty( $data['url']['is_external'] ) ? ' target="_blank"' : '';
	$attr .= !empty( $data['url']['nofollow'] ) ? ' rel="nofollow"' : '';
	
	
}

//title url

$title_attr = '';
if ( !empty( $data['title_url']['url'] ) ) {
	$title_attr  = 'href="' . $data['title_url']['url'] . '"';
	$title_attr .= !empty( $data['title_url']['is_external'] ) ? ' target="_blank"' : '';
	$title_attr .= !empty( $data['title_url']['nofollow'] ) ? ' rel="nofollow"' : '';
	$title = '<a ' . $title_attr . '>' . $data['title'] . '</a>';
	
}
else {
	$title = $data['title'];
}

// icon , image

$step_image = wp_get_attachment_image( $data['step_image']['id'], 'full' );
$arrow_image = wp_get_attachment_image( $data['arrow_image']['id'], 'full' );
$dots_image = wp_get_attachment_image( $data['dots_image']['id'], 'full' ); ?>

<div class="rt-process-box">

	<?php if ( !empty( $data['info_number'] ) ) { ?>
		<div class="background-content">
			<div class="text"><?php echo wp_kses_post( $info_number );?></div>
		</div>
	<?php } ?>

	<?php if ( !empty($data['icon']) ) { ?>
	<div class="dot-shape">
		<?php Icons_Manager::render_icon( $data['icon'], [ 'aria-hidden' => 'true' ] ); ?>
	</div>
	<?php } ?>

	<?php if ( !empty($step_image) ) { ?>		            
		<div class="item-img position-relative mb-4 text-center"><?php echo wp_kses_post($step_image);?></div>
	<?php } ?>
	<div class="content text-center">
		<?php if ( !empty( $data['title'] ) ) { ?>
			<h3 class="title"><?php echo wp_kses_post( $title );?></h3>
		<?php } ?>

		<?php  if ( !empty( $data['content'] ) ) { ?>
			<p><?php echo wp_kses_post( $data['content'] ); ?></p>
		<?php } ?>
	</div>

	<?php if ( !empty($arrow_image) ) { ?>
	<div class="rt-line-shape">
		<?php echo wp_kses_post($arrow_image);?>
	</div>
	<?php } ?>
</div>
