<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;

use FinbuzzTheme;
use FinbuzzTheme_Helper;
use \WP_Query;

$thum_size='full';
if ( get_query_var('paged') ) {
	$paged = get_query_var('paged');
}
else if ( get_query_var('page') ) {
	$paged = get_query_var('page');
}
else {
	$paged = 1;
}
$number_of_post = $data['itemnumber'];
$post_sorting = $data['orderby'];
$post_ordering = $data['post_ordering'];
$title_count = $data['title_count'];
$excerpt_count = $data['excerpt_count'];	
$cat_single_grid = $data['cat_single'];
$args = array(
	'post_type' => 'finbuzz_portfolio',
	'post_status' => 'publish',
	'orderby' => $post_sorting,
	'order' => $post_ordering,
    'posts_per_page' => $number_of_post,
    'paged'          => $paged,
	
	
);

if ( $cat_single_grid != 0 ) {
	$args['tax_query'] = array (
		array (
			'taxonomy' => 'finbuzz_portfolio_category',
			'field'    => 'ID',
			'terms'    => $cat_single_grid,
		)
	);
}

if($data['slider_autoplay']=='yes'){
	$data['slider_autoplay']=true;
}
else{
	$data['slider_autoplay']=false;
}

$swiper_data = array(
	'slidesPerView' 	=>2,
	'loop'				=>$data['slider_loop']=='yes' ? true:false,
	'spaceBetween'		=>$data['space']['size'],
	'slidesPerGroup'	=>$data['slider_per_group']['size'],
	'centeredSlides'	=>$data['centered_slide']=='yes' ? true:false ,
	'slideToClickedSlide' =>true,
	'autoplay'				=>array(
		'delay'  => $data['autoplayspeed']['size'],
	),
	'speed'      =>$data['speed']['size'],
	'breakpoints' =>array(
		'0'    =>array('slidesPerView' =>1),
		'576'    =>array('slidesPerView' =>$data['item_mobile']['size']),
		'768'    =>array('slidesPerView' =>$data['item_tablet']['size']),
		'992'    =>array('slidesPerView' =>$data['medium_item']['size']),
		'1200'    =>array('slidesPerView' =>$data['item']['size']),				
		'1600'    =>array('slidesPerView' =>$data['item']['size'])
	),
	'auto'   =>$data['slider_autoplay']
);
$swiper_data = json_encode( $swiper_data );

$query = new WP_Query( $args );
$temp = FinbuzzTheme_Helper::wp_set_temp_query( $query );

?>

<div class="portfolio-default portfolio-multi-layout-10 portfolio-<?php echo esc_attr( $data['layout'] );?>">
<div class="rt-related-slider" data-xld = '<?php echo esc_attr( $swiper_data )  ;?>'>
    <div class="swiper-wrapper " >	
            <?php 
                if ( $query->have_posts() ) {
                    while ( $query->have_posts() ) {
                    $query->the_post();	
                    $id 		= get_the_ID();
                    $excerpt = wp_trim_words( get_the_excerpt(), $excerpt_count, '' );
                    $portfolio_title = wp_trim_words( get_the_title(), $title_count, '' );
            ?>
            <div class="swiper-slide">
                <div class="rtin-item ">
                    <div class="rtin-figure">
                        <a href="<?php the_permalink(); ?>">
                            <?php
                                if ( has_post_thumbnail() ){
                                    the_post_thumbnail( $thum_size, ['class' => 'img-fluid mb-10 width-100'] );
                                } else {
                                    if ( !empty( FinbuzzTheme::$options['no_preview_image']['id'] ) ) {
                                        echo wp_get_attachment_image( FinbuzzTheme::$options['no_preview_image']['id'], 'full' );
                                    } else {
                                        echo '<img class="wp-post-image" src="' . FinbuzzTheme_Helper::get_img( 'noimage_370X328.jpg' ) . '" alt="'.get_the_title().'">';
                                    }
                                }
                            ?>
                        </a>
                    </div>
                    <div class="rtin-content">
                        <div class="title-area">
                            <?php if ( $data['cat_display'] == 'yes' ) { ?>
                                <div class="rtin-cat"><?php
                                    $i = 1;
                                    $term_lists = get_the_terms( get_the_ID(), 'finbuzz_portfolio_category' );
                                    if($term_lists){
                                    foreach ( $term_lists as $term_list ){ 
                                    $link = get_term_link( $term_list->term_id, 'finbuzz_portfolio_category' ); ?><?php if ( $i > 1 ){ echo esc_html( ', ' ); } ?><a href="<?php echo esc_url( $link ); ?>"><?php echo esc_html( $term_list->name ); ?>
                                    </a><?php $i++; } }?>
                                </div>
                            <?php } ?>
                            <h3>
                                <a href="<?php the_permalink(); ?>"><span><?php echo wp_kses($portfolio_title,'alltext_allow');?></span></a>
                            </h3>
                            <?php if ( $data['excerpt_display'] == 'yes' ) { ?>
                            <p><span><?php echo wp_kses( $excerpt , 'alltext_allow' ); ?></span></p>
                            <?php } ?>
                        </div>
				    </div>
                </div>
            </div>
            <?php  } ?>
        <?php } ?>
    </div>
    <?php  if($data['navigation']=='yes'){  ?>
        <div class="swiper-pagination"></div>
    <?php } ?>
</div>
	<?php FinbuzzTheme_Helper::wp_reset_temp_query( $temp ); ?>
</div>

 