<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;

use FinbuzzTheme;
use FinbuzzTheme_Helper;
use \WP_Query;

$finbuzz_has_entry_meta  = ( $data['post_grid_author'] || $data['post_grid_category'] == 'yes' || $data['post_grid_comment'] == 'yes' || $data['post_grid_view'] == 'yes' && function_exists( 'finbuzz_views' ) || $data['post_grid_read'] == 'yes' && function_exists( 'finbuzz_reading_time' ) ) ? true : false;

$thumb_size = 'finbuzz-size4';

$args = array(
	'posts_per_page' 	=> $data['itemlimit'],
	'cat'            	=> (int) $data['cat'],
	'order' 			=> $data['post_ordering'],
	'orderby' 			=> $data['post_orderby'],
);

$query = new WP_Query( $args );
$temp = FinbuzzTheme_Helper::wp_set_temp_query( $query );



$col_class = "col-xl-{$data['col_xl']} col-lg-{$data['col_lg']} col-md-{$data['col_md']} col-sm-{$data['col_sm']} col-{$data['col']}";

?>
<div class="post-default post-grid-style4 post-multi-grid">
	<div class="row auto-clear">
	<?php $i = 1;
	 $j = $data['delay']; $k = $data['duration'];
	 if ( $query->have_posts() ) :?>
		<?php while ( $query->have_posts() ) : $query->the_post();?>
			<?php
			$content = FinbuzzTheme_Helper::get_current_post_content();
			$content = wp_trim_words( get_the_excerpt(), $data['count'], '' );
			$content = "<p>$content</p>";
			$title = wp_trim_words( get_the_title(), $data['title_count'], '' );
			
			$finbuzz_comments_number = number_format_i18n( get_comments_number() );
			$finbuzz_comments_html = $finbuzz_comments_number == 1 ? esc_html__( 'Comment: ' , 'finbuzz-core' ) : esc_html__( 'Comments: ' , 'finbuzz-core' );
			$finbuzz_comments_html = $finbuzz_comments_html . '<span class="comment-number">'. $finbuzz_comments_number . '</span> ';
			
			$finbuzz_time_html = sprintf( '<span>%s</span> <span>%s</span>', get_the_time( 'd' ), get_the_time( 'M' ), get_the_time( 'Y' ) );

			if ( empty(has_post_thumbnail() ) ) {
				$img_class ='no_image';
			}else {
				$img_class ='show_image';
			}
			?>
			<div class="<?php  echo esc_attr( $col_class );?>">
				<div class="rtin-item-post rt-animate <?php echo esc_attr($img_class);?> <?php echo esc_attr( $data['animation'] );?> <?php echo esc_attr( $data['animation_effect'] );?>" data-wow-delay="<?php echo esc_attr( $j );?>s" data-wow-duration="<?php echo esc_attr( $k );?>s">
					<div class="rtin-img">
						<?php if ( has_post_thumbnail() ) { ?>
						<a href="<?php the_permalink(); ?>">
							<?php
								if ( has_post_thumbnail() ){
									the_post_thumbnail( $thumb_size );
								}
								else {
									if ( !empty( FinbuzzTheme::$options['no_preview_image']['id'] ) ) {
										echo wp_get_attachment_image( FinbuzzTheme::$options['no_preview_image']['id'], $thumb_size );
									}
									else {
										echo '<img class="wp-post-image" src="' . FinbuzzTheme_Helper::get_img( 'noimage_520X350.jpg' ) . '" alt="'.get_the_title().'">';
									}
								}
							?>
						</a>
						<?php } ?>
                        <?php if ( $data['post_grid_date'] == 'yes' ) { ?>
                            <div class="blog-date">	
                            <i class="far fa-calendar-check"></i><span><?php echo the_time('d'); ?></span><span class="month"><?php echo  the_time('M') ?></span>
                            </div>
                        <?php }  ?>
					</div>
					<div class="rtin-content">
						<?php if ( $finbuzz_has_entry_meta ) { ?>
						<ul class="post-grid-meta">
                            <?php  if ( $data['post_grid_author'] == 'yes' ) { ?>
							<li class="item-author"><i class="far fa-user"></i><?php esc_html_e( 'by ', 'finbuzz-core' );?><?php the_author_posts_link(); ?></li>
                            <?php } if ( $data['post_grid_category'] == 'yes' ) { ?>
							<li class="blog-cat"><i class="far fa-folder-open"></i><?php echo the_category( ', ' );?></li>
							<?php } if ( $data['post_grid_comment'] == 'yes' ) { ?>
							<li class="item-comment"><i class="far fa-comments"></i><a href="<?php echo get_comments_link( get_the_ID() ); ?>"><?php echo wp_kses_post( $finbuzz_comments_html );?></a></li>
							<?php } if ( $data['post_grid_view'] == 'yes' && function_exists( 'finbuzz_views' ) ) { ?>
							<li><i class="fas fa-signal"></i><span class="meta-views meta-item "><?php echo finbuzz_views(); ?></span></li>
							<?php } if ( $data['post_grid_read'] == 'yes' && function_exists( 'finbuzz_reading_time' ) ) { ?>
							<li class="meta-reading-time meta-item"><i class="far fa-clock"></i><?php echo finbuzz_reading_time(); ?></li>
							<?php } ?>
						</ul>
						<?php } ?>
						<h3 class="rtin-title"><a href="<?php the_permalink();?>"><?php echo esc_html( $title );?></a></h3>						
						<?php if ( $data['content_display'] == 'yes' ) { ?>
						<?php echo wp_kses_post( $content );?>
						<?php } ?>
                        
						<?php  if ( $data['read_display'] == 'yes' ) { ?>
                            <a class="blog-btn" href="<?php the_permalink();?>"><?php echo wp_kses_post( $data['buttontext'] );?><svg 
                                    xmlns="http://www.w3.org/2000/svg"
                                    xmlns:xlink="http://www.w3.org/1999/xlink"
                                    width="24px" height="24px" viewBox="0 0 24 24">
                                    <path fill-rule="evenodd"  fill="rgb(250, 54, 10)"
                                    d="M11.998,23.997 C5.381,23.997 -0.001,18.614 -0.001,11.998 C-0.001,5.382 5.381,-0.001 11.998,-0.001 C18.614,-0.001 23.997,5.382 23.997,11.998 C23.997,18.614 18.614,23.997 11.998,23.997 ZM11.998,2.181 C6.584,2.181 2.180,6.585 2.180,11.998 C2.180,17.412 6.584,21.815 11.998,21.815 C17.411,21.815 21.815,17.412 21.815,11.998 C21.815,6.585 17.411,2.181 11.998,2.181 ZM17.368,12.415 C17.312,12.548 17.232,12.669 17.131,12.770 L12.769,17.132 C12.556,17.346 12.277,17.452 11.998,17.452 C11.718,17.452 11.439,17.346 11.226,17.132 C10.800,16.706 10.800,16.016 11.226,15.590 L13.728,13.089 L7.634,13.089 C7.032,13.089 6.543,12.600 6.543,11.998 C6.543,11.396 7.032,10.907 7.634,10.907 L13.728,10.907 L11.226,8.406 C10.800,7.980 10.800,7.289 11.226,6.863 C11.652,6.437 12.343,6.437 12.769,6.863 L17.131,11.226 C17.232,11.327 17.312,11.447 17.368,11.581 C17.478,11.848 17.478,12.148 17.368,12.415 Z"/>
                                    </svg></a>
                            <?php } ?>
					</div>
				</div>
			</div>
		<?php $i++; $j = $j + 0.3; $k = $k + 0.2; endwhile;?>
	</div>
	<?php endif;?>
	<?php FinbuzzTheme_Helper::wp_reset_temp_query( $temp );?>
</div>