<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;

use FinbuzzTheme;
use FinbuzzTheme_Helper;
use \WP_Query;

$finbuzz_has_entry_meta  = ( $data['post_grid_author'] || $data['post_grid_date']=='yes' ||  $data['post_grid_category'] == 'yes' || $data['post_grid_comment'] == 'yes' || $data['post_grid_view'] == 'yes' && function_exists( 'finbuzz_views' ) || $data['post_grid_read'] == 'yes' && function_exists( 'finbuzz_reading_time' ) ) ? true : false;

$thumb_size = 'finbuzz-size9';

$args = array(
	'posts_per_page' 	=> $data['itemlimit'],
	'cat'            	=> (int) $data['cat'],
	'order' 			=> $data['post_ordering'],
	'orderby' 			=> $data['post_orderby'],
);

$query = new WP_Query( $args );
$temp = FinbuzzTheme_Helper::wp_set_temp_query( $query );



$col_class = "col-xl-{$data['col_xl']} col-lg-{$data['col_lg']} col-md-{$data['col_md']} col-sm-{$data['col_sm']} col-{$data['col']}";

?>
<div class="post-default post-grid-style7 post-grid-multilayout">
	<div class="row auto-clear">
	<?php $i = 1;
	 $j = $data['delay']; $k = $data['duration'];
	 if ( $query->have_posts() ) :?>
		<?php while ( $query->have_posts() ) : $query->the_post();?>
			<?php
			$content = FinbuzzTheme_Helper::get_current_post_content();
			$content = wp_trim_words( get_the_excerpt(), $data['count'], '' );
			$content = "<p>$content</p>";
			$title = wp_trim_words( get_the_title(), $data['title_count'], '' );
			
			$finbuzz_comments_number = number_format_i18n( get_comments_number() );
			$finbuzz_comments_html = $finbuzz_comments_number == 1 ? esc_html__( 'Comment' , 'finbuzz-core' ) : esc_html__( 'Comments' , 'finbuzz-core' );
			$finbuzz_comments_html =$finbuzz_comments_number. '<span class="comment-number">'. $finbuzz_comments_html . '</span> ';
			
			$finbuzz_time_html = sprintf( '<span>%s</span> <span>%s</span>', get_the_time( 'd' ), get_the_time( 'M' ), get_the_time( 'Y' ) );

			if ( empty(has_post_thumbnail() ) ) {
				$img_class ='no_image';
			}else {
				$img_class ='show_image';
			}
			?>
			<div class="<?php  echo esc_attr( $col_class );?>">
				<div class="post-grid-item <?php echo esc_attr($img_class);?> rt-animate <?php echo esc_attr( $data['animation'] );?> <?php echo esc_attr( $data['animation_effect'] );?>" data-wow-delay="<?php echo esc_attr( $j );?>s" data-wow-duration="<?php echo esc_attr( $k );?>s">
					<div class="post-img">
						<?php if ( has_post_thumbnail() ) { ?>
							<a href="<?php the_permalink(); ?>">
								<?php
									if ( has_post_thumbnail() ){
										the_post_thumbnail( $thumb_size );
									}
									else {
										if ( !empty( FinbuzzTheme::$options['no_preview_image']['id'] ) ) {
											echo wp_get_attachment_image( FinbuzzTheme::$options['no_preview_image']['id'], $thumb_size );
										}
										else {
											echo '<img class="wp-post-image" src="' . FinbuzzTheme_Helper::get_img( 'noimage_520X350.jpg' ) . '" alt="'.get_the_title().'">';
										}
									}
								?>
							</a>
						<?php } ?>
						<?php if ($data['post_grid_date'] == 'yes'  ) { ?>			
							<div class="blog-date">
                                <div>
                                <span class="day"><?php echo the_time('d'); ?></span>
								<span class="month"><?php echo the_time('M') ?></span>	
                                </div>
								
							</div>	
						<?php } ?>
					</div>
					<div class="entry-content">
						<?php if ( $finbuzz_has_entry_meta ) { ?>
						<ul class="post-grid-meta">
							<?php  if ( $data['post_grid_author'] == 'yes' ) { ?>
							  <li class="item-author">
                                <svg width="14" height="15" viewBox="0 0 14 15" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M9.59939 8.03199C10.2891 7.45382 10.7924 6.66097 11.0395 5.76376C11.2866 4.86654 11.2651 3.90957 10.978 3.02598C10.6909 2.14239 10.1525 1.37612 9.43764 0.833783C8.7228 0.291443 7.86709 0 6.98957 0C6.11204 0 5.25633 0.291443 4.54149 0.833783C3.82665 1.37612 3.28822 2.14239 3.00112 3.02598C2.71401 3.90957 2.69251 4.86654 2.9396 5.76376C3.18669 6.66097 3.69008 7.45382 4.37974 8.03199C3.19799 8.53648 2.16687 9.37323 1.39631 10.453C0.625746 11.5328 0.144627 12.8152 0.00424314 14.1635C-0.00591858 14.2619 0.00221475 14.3615 0.0281785 14.4566C0.0541423 14.5517 0.0974282 14.6404 0.155565 14.7176C0.272977 14.8737 0.443751 14.9736 0.630319 14.9955C0.816888 15.0173 1.00397 14.9593 1.1504 14.8342C1.29684 14.7091 1.39063 14.5272 1.41116 14.3284C1.56562 12.8631 2.22132 11.5098 3.25296 10.5271C4.2846 9.54445 5.61987 9.0012 7.00364 9.0012C8.38741 9.0012 9.72267 9.54445 10.7543 10.5271C11.786 11.5098 12.4416 12.8631 12.5961 14.3284C12.6152 14.5125 12.6977 14.6826 12.8276 14.8058C12.9575 14.929 13.1257 14.9966 13.2996 14.9955H13.377C13.5614 14.9729 13.7299 14.8735 13.8458 14.7191C13.9618 14.5646 14.0158 14.3676 13.996 14.171C13.8549 12.8189 13.3712 11.5332 12.5967 10.4517C11.8222 9.37029 10.7861 8.53381 9.59939 8.03199ZM6.98957 7.4998C6.43304 7.4998 5.88902 7.32395 5.42629 6.9945C4.96356 6.66504 4.6029 6.19678 4.38993 5.64892C4.17696 5.10105 4.12123 4.4982 4.22981 3.91659C4.33838 3.33499 4.60637 2.80074 4.99989 2.38143C5.39341 1.96211 5.89479 1.67656 6.44062 1.56087C6.98645 1.44518 7.55221 1.50455 8.06637 1.73149C8.58053 1.95842 9.01999 2.34271 9.32918 2.83578C9.63836 3.32884 9.80339 3.90852 9.80339 4.50153C9.80339 5.29672 9.50694 6.05934 8.97924 6.62162C8.45155 7.18391 7.73584 7.4998 6.98957 7.4998Z" fill="#FF2500"/>
                                </svg>
                                <?php esc_html_e( 'by ', 'finbuzz-core' );?><?php the_author_posts_link(); ?></li>
							<?php } ?>
                            <?php  if ( $data['post_grid_category'] == 'yes' ) { ?>
							    <li class="blog-cat"><i class="fas fa-tags"></i><?php echo the_category( ' ' );?></li>
						    <?php } ?>
							<?php  if ( $data['post_grid_comment'] == 'yes' ) { ?>
								<li class="item-comment"><i class="far fa-comment"></i><a href="<?php echo get_comments_link( get_the_ID() ); ?>"><?php echo wp_kses_post( $finbuzz_comments_html );?></a></li>
							<?php } if ( $data['post_grid_view'] == 'yes' && function_exists( 'finbuzz_views' ) ) { ?>
								<li><i class="fas fa-signal"></i><span class="meta-views meta-item "><?php echo finbuzz_views(); ?></span></li>
							<?php } if ( $data['post_grid_read'] == 'yes' && function_exists( 'finbuzz_reading_time' ) ) { ?>
								<li class="meta-reading-time meta-item"><i class="far fa-clock"></i><?php echo finbuzz_reading_time(); ?></li>
							<?php } ?>
						</ul>
						<?php } ?>
						<h3 class="entry-title"><a href="<?php the_permalink();?>"><?php echo esc_html( $title );?></a></h3>
						<?php if ( $data['content_display'] == 'yes' ) { ?>
							<?php echo wp_kses_post( $content );?>
						<?php } ?>
						<?php  if ( $data['read_display'] == 'yes' ) { ?>
							<a class="btn-style1" target="_blank" href="<?php the_permalink();?>"><?php echo wp_kses_post( $data['buttontext'] );?><svg xmlns="http://www.w3.org/2000/svg" width="24px" height="24px" viewBox="0 0 24 24">
								<path fill="#FA360A" d="M11.998 23.997c-6.617 0-11.999-5.383-11.999-11.999 0-6.616 5.382-11.999 11.999-11.999 6.616 0 11.999 5.383 11.999 11.999 0 6.616-5.383 11.999-11.999 11.999Zm0-21.816c-5.414 0-9.818 4.404-9.818 9.817 0 5.414 4.404 9.817 9.818 9.817 5.413 0 9.817-4.403 9.817-9.817 0-5.413-4.404-9.817-9.817-9.817Zm5.37 10.234a1.11 1.11 0 0 1-.237.355l-4.362 4.362c-.213.214-.492.32-.771.32a1.09 1.09 0 0 1-.772-1.862l2.502-2.501H7.634a1.092 1.092 0 0 1 0-2.182h6.094l-2.502-2.501a1.091 1.091 0 0 1 1.543-1.543l4.362 4.363a1.095 1.095 0 0 1 .237 1.189Z"></path>
								</svg>									
							</a>
						<?php  } ?>
					</div>
					
				</div>
			</div>
		<?php $i++; $j = $j + 0.2;  endwhile;?>
	</div>
	<?php endif;?>
	<?php FinbuzzTheme_Helper::wp_reset_temp_query( $temp );?>
</div>