<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;

use FinbuzzTheme;
use FinbuzzTheme_Helper;
use \WP_Query;

$finbuzz_has_entry_meta  = ( $data['post_grid_author'] || $data['post_grid_date']=='yes' ||  $data['post_grid_category'] == 'yes' || $data['post_grid_comment'] == 'yes' || $data['post_grid_view'] == 'yes' && function_exists( 'finbuzz_views' ) || $data['post_grid_read'] == 'yes' && function_exists( 'finbuzz_reading_time' ) ) ? true : false;

$thumb_size = 'w-100 border-radius-md';

$args = array(
	'posts_per_page' 	=> $data['itemlimit'],
	'cat'            	=> (int) $data['cat'],
	'order' 			=> $data['post_ordering'],
	'orderby' 			=> $data['post_orderby'],
);

$query = new WP_Query( $args );
$temp = FinbuzzTheme_Helper::wp_set_temp_query( $query );



$col_class = "col-xl-{$data['col_xl']} col-lg-{$data['col_lg']} col-md-{$data['col_md']} col-sm-{$data['col_sm']} col-{$data['col']}";

?>
<div class="rt-fin-blog-wrap style-2">
	<div class="row auto-clear">
	<?php $i = 1;
	 $j = $data['delay']; $k = $data['duration'];
	 if ( $query->have_posts() ) :?>
		<?php while ( $query->have_posts() ) : $query->the_post();?>
			<?php
			$content = FinbuzzTheme_Helper::get_current_post_content();
			$content = wp_trim_words( get_the_excerpt(), $data['count'], '' );
			$content = "<p>$content</p>";
			$title = wp_trim_words( get_the_title(), $data['title_count'], '' );
			
			$finbuzz_comments_number = number_format_i18n( get_comments_number() );
			$finbuzz_comments_html = $finbuzz_comments_number == 1 ? esc_html__( 'Comment' , 'finbuzz-core' ) : esc_html__( 'Comments' , 'finbuzz-core' );
			$finbuzz_comments_html =$finbuzz_comments_number. '<span class="comment-number">'. $finbuzz_comments_html . '</span> ';
			
			$finbuzz_time_html = sprintf( '<span>%s</span> <span>%s</span>', get_the_time( 'd' ), get_the_time( 'M' ), get_the_time( 'Y' ) );

			if ( empty(has_post_thumbnail() ) ) {
				$img_class ='no_image';
			}else {
				$img_class ='show_image';
			}
			?>

			<div class="<?php  echo esc_attr( $col_class );?>">
				<div class="rt-fin-blog-box">
					<div class="blog-img position-relative">
						<?php if ( has_post_thumbnail() ) { ?>
						<a href="<?php the_permalink(); ?>" class="w-100 border-radius-md">
							<?php
								if ( has_post_thumbnail() ){
									the_post_thumbnail( $thumb_size );
								}
								else {
									if ( !empty( FinbuzzTheme::$options['no_preview_image']['id'] ) ) {
										echo wp_get_attachment_image( FinbuzzTheme::$options['no_preview_image']['id'], $thumb_size );
									}
									else {
										echo '<img class="wp-post-image" src="' . FinbuzzTheme_Helper::get_img( 'noimage_520X350.jpg' ) . '" alt="'.get_the_title().' /">';
									}
								}
							?>
						</a>
						<?php } ?>
						<?php if ($data['post_grid_date'] == 'yes'  ) { ?>
						<div class="tag">
							<span class="date"><?php echo the_time('d'); ?></span>
							<span class="month"><?php echo the_time('F'); ?></span>
						</div>
						<?php } ?>
					</div>
					<div class="content-box">
						<div class="entry-meta-wrap mb-2">
							<ul class="entry-meta d-flex">
								<?php if ( $data['post_grid_category'] == 'yes' ) { ?>
								<li>
									<svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
										<path d="M2.33333 3.66683C2.06812 3.66683 1.81376 3.56147 1.62623 3.37394C1.43869 3.1864 1.33333 2.93205 1.33333 2.66683C1.33333 2.40161 1.43869 2.14726 1.62623 1.95972C1.81376 1.77219 2.06812 1.66683 2.33333 1.66683C2.59855 1.66683 2.8529 1.77219 3.04044 1.95972C3.22798 2.14726 3.33333 2.40161 3.33333 2.66683C3.33333 2.93205 3.22798 3.1864 3.04044 3.37394C2.8529 3.56147 2.59855 3.66683 2.33333 3.66683ZM12.94 6.72016L6.94 0.720163C6.7 0.480163 6.36667 0.333496 6 0.333496H1.33333C0.593333 0.333496 0 0.926829 0 1.66683V6.3335C0 6.70016 0.146667 7.0335 0.393333 7.2735L6.38667 13.2735C6.63333 13.5135 6.96667 13.6668 7.33333 13.6668C7.7 13.6668 8.03333 13.5135 8.27333 13.2735L12.94 8.60683C13.1867 8.36683 13.3333 8.0335 13.3333 7.66683C13.3333 7.2935 13.18 6.96016 12.94 6.72016Z" fill="#FA360A"/>
									</svg>
									<?php echo the_category( ', ' );?>
								</li>
								<?php } ?>
								<li>
									<svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
										<path d="M11 6C11 6.79565 10.6839 7.55871 10.1213 8.12132C9.55871 8.68393 8.79565 9 8 9C7.20435 9 6.44129 8.68393 5.87868 8.12132C5.31607 7.55871 5 6.79565 5 6C5 5.20435 5.31607 4.44129 5.87868 3.87868C6.44129 3.31607 7.20435 3 8 3C8.79565 3 9.55871 3.31607 10.1213 3.87868C10.6839 4.44129 11 5.20435 11 6Z" fill="currentColor"/>
										<path fill-rule="evenodd" clip-rule="evenodd" d="M0 8C0 5.87827 0.842855 3.84344 2.34315 2.34315C3.84344 0.842855 5.87827 0 8 0C10.1217 0 12.1566 0.842855 13.6569 2.34315C15.1571 3.84344 16 5.87827 16 8C16 10.1217 15.1571 12.1566 13.6569 13.6569C12.1566 15.1571 10.1217 16 8 16C5.87827 16 3.84344 15.1571 2.34315 13.6569C0.842855 12.1566 0 10.1217 0 8ZM8 1C6.68178 1.00007 5.39037 1.37236 4.2744 2.07403C3.15844 2.77569 2.26328 3.77821 1.69196 4.96619C1.12065 6.15418 0.896386 7.47934 1.045 8.78916C1.19361 10.099 1.70905 11.3402 2.532 12.37C3.242 11.226 4.805 10 8 10C11.195 10 12.757 11.225 13.468 12.37C14.2909 11.3402 14.8064 10.099 14.955 8.78916C15.1036 7.47934 14.8794 6.15418 14.308 4.96619C13.7367 3.77821 12.8416 2.77569 11.7256 2.07403C10.6096 1.37236 9.31822 1.00007 8 1Z" fill="currentColor"/>
									</svg>
									<span class="author-bay"><?php esc_html_e( 'By ', 'finbuzz-core' );?></span><?php the_author_posts_link(); ?>
								</li>
							</ul>
						</div>
						<h3 class="rt-title">
							<a href="<?php the_permalink(); ?>"><?php echo esc_html( $title );?></a>
						</h3>
						<?php if ( $data['content_display'] == 'yes' ) { ?>
							<?php echo wp_kses_post( $content );?>
						<?php } ?>

						<?php  if ( $data['read_display'] == 'yes' ) { ?>	
						<div class="fin-button">
							<a href="<?php the_permalink();?>" class="fin-btn"><?php echo wp_kses_post( $data['buttontext'] );?>
								<svg xmlns="http://www.w3.org/2000/svg" width="24px" height="24px" viewBox="0 0 24 24">
									<path fill="currentColor" d="M11.998 23.997c-6.617 0-11.999-5.383-11.999-11.999 0-6.616 5.382-11.999 11.999-11.999 6.616 0 11.999 5.383 11.999 11.999 0 6.616-5.383 11.999-11.999 11.999Zm0-21.816c-5.414 0-9.818 4.404-9.818 9.817 0 5.414 4.404 9.817 9.818 9.817 5.413 0 9.817-4.403 9.817-9.817 0-5.413-4.404-9.817-9.817-9.817Zm5.37 10.234a1.11 1.11 0 0 1-.237.355l-4.362 4.362c-.213.214-.492.32-.771.32a1.09 1.09 0 0 1-.772-1.862l2.502-2.501H7.634a1.092 1.092 0 0 1 0-2.182h6.094l-2.502-2.501a1.091 1.091 0 0 1 1.543-1.543l4.362 4.363a1.095 1.095 0 0 1 .237 1.189Z"></path>
								</svg>
							</a>
						</div>
						<?php  } ?>

					</div>
				</div>
			</div>			

		<?php $i++; $j = $j + 0.2;  endwhile;?>
	</div>
	<?php endif;?>
	<?php FinbuzzTheme_Helper::wp_reset_temp_query( $temp );?>
</div>