<?php
/**
 * 
 * 
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;
use Elementor\Utils;
use Elementor\Group_Control_Background;
use Elementor\Icons_Manager;
extract( $data );

?>

<div class="pricing-table-wrap rt-fin-pricing-wrap-2 pricing-wrapper position-relative">
    <div class="price-switch-box price-switch-box--active price-switch-box--style-1">
        <span class="pack-name"><?php echo esc_html($data['monthly_label'] ); ?></span>
            <div class="pricing-switch-container">
                <div class="pricing-switch"></div>
                <div class="pricing-switch pricing-switch-active"></div>
                <div class="switch-button"></div>
            </div>
        <span class="pack-name"><?php echo esc_html($data['yearly_label'] ); ?></span>
    </div>
    <div class="row justify-content-center">
        <?php if(!empty($data['prices_infos'])){ 
            foreach($data['prices_infos'] as $index=>$price_info){
        ?>
        <div class="col-xl-4 col-lg-6 col-md-6">
            <div class="fin-price-box">
                
                <?php if(!empty($price_info['most_popular'])){?>
                    <div class="badge"><?php echo wp_kses_post($price_info['most_popular']); ?></div>
                <?php } ?>

                <?php if ( 'yes' === $data['right_icon'] ) { ?>
                <div class="shape wow fadeInRight" data-wow-delay="200ms" data-wow-duration="800ms">
                    <svg width="49" height="75" viewBox="0 0 49 75" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <g opacity="0.3">
                        <path opacity="0.5" d="M3.43262 74.979L3.43262 51.6416L19.2197 63.3103L3.43262 74.979Z" fill="currentColor"/>
                        <path opacity="0.44" d="M48.734 72.9199L48.734 0.162112L26.2055 16.9783L-1.59244e-06 36.5928L48.734 72.9199Z" fill="currentColor"/>
                        </g>
                    </svg>
                </div>
                <?php } ?>

                <?php if ( !empty($price_info['top_icon']) ) { ?>
                    <div class="price-shape text-center mb-4">
                        <?php Icons_Manager::render_icon( $price_info['top_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                    </div>
                <?php } ?>

                <?php if(!empty($price_info['title'])){?>
                    <div class="label text-center"><?php echo wp_kses_post($price_info['title']); ?></div>
                <?php } ?>
                
                <?php if(!empty($price_info['content'])){?>
                    <p class="text-center">
                    <?php echo wp_kses_post($price_info['content']); ?>
                    </p>
                <?php } ?>


                <div class="price-box text-center mb-3">
                    <div class="pricing__price-heading">
                        <div class="price-box price-box-show">
                            <span class="pricing__price"><?php echo wp_kses_post($price_info['monthly_price']); ?></span><span class="pack-duration">/ <?php echo esc_html('Month', 'finbuzz'); ?></span>
                        </div>
                        <div class="price-box price-box-hide">
                            <span class="pricing__price"><?php echo wp_kses_post($price_info['yearly_price']); ?></span><span class="pack-duration">/ <?php echo esc_html('Year', 'finbuzz'); ?></span>
                        </div>
                    </div>
                </div>
                <div class="text"><?php echo wp_kses_post($price_info['plan_highlights']); ?></div>
                <?php if($price_info['list_item']){ ?>
                    <div class="list-pricing">
                        <?php echo wp_kses_post($price_info['list_item']); ?>
                    </div>
                <?php } ?>

                <?php if(!empty($price_info['btn_text'])){?>
                <div class="pricing-button">
                    <a href="<?php if($price_info['btn_link']['url']){ echo $price_info['btn_link']['url']; } ?>" class="pricing-btn"><?php echo wp_kses_post($price_info['btn_text']); ?></a>
                </div>
                <?php } ?>
            </div>
        </div>
        <?php } } ?> 
    </div>
</div>







