<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;
use Elementor\Group_Control_Image_Size;
extract($data);

$attr = '';
if ( !empty( $data['title_url']['url'] ) ) {
	$attr  = 'href="' . $data['title_url']['url'] . '"';
	$attr .= !empty( $data['title_url']['is_external'] ) ? ' target="_blank"' : '';
	$attr .= !empty( $data['title_url']['nofollow'] ) ? ' rel="nofollow"' : '';
	$title = '<a ' . $attr . '>' . $data['title'] . '</a>';	
}
else {
	$title = $data['title'];
}
// icon , image
if ( $attr ) {
	$getimg = '<a ' . $attr . '>' .Group_Control_Image_Size::get_attachment_image_html( $data, 'icon_image_size' , 'style2_icon_image').'</a>';
}
else {
	  $getimg = Group_Control_Image_Size::get_attachment_image_html( $data, 'icon_image_size', 'style2_icon_image' );
}

$final_icon_class       = " fas fa-thumbs-up";
$final_icon_image_url   = '';
if ( is_string( $style2_icon_class['value'] ) && $dynamic_icon_class =  $style2_icon_class['value']  ) {
  $final_icon_class     = $dynamic_icon_class;
}
if ( is_array( $style2_icon_class['value'] ) ) {
	$final_icon_image_url = $style2_icon_class['value']['url'];
}
$i = $data['delay']; $j = $data['duration'];
?>

<div class="rtin-progress-bar progress-bar-<?php echo esc_attr( $data['style'] ); ?> rt-animate <?php echo esc_attr( $data['animation'] );?> <?php echo esc_attr( $data['animation_effect'] );?>">
	<div class="rtin-item motion-effects1">
		<div class="progress-bar-wrap">
			<?php if($data['progress_icon_display']=='yes'){ ?>
				<div class="progress-bar-icon">
					<?php if ( !empty( $data['icontype']== 'image' ) ) { ?>		            
						<span class="rtin-img"><?php echo wp_kses_post($getimg);?></span>  
					<?php }else{?> 	
					<?php if ( $final_icon_image_url ): ?>
						<span class="rtin-icon"><img src="<?php echo esc_url( $final_icon_image_url ); ?>" alt="SVG Icon"></span>
					<?php else: ?>
						<span class="rtin-icon"><i class="<?php  echo esc_attr( $final_icon_class ); ?>"></i></span>
					<?php endif ?>
					<?php }  ?>
				</div>
			<?php } ?>
			<div class="progress-bar-content">
				<div class="rtin-title"><h3><?php  echo wp_kses_post( $title );?></h3></div>
				<?php if(!empty($data['progress2_bars'])){ 
					 $count=count($data['progress2_bars']);
					$i=1;
					$mb=""; 
					foreach($data['progress2_bars'] as $index=>$progress2){
						 if($i==$count){
							$mb="mb-0";
						}
					?>
					<div class="progress <?php echo esc_attr($mb); ?>" style="height:<?php echo esc_html( $progress2['progress2_number_height'] );?>px">
						<div class="progress-bar wow fadeInLeft rt-animate" data-progress="<?php echo esc_attr($progress2['progress2_number']['size'] );?>%" style="width: <?php echo esc_attr( $progress2['progress2_number']['size'] );?>%;"></div>
					</div>
				<?php $i++; } 
					}	
				?>
			</div>
			
		</div>
	</div>
</div>