<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;

extract($data);


$final_icon_class       = " fas fa-thumbs-up";
$final_icon_image_url   = '';
if ( is_string( $icon_class['value'] ) && $dynamic_icon_class =  $icon_class['value']  ) {
  $final_icon_class     = $dynamic_icon_class;
}
if ( is_array( $icon_class['value'] ) ) {
	$final_icon_image_url = $icon_class['value']['url'];
}

$circle_number=$data['number']['size'] ? $data['number']['size']:'80';
$circle_size=$data['circle_size']['size'] ? $data['circle_size']['size']:'160';
$circle_border_size=$data['circle_border']['size'] ? $data['circle_border']['size']:'8';
$circle_options=array(
	'circle_size' 			=> $circle_size,
	'circle_border_size' 	=> $circle_border_size,
	'animation_speed'  		=>$data['speed']['size'],
	'bg_color'  			=>$data['bgcolor_color'],
	'fg_color'  			=>$data['fgcolor_color']
);
$right_shape_class= $data['shape_display'] ? 'has-shape':'no-shape';

?>
<div class="progress-circle counter-appear progress-circle-2">
	<div class="counter-block style-2 <?php echo esc_attr($right_shape_class); ?>">
		<div class="chart-bar style-2" data-percent="<?php echo esc_attr( $circle_number ); ?>" data-circle-options="<?php echo esc_attr(json_encode($circle_options) ); ?>">
		    <span class="rtin-icon">
				<?php if($final_icon_class){ ?>
					<i class="<?php  echo esc_attr( $final_icon_class ); ?>"></i>
				<?php } else{ ?>
					<img src="<?php echo esc_url( $final_icon_image_url ); ?>" alt="SVG Icon"></span>
				<?php } ?>	
			</span>
			
		</div>
		<div class="counter-wrap">
			<div class="count-number">
				<span class="counterUp" data-duration="<?php echo esc_attr( $data['duration']['size']); ?>" data-counter="<?php echo esc_attr( $circle_number ); ?>"><?php echo esc_html( $circle_number ); ?></span>%
			</div>
			<?php if($data['title']): ?>
			<div class="title"><?php echo wp_kses_post( $data['title'] ); ?></div>
			<?php endif; ?>
		</div>
	</div>
</div>