<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;

use FinbuzzTheme;
use FinbuzzTheme_Helper;
use \WP_Query;

$thumb_size = 'finbuzz-size2';
if ( get_query_var('paged') ) {
	$paged = get_query_var('paged');
}
else if ( get_query_var('page') ) {
	$paged = get_query_var('page');
}
else {
	$paged = 1;
}


$number_of_post = $data['itemnumber'];
$post_sorting = $data['orderby'];
$post_ordering = $data['post_ordering'];
$title_count = $data['title_count'];
$excerpt_count = $data['excerpt_count'];	
$cat_single_grid = $data['cat_single'];
$args = array(
	'post_type' 		=> 'finbuzz_service',
	'post_status' 		=> 'publish',
	'orderby' 			=> $post_sorting,
	'order' 			=> $post_ordering,
	'posts_per_page' 	=> $number_of_post,
	'paged'          	=> $paged,
);

if ( $cat_single_grid != 0 ) {
	$args['tax_query'] = array (
		array (
			'taxonomy' => 'finbuzz_service_category',
			'field'    => 'ID',
			'terms'    => $cat_single_grid,
		)
	);
}
$svg='<svg 
		xmlns="http://www.w3.org/2000/svg"
		xmlns:xlink="http://www.w3.org/1999/xlink"
		width="24px" height="24px" viewBox="0 0 24 24">
		<path fill-rule="evenodd" fill="#FA360A" d="M11.998 23.997c-6.617 0-11.999-5.383-11.999-11.999 0-6.616 5.382-11.999 11.999-11.999 6.616 0 11.999 5.383 11.999 11.999 0 6.616-5.383 11.999-11.999 11.999Zm0-21.816c-5.414 0-9.818 4.404-9.818 9.817 0 5.414 4.404 9.817 9.818 9.817 5.413 0 9.817-4.403 9.817-9.817 0-5.413-4.404-9.817-9.817-9.817Zm5.37 10.234a1.11 1.11 0 0 1-.237.355l-4.362 4.362c-.213.214-.492.32-.771.32a1.09 1.09 0 0 1-.772-1.862l2.502-2.501H7.634a1.092 1.092 0 0 1 0-2.182h6.094l-2.502-2.501a1.091 1.091 0 0 1 1.543-1.543l4.362 4.363a1.095 1.095 0 0 1 .237 1.189Z"/>
		</svg>';
$query = new WP_Query( $args );
$temp = FinbuzzTheme_Helper::wp_set_temp_query( $query );

$gap_class = '';
if ( $data['column_no_gutters'] == 'hide' ) {
   $gap_class = 'no-gutters';
}
$col_class = "col-xl-{$data['col_xl']} col-lg-{$data['col_lg']} col-md-{$data['col_md']} col-sm-{$data['col_sm']} col-{$data['col']}";

?>
<div class="service-default service-<?php echo esc_attr( $data['layout'] );?> service-grid-<?php echo esc_attr( $data['layout'] );?>">
	<div class="row <?php echo esc_attr( $gap_class ); ?>">	
		<?php
			if ( $query->have_posts() ) {
			while ( $query->have_posts() ) {
			$query->the_post();			
			$id								= $query->ID;
			$excerpt 						= wp_trim_words( get_the_excerpt(), $excerpt_count, '' );
			$service_title 					= wp_trim_words( get_the_title(), $title_count, '' );
			$finbuzz_service_icon   		= get_post_meta( get_the_ID(), 'finbuzz_service_icon', true );
			$finbuzz_insurance_img   		= get_post_meta( get_the_ID(), 'finbuzz_service_img', true );
		?>
		<div class="<?php echo esc_attr( $col_class ) ?>">
			<div class="rt-fin-service-box-2">
				<h3 class="title text-center"><?php echo esc_html( $service_title  );?></h3>
				<div class="image-box position-relative">
					<div class="item-img overflow-hidden position-relative">
						<a href="<?php the_permalink();?>">
						<?php
							if ( has_post_thumbnail() ){
								the_post_thumbnail();
							}
							else {
									echo '<img class="wp-post-image" src="' . FinbuzzTheme_Helper::get_img( 'noimage_570X447.jpg' ) . '" alt="'.get_the_title().'">';
								}
							?>
						</a>
					</div>

					<?php if($data['icon_display']){ ?>
						<?php if ( (!empty($finbuzz_service_icon )  || !empty($finbuzz_insurance_img) ) ) { ?>
							<div class="icon overflow-hidden">	
								<?php if (  $finbuzz_insurance_img) : ?>
								<?php echo wp_get_attachment_image($finbuzz_insurance_img);?>
								<?php else: ?>
									<i class="<?php echo wp_kses_post( $finbuzz_service_icon );?>"></i>
								<?php endif; ?>
							</div>
						<?php } ?>
					<?php } ?>

				</div>
				<div class="item-content text-center mt-5">
				<?php if($data['excerpt_display']){ ?>
					<p> 
						<?php echo wp_kses( $excerpt , 'alltext_allow' ); ?>
					</p>
					<?php } ?>
					<div class="fin-button">
						<a href="<?php the_permalink();?>" class="fin-btn"><?php echo esc_attr($data['btn_text']); ?>
							<svg xmlns="http://www.w3.org/2000/svg" width="24px" height="24px" viewBox="0 0 24 24">
								<path fill="currentColor" d="M11.998 23.997c-6.617 0-11.999-5.383-11.999-11.999 0-6.616 5.382-11.999 11.999-11.999 6.616 0 11.999 5.383 11.999 11.999 0 6.616-5.383 11.999-11.999 11.999Zm0-21.816c-5.414 0-9.818 4.404-9.818 9.817 0 5.414 4.404 9.817 9.818 9.817 5.413 0 9.817-4.403 9.817-9.817 0-5.413-4.404-9.817-9.817-9.817Zm5.37 10.234a1.11 1.11 0 0 1-.237.355l-4.362 4.362c-.213.214-.492.32-.771.32a1.09 1.09 0 0 1-.772-1.862l2.502-2.501H7.634a1.092 1.092 0 0 1 0-2.182h6.094l-2.502-2.501a1.091 1.091 0 0 1 1.543-1.543l4.362 4.363a1.095 1.095 0 0 1 .237 1.189Z"></path>
							</svg>
						</a>
					</div>
				</div>
			</div>
		</div>
		<?php  } ?>
	<?php } ?>
	</div>
</div>