<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;

use FinbuzzTheme;
use FinbuzzTheme_Helper;
use \WP_Query;

if ( get_query_var('paged') ) {
	$paged = get_query_var('paged');
}
else if ( get_query_var('page') ) {
	$paged = get_query_var('page');
}
else {
	$paged = 1;
}
$svg='<svg 
xmlns="http://www.w3.org/2000/svg"
xmlns:xlink="http://www.w3.org/1999/xlink"
width="24px" height="24px">
<path fill-rule="evenodd"  fill="rgb(250, 54, 10)"
d="M11.998,23.997 C5.381,23.997 -0.001,18.614 -0.001,11.998 C-0.001,5.382 5.381,-0.001 11.998,-0.001 C18.614,-0.001 23.997,5.382 23.997,11.998 C23.997,18.614 18.614,23.997 11.998,23.997 ZM11.998,2.181 C6.584,2.181 2.180,6.585 2.180,11.998 C2.180,17.412 6.584,21.815 11.998,21.815 C17.411,21.815 21.815,17.412 21.815,11.998 C21.815,6.585 17.411,2.181 11.998,2.181 ZM17.368,12.415 C17.312,12.548 17.232,12.669 17.131,12.770 L12.769,17.132 C12.556,17.346 12.277,17.452 11.998,17.452 C11.718,17.452 11.439,17.346 11.226,17.132 C10.800,16.706 10.800,16.016 11.226,15.590 L13.728,13.089 L7.634,13.089 C7.032,13.089 6.543,12.600 6.543,11.998 C6.543,11.396 7.032,10.907 7.634,10.907 L13.728,10.907 L11.226,8.406 C10.800,7.980 10.800,7.289 11.226,6.863 C11.652,6.437 12.343,6.437 12.769,6.863 L17.131,11.226 C17.232,11.327 17.312,11.447 17.368,11.581 C17.478,11.848 17.478,12.148 17.368,12.415 Z"/>
</svg>';
$number_of_post = $data['itemnumber'];
$post_sorting = $data['orderby'];
$post_ordering = $data['post_ordering'];
$title_count = $data['title_count'];
$excerpt_count = $data['excerpt_count'];		
$cat_single_grid = $data['cat_single'];
$args = array(
	'post_type' 		=> 'finbuzz_service',
	'post_status' 		=> 'publish',
	'orderby' 			=> $post_sorting,
	'order' 			=> $post_ordering,
	'posts_per_page' 	=> $number_of_post,
	'paged'          	=> $paged,
);

if ( $cat_single_grid != 0 ) {
	$args['tax_query'] = array (
		array (
			'taxonomy' => 'finbuzz_service_category',
			'field'    => 'ID',
			'terms'    => $cat_single_grid,
		)
	);
}
$thumb_size = 'finbuzz-size4';

$query = new WP_Query( $args );

$temp = FinbuzzTheme_Helper::wp_set_temp_query( $query );

$gap_class = '';
if ( $data['column_no_gutters'] == 'hide' ) {
   $gap_class  = 'no-gutters';
}
$col_class = "col-xl-{$data['col_xl']} col-lg-{$data['col_lg']} col-md-{$data['col_md']} col-sm-{$data['col_sm']} col-{$data['col']}";

 if($data['icon_display']){ 
	$icon_class="show-icon";
 }
 else{
	$icon_class="no-icon";
 }

?>

<div class="service-default service-grid-<?php echo esc_attr( $data['layout'] );?>">
	<div class="row <?php echo esc_attr( $gap_class ); ?> " >	
		<?php
			$i = $data['delay']; $j = $data['duration'];
			if ( $query->have_posts() ) {
				while ( $query->have_posts() ) {
				$query->the_post();
				$excerpt 				= wp_trim_words( get_the_excerpt(), $excerpt_count, '' );			
				$service_title 		= wp_trim_words( get_the_title(), $title_count, '' );
				$finbuzz_service_icon   		= get_post_meta( get_the_ID(), 'finbuzz_service_icon', true );
				$finbuzz_insurance_img   		= get_post_meta( get_the_ID(), 'finbuzz_service_img', true );
				$finbuzz_insurance_hover_img   	= get_post_meta( get_the_ID(), 'finbuzz_service_hover_img', true );		
		?>
		<div class="<?php echo esc_attr( $col_class ) ?>">
			<div class="service-item rt-animate <?php echo esc_attr( $data['animation'] );?> <?php echo esc_attr( $data['animation_effect'] );?>" data-wow-delay="<?php echo esc_attr( $i );?>s" data-wow-duration="<?php echo esc_attr( $j );?>s">
				<div class="service-figure">
					<?php
						if ( has_post_thumbnail() ){
							the_post_thumbnail( $thumb_size, ['class' => 'img-fluid mb-10 width-100'] );
						}
						else {
								echo '<img class="wp-post-image" src="' . FinbuzzTheme_Helper::get_img( 'noimage_390X340.jpg' ) . '" alt="'.get_the_title().'">';
							}
					?>
				</div>
				<div class="service-content-wrap">
					<div class="service-content <?php echo esc_attr( $icon_class ); ?>">
						<?php if($data['icon_display']){ ?>
							<?php if ( (!empty($finbuzz_service_icon ) || !empty($finbuzz_insurance_img ) || !empty($finbuzz_insurance_hover_img) ) && FinbuzzTheme::$options['service_ar_icon'] ) { ?>
								<?php if ( $finbuzz_insurance_img ) : ?>
								<div class="service-img-wrap">	
									<?php if(($finbuzz_insurance_img)): ?>
										<div class="service-hover-img">
										<span><?php echo wp_get_attachment_image($finbuzz_insurance_img);?></span>
										</div>
									<?php else: ?>	
									<?php endif; ?>	
								</div>
								<?php else: ?>
								<div class="icon">
									<span><i class="<?php echo wp_kses_post( $finbuzz_service_icon );?>"></i></span>
								</div>
							<?php endif; ?>
							<?php } ?>
						<?php }  ?>
						<h3 class="service-title"><a href="<?php the_permalink();?>" target="_blank"><?php echo esc_html($service_title);?></a></h3>
						<?php if($data['excerpt_display']){ ?>
							<p><?php echo wp_kses( $excerpt , 'alltext_allow' ); ?></p>
						<?php } ?>
					</div>
				</div>
			</div>
		</div>
		<?php  $i = $i + 0.2;} ?>
	<?php } ?>
	</div>
	<?php  if ( $data['more_button_display']  == 'yes' ) : ?>
		<?php if ( $data['more_button'] == 'show' ) { ?>
			<?php if ( !empty( $data['see_button_text'] ) ) { ?>
				<div class="service-more-button"><a class="btn-style1" href="<?php echo esc_url( $data['see_button_link'] );?>" target="_blank"><?php 	echo esc_html( $data['see_button_text'] );?><?php echo wp_kses_post($svg); ?></a>
				</div>
			<?php } ?>
		<?php } else { ?>
			<?php FinbuzzTheme_Helper::pagination(); ?>
		<?php } ?>
	<?php endif ; ?>	
		<?php FinbuzzTheme_Helper::wp_reset_temp_query( $temp ); ?>
</div>