<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;

use FinbuzzTheme;
use FinbuzzTheme_Helper;
use \WP_Query;

$prefix      = FINBUZZ_CORE_THEME_PREFIX;
$thumb_size  = 'finbuzz-size7';

if ( get_query_var('paged') ) {
	$paged = get_query_var('paged');
}
else if ( get_query_var('page') ) {
	$paged = get_query_var('page');
}
else {
	$paged = 1;
}

$args = array(
	'post_type'      => 'finbuzz_team',
	'posts_per_page' => $data['number'],
	'orderby'        => $data['orderby'],
	'paged' => $paged
);

if ( !empty( $data['cat'] ) ) {
	$args['tax_query'] = array(
		array(
			'taxonomy' => 'finbuzz_team_category',
			'field' => 'term_id',
			'terms' => $data['cat'],
		)
	);
}

switch ( $data['orderby'] ) {
	case 'title':
	case 'menu_order':
	$args['order'] = 'ASC';
	break;
}

$query = new WP_Query( $args );
$temp = FinbuzzTheme_Helper::wp_set_temp_query( $query );
$col_class = "col-lg-{$data['col_lg']} col-md-{$data['col_md']} col-sm-{$data['col_sm']} col-{$data['col_xs']} col-{$data['col_mobile']}";
?>
<div class="team-default team-multi-layout-5 team-grid-<?php echo esc_attr( $data['style'] );?>">
	<div class="row auto-clear">
		<?php 
		$i = $data['delay']; $j = $data['duration'];
		if ( $query->have_posts() ) {
			while ( $query->have_posts() ) {
				$query->the_post();
				$id            = get_the_id();
				$position   	= get_post_meta( $id, 'finbuzz_team_position', true );
				$socials       = get_post_meta( $id, 'finbuzz_team_socials', true );
				$social_fields = FinbuzzTheme_Helper::team_socials();
				$content = apply_filters( 'the_content', get_the_content() );
				$content = wp_trim_words( $content, $data['count'], '' );
				$content = "<p>$content</p>";
				?>
				<div class="<?php echo esc_attr( $col_class );?>" >
					<div class="team-layout style-2">
						<div class="team-thumbs position-relative">
							<a class="w-100" href="<?php the_permalink();?>">
								<?php
									if ( has_post_thumbnail() ){
										the_post_thumbnail( $thumb_size );
									}
									else {
										if ( !empty( FinbuzzTheme::$options['no_preview_image']['id'] ) ) {
											echo wp_get_attachment_image( FinbuzzTheme::$options['no_preview_image']['id'], $thumb_size );
										}
										else {
											echo '<img class="wp-post-image" src="' . FinbuzzTheme_Helper::get_img( 'noimage_400X400.jpg' ) . '" alt="'.get_the_title().'">';
										}
									}
								?>
							</a>
							<ul class="team-social">
								<li class="social-item">
									<a href="<?php the_permalink();?>" class="social-hover-icon social-link">
										<svg width="16" height="21" viewBox="0 0 16 21" fill="none" xmlns="http://www.w3.org/2000/svg">
											<path fill-rule="evenodd" clip-rule="evenodd" d="M9.69694 3.33789C9.69694 1.49789 11.1087 0.00489241 12.848 0.00489241C13.2609 0.00384058 13.67 0.089217 14.0519 0.256147C14.4338 0.423077 14.781 0.66829 15.0737 0.977788C15.3664 1.28729 15.5988 1.65501 15.7578 2.05995C15.9167 2.4649 15.999 2.89914 16 3.33789C16 5.17889 14.5882 6.67189 12.848 6.67189C12.4307 6.67243 12.0174 6.58484 11.6322 6.4142C11.247 6.24356 10.8976 5.99327 10.6042 5.67789L6.24188 8.83389C6.36337 9.47688 6.30379 10.1437 6.07059 10.7509L10.8536 14.0909C11.417 13.6027 12.122 13.3367 12.8489 13.3379C13.2619 13.337 13.6709 13.4225 14.0528 13.5895C14.4346 13.7566 14.7817 14.0019 15.0743 14.3115C15.367 14.6211 15.5993 14.9889 15.7581 15.3939C15.9169 15.7989 15.9991 16.2331 16 16.6719C16 18.5119 14.5882 20.0049 12.848 20.0049C12.0142 20.0067 11.2138 19.6567 10.6229 19.0316C10.032 18.4066 9.69894 17.5578 9.69694 16.6719C9.69621 16.2045 9.78892 15.7423 9.96894 15.3159L5.22353 12.0049C4.64886 12.5358 3.91259 12.8275 3.15106 12.8259C2.73809 12.8269 2.32897 12.7415 1.94707 12.5745C1.56518 12.4075 1.218 12.1622 0.925376 11.8526C0.632748 11.543 0.400406 11.1751 0.241626 10.7701C0.0828465 10.365 0.000740683 9.93067 0 9.49189C0.000864162 9.05319 0.0830612 8.61896 0.241896 8.21402C0.400731 7.80908 0.633092 7.44135 0.925708 7.13184C1.21832 6.82233 1.56546 6.5771 1.94729 6.41016C2.32912 6.24322 2.73817 6.15784 3.15106 6.15889C4.15247 6.15889 5.04282 6.65189 5.61976 7.41989L9.84847 4.36089C9.74786 4.03042 9.69673 3.68522 9.69694 3.33789Z" fill="currentColor"/>
										</svg>
									</a>
									<ul class="team-social-dropdown">
										<?php foreach ( $socials as $key => $social ): ?>
											<?php if ( !empty( $social ) ): ?>
												<li class="social-item"><a class="social-link" target="_blank" href="<?php echo esc_url( $social );?>"><i class="fab <?php echo esc_attr( $social_fields[$key]['icon'] );?>" aria-hidden="true"></i></a></li>
											<?php endif; ?>
										<?php endforeach; ?>
									</ul>
								</li>
							</ul>
						</div>
						<div class="team-content text-center position-relative">
							<div class="inner">
								<h3 class="name">
									<a href="<?php the_permalink();?>"><?php the_title();?></a>
								</h3>
								<?php if ( $position && $data['designation_display']  == 'yes' ) { ?>
									<h4 class="designation"><?php echo esc_html( $position );?></h4>
								<?php } ?>

								<?php if ( $data['content_display']  == 'yes' ) { ?>
									<?php echo wp_kses_post( $content );?>
								<?php } ?>	
								
								<div class="team-shape">
									<svg width="68" height="44" viewBox="0 0 68 44" fill="none" xmlns="http://www.w3.org/2000/svg">
										<g opacity="0.6">
										<path opacity="0.27" d="M-0.000665665 3.08496H20.9424L10.4709 17.2523L-0.000665665 3.08496Z" fill="currentColor"/>
										<path opacity="0.44" d="M1.84759 43.7389H67.1406L52.0497 23.5218L34.4476 0.00488281L1.84759 43.7389Z" fill="currentColor"/>
										</g>
									</svg>
								</div>
							</div>
							<div class="dot-shape">
								<svg width="45" height="37" viewBox="0 0 84 84" fill="none" xmlns="http://www.w3.org/2000/svg">
									<g opacity="1">
									<circle cx="2" cy="2" r="2" fill="currentColor"/>
									<circle cx="18" cy="2" r="2" fill="currentColor"/>
									<circle cx="34" cy="2" r="2" fill="currentColor"/>
									<circle cx="50" cy="2" r="2" fill="currentColor"/>
									<circle cx="66" cy="2" r="2" fill="currentColor"/>
									<circle cx="82" cy="2" r="2" fill="currentColor"/>
									<circle cx="2" cy="18" r="2" fill="currentColor"/>
									<circle cx="18" cy="18" r="2" fill="currentColor"/>
									<circle cx="34" cy="18" r="2" fill="currentColor"/>
									<circle cx="50" cy="18" r="2" fill="currentColor"/>
									<circle cx="66" cy="18" r="2" fill="currentColor"/>
									<circle cx="82" cy="18" r="2" fill="currentColor"/>
									<circle cx="2" cy="34" r="2" fill="currentColor"/>
									<circle cx="18" cy="34" r="2" fill="currentColor"/>
									<circle cx="34" cy="34" r="2" fill="currentColor"/>
									<circle cx="50" cy="34" r="2" fill="currentColor"/>
									<circle cx="66" cy="34" r="2" fill="currentColor"/>
									<circle cx="82" cy="34" r="2" fill="currentColor"/>
									<circle cx="2" cy="50" r="2" fill="currentColor"/>
									<circle cx="18" cy="50" r="2" fill="currentColor"/>
									<circle cx="34" cy="50" r="2" fill="currentColor"/>
									<circle cx="50" cy="50" r="2" fill="currentColor"/>
									<circle cx="66" cy="50" r="2" fill="currentColor"/>
									<circle cx="82" cy="50" r="2" fill="currentColor"/>
									<circle cx="2" cy="66" r="2" fill="currentColor"/>
									<circle cx="18" cy="66" r="2" fill="currentColor"/>
									<circle cx="34" cy="66" r="2" fill="currentColor"/>
									<circle cx="50" cy="66" r="2" fill="currentColor"/>
									<circle cx="66" cy="66" r="2" fill="currentColor"/>
									<circle cx="82" cy="66" r="2" fill="currentColor"/>
									<circle cx="2" cy="82" r="2" fill="currentColor"/>
									<circle cx="18" cy="82" r="2" fill="currentColor"/>
									<circle cx="34" cy="82" r="2" fill="currentColor"/>
									<circle cx="50" cy="82" r="2" fill="currentColor"/>
									<circle cx="66" cy="82" r="2" fill="currentColor"/>
									<circle cx="82" cy="82" r="2" fill="currentColor"/>
									</g>
									</svg>
							</div>
						</div>
					</div>
				</div>
			<?php $i = $i + 0.2; $j = $j + 0.2; } ?>
		<?php } ?>
		<?php ?>
	</div>
	<?php  if ( $data['more_button_display']  == 'yes' ) : ?>	
		<?php if ( $data['more_button'] == 'show' ) { ?>
			<?php if ( !empty( $data['see_button_text'] ) ) { ?>
			<div class="team-button"><a class="btn-style1" href="<?php echo esc_url( $data['see_button_link'] );?>"><?php echo esc_html( $data['see_button_text'] );?></a></div>
			<?php } ?>
		<?php } else { ?>
			<?php FinbuzzTheme_Helper::pagination(); ?>
		<?php } ?>
	<?php endif; ?>
	<?php FinbuzzTheme_Helper::wp_reset_temp_query( $temp ); ?>
</div>