<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;
use FinbuzzTheme_Helper;
use Elementor\Group_Control_Image_Size;

// image
$getimg = Group_Control_Image_Size::get_attachment_image_html( $data, 'icon_image_size', 'video_image' );
if(empty($data['support_text'])){
	$support_class="no-support-text";
}
else{
	$support_class="has-support-text";
}
?>
<div class="rt-video video-<?php echo esc_attr( $data['style'] );?>">
	<div class="rtin-video">
        <?php if($data['shape_display']=='yes'){?>
            <div class="shape-img">
                <img src="<?php echo FINBUZZ_ASSETS_URL . 'element/element_new_14.png'; ?>" width="155" height="110" alt="">
            </div>
        <?php } ?>
		<div class="video-thumbnail">
			<div class="item-img">
			<?php echo wp_kses_post($getimg);?>
			</div>
			<div class="item-icon">
				<a class="rtin-play rt-video-popup" href="<?php echo esc_url( $data['videourl']['url'] );?>"><span class="play-icon"><i class="fas fa-play"></i></span></a>
			</div>
		</div>
		<div class="video-info <?php echo esc_attr( $support_class); ?>">
			<ul>
				<?php if($data['support_text']){ ?>
					<li><?php echo wp_kses_post( $data['support_text'] ); ?></li>
				<?php } if($data['phone']){ ?>
					<li><a href="tel:<?php echo esc_attr( $data['phone'] ); ?>"><i class="fas fa-phone-alt"></i><?php echo wp_kses_post($data['phone']); ?></a></li>
				<?php } ?>
			</ul>
		</div>
	</div>
</div>
