<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Css_Filter;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit;

class Image extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ){
		$this->rt_name = esc_html__( 'RT Image', 'finbuzz-core' );
		$this->rt_base = 'rt-image';
		parent::__construct( $data, $args );
	}
	
	private function rt_load_scripts(){
		wp_enqueue_script( 'parallax-scroll' );
	}	
	private function rt_wow_load_scripts(){
		wp_enqueue_script( 'rt-wow' );
	}

	public function rt_fields(){
		$fields = array(
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_general',
				'label'   => esc_html__( 'General', 'finbuzz-core' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'style',
				'label'   => esc_html__( 'Image Style', 'finbuzz-core' ),
				'options' => array(
					'style1' => esc_html__( 'Style 1' , 'finbuzz-core' ),
					'style2' => esc_html__( 'Style 2', 'finbuzz-core' ),
					'style3' => esc_html__( 'Style 3', 'finbuzz-core' ),
					'style4' => esc_html__( 'Style 4', 'finbuzz-core' ),
					'style5' => esc_html__( 'Style 5', 'finbuzz-core' ),
					'style6' => esc_html__( 'Style 6', 'finbuzz-core' ),
					'style7' => esc_html__( 'Style 7', 'finbuzz-core' ),
					'style8' => esc_html__( 'Style 8', 'finbuzz-core' ),
					'style9' => esc_html__( 'Style 9', 'finbuzz-core' ),
					'style10' => esc_html__( 'Style 10', 'finbuzz-core' ),
					'style11' => esc_html__( 'Style 11', 'finbuzz-core' ),
					'style12' => esc_html__( 'Style 12', 'finbuzz-core' ),
					'style13' => esc_html__( 'Style 13', 'finbuzz-core' ),
					'style14' => esc_html__( 'Style 14', 'finbuzz-core' ),
				),
				'default' => 'style1',
			),
			array(
				'type'    => Controls_Manager::HEADING,
				'id'      => 'heading_style4',
				'label'   => esc_html__( 'Use same height and width image ', 'finbuzz-core' ),
				'condition'   => array( 'style' => array('style7') )
			),
			array(
				'type'    => Controls_Manager::HEADING,
				'id'      => 'heading',
				'label'   => esc_html__( 'Upload PNG same height and width image ', 'finbuzz-core' ),
				'condition'   => array( 'style' => array('style2') )
			),
			array(
				'type'    => Controls_Manager::MEDIA,
				'id'      => 'rt_image',
				'label'   => esc_html__( 'Image', 'finbuzz-core' ),
				'default' => array(
                    'url' => Utils::get_placeholder_image_src(),
                ),
				'description' => esc_html__( 'Recommended full image', 'finbuzz-core' ),
			),
			array(
				'type'    => Controls_Manager::MEDIA,
				'id'      => 'rt_image2',
				'label'   => esc_html__( 'Image 2', 'finbuzz-core' ),
				'default' => array(
                    'url' => Utils::get_placeholder_image_src(),
                ),
				'description' => esc_html__( 'Recommended full image', 'finbuzz-core' ),
				'condition'   => array( 'style' => array('style14') )
			),

			
			/**Image addon style 10 shape image */
			array(
				'type'    => Controls_Manager::MEDIA,
				'id'      => 'image_shape_style10',
				'label'   => esc_html__( 'Shape Image', 'finbuzz-core' ),
				'condition'   => array( 'style' => array('style10') ),
				'description' => esc_html__( 'Recommended full image', 'finbuzz-core' ),
				
			),
			/**Image addon style 10 shape image end*/
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'paralax_animation',
				'label'   => esc_html__( 'Image Animation', 'finbuzz-core' ),
				'options' => array(
					'paralax' => esc_html__( 'Paralax' , 'finbuzz-core' ),
					'spin' => esc_html__( 'Spin', 'finbuzz-core' ),
					'scale' => esc_html__( 'Scale', 'finbuzz-core' ),
					'vertical' => esc_html__( 'Vertical', 'finbuzz-core' ),
				),
				'condition'   => array( 'style' => array('style9') ),
				'default' => 'spin',
			),
			
			array(
				'type'    => Controls_Manager::HEADING,
				'id'      => 'heading3',
				'label'   => esc_html__( 'Use width 487 and height 589 size image', 'finbuzz-core' ),
				'condition'   => array( 'style' => array('style3') )
			),
			array(
				'type'    => Controls_Manager::HEADING,
				'id'      => 'heading4',
				'label'   => esc_html__( 'Use same height and width image', 'finbuzz-core' ),
				'condition'   => array( 'style' => array('style5') )
			),
			array(
				'type'    => Group_Control_Image_Size::get_type(),
				'mode'    => 'group',				
				'label'   => esc_html__( 'image size', 'finbuzz-core' ),	
				'name' => 'icon_image_size', 
				'separator' => 'none',		
			),
			array(
				'type'    => Controls_Manager::MEDIA,
				'id'      => 'rt_image2_style7',
				'label'   => esc_html__( 'Mask Image', 'finbuzz-core' ),
				'description' => esc_html__( 'Recommended full image', 'finbuzz-core' ),
				'condition'   => array( 'style' => array('style7'))
			),
			array(
				'type'    => Controls_Manager::MEDIA,
				'id'      => 'rt_image3_style7',
				'label'   => esc_html__( 'Percentage Image', 'finbuzz-core' ),
				'description' => esc_html__( 'If not uploaded, default will be used', 'finbuzz-core' ),
				'condition'   => array( 'style' => array('style7'))
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'mouse_follow',
				'label'       => esc_html__( 'Mouse Follow Effect', 'finbuzz-core' ),
				'label_on'    => esc_html__( 'On', 'finbuzz-core' ),
				'label_off'   => esc_html__( 'Off', 'finbuzz-core' ),
				'default'     => 'yes',
				'description' => esc_html__( 'Show or Hide Content. Default: On', 'finbuzz-core' ),
				'condition'   => array( 'style' => array('style1','style3','style6','style7','style8','style11','style12')),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'mask_image_display',
				'label'       => esc_html__( 'Mask Image Show', 'finbuzz-core' ),
				'label_on'    => esc_html__( 'On', 'finbuzz-core' ),
				'label_off'   => esc_html__( 'Off', 'finbuzz-core' ),
				'default'     => 'yes',
				'description' => esc_html__( 'Show or Hide Content. Default: On', 'finbuzz-core' ),
				'condition'   => array( 'style' => array('style7')),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'shape3_display',
				'label'       => esc_html__( 'Shape Image Show', 'finbuzz-core' ),
				'label_on'    => esc_html__( 'On', 'finbuzz-core' ),
				'label_off'   => esc_html__( 'Off', 'finbuzz-core' ),
				'default'     => 'yes',
				'description' => esc_html__( 'Show or Hide Content. Default: On', 'finbuzz-core' ),
				'condition'   => array( 'style' => array('style7')),
			),		
			array(
				'type'    => Controls_Manager::TEXTAREA,
				'id'      => 'info_title',
				'label'   => esc_html__( 'Info Title', 'finbuzz-core' ),
				'condition'   => array( 'style' => array( 'style1' ) ),
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'phone_number',
				'label_block'=>true,   
				'label'   => esc_html__( 'Phone Number', 'finbuzz-core' ),
				'condition'   => array( 'style' => array( 'style1' ) ),
			),				
				
			array(
				'type'  => Controls_Manager::URL,
				'id'    => 'url',
				'label' => esc_html__( 'Link (Optional)', 'finbuzz-core' ),
				'placeholder' => 'https://your-link.com',
				'condition'=>[
					'style!'=>'style14'
				]
			),
			
			array(
				'type'    => Controls_Manager::DIMENSIONS,
				'id'      => 'border_radius',
				'label'   => esc_html__( 'Border Radius', 'finbuzz-core' ),
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .image-default .image-box a > img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .image-default .image-box > img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .image-default .image-box' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .image-default .image-box .full-image > img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .image-style14 .image-box .item img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .image-style14 .image-box .item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					
				],
				'condition'   => array( 'style' => array( 'style1','style3','style4','style6','style7','style8','style11','style14') ),
			),			
			
			array(
				'mode' => 'section_end',
			),

			/*Style Option*/
			/**Image addon 1 style */
			array(
				'mode'    => 'section_start',
				'id'      => 'shape1_style',
				'label'   => esc_html__( 'Image Shape 1', 'finbuzz-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
				'condition'   => array( 'style' => array( 'style1') ),
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'shape1_right_position',
				'label'   => esc_html__( 'Left Shape Position', 'finbuzz-core' ),
				'selectors' => array(
				  '{{WRAPPER}} .image-style1 .image-box  .about-shape li:nth-child(1)' => 'left: {{VALUE}}px',
				),
				'default' => '-74',
				'description' => esc_html__( 'Use unit px', 'finbuzz-core' ),
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'shape1_top_position',
				
				'label'   => esc_html__( 'Top Shape Position', 'finbuzz-core' ),
				'selectors' => array(
				  '{{WRAPPER}} .image-style1 .image-box  .about-shape li:nth-child(1)' => 'top: {{VALUE}}px',
				),
				'default' => '-60',
				'description' => esc_html__( 'Use unit px', 'finbuzz-core' ),
			),
			array(
				'mode' => 'section_end',
			),

			/**Image shape 2 style */

			array(
				'mode'    => 'section_start',
				'id'      => 'shape2_style',
				'label'   => esc_html__( 'Image Shape 2', 'finbuzz-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
				'condition'   => array( 'style' => array( 'style1' ) ),
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'shape2_right_position',
				
				'label'   => esc_html__( 'Right Shape Position', 'finbuzz-core' ),
				'selectors' => array(
				  '{{WRAPPER}} .image-style1 .image-box  .about-shape li:nth-child(2)' => 'right: {{VALUE}}px',
				),
				'default' => '-25',
				'description' => esc_html__( 'Use unit px', 'finbuzz-core' ),
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'shape2_top_position',
				
				'label'   => esc_html__( 'Top Shape Position', 'finbuzz-core' ),
				'selectors' => array(
				  '{{WRAPPER}} .image-style1 .image-box  .about-shape li:nth-child(2)' => 'top: {{VALUE}}px',
				  
				),
				'default' => '70',
				'description' => esc_html__( 'Use unit px', 'finbuzz-core' ),
			),
			array(
				'mode' => 'section_end',
			),

			/**Image shape 3 style */

			array(
				'mode'    => 'section_start',
				'id'      => 'shape3_style',
				'label'   => esc_html__( 'Image Shape 3', 'finbuzz-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
				'condition'   => array( 'style' => array( 'style1' ) ),
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'shape3_right_position',
				
				'label'   => esc_html__( 'Left Shape Position', 'finbuzz-core' ),
				'selectors' => array(
				  '{{WRAPPER}} .image-style1 .image-box  .about-shape li:nth-child(3)' => 'left: {{VALUE}}px',
				),
				'default' => '-36',
				'description' => esc_html__( 'Use unit px', 'finbuzz-core' ),
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'shape3_bottom_position',
				
				'label'   => esc_html__( 'Bottom Shape Position', 'finbuzz-core' ),
				'selectors' => array(
				  '{{WRAPPER}} .image-style1 .image-box  .about-shape li:nth-child(3)' => 'bottom: {{VALUE}}px',
				  
				),
				'default' => '120',
				'description' => esc_html__( 'Use unit px', 'finbuzz-core' ),
			),
			array(
				'mode' => 'section_end',
			),

			/**Image addon 1 style end */


			//Image Addon Style 3 start


			//Image Shape 1 style


			array(
				'mode'    => 'section_start',
				'id'      => 'image3__addon_shape1_style',
				'label'   => esc_html__( 'Image Shape 1', 'finbuzz-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
				'condition'   => array( 'style' => array( 'style3' ) ),
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'image3__addon_shape1_right_position',
				
				'label'   => esc_html__( 'Right Shape Position', 'finbuzz-core' ),
				'selectors' => array(
				  '{{WRAPPER}} .image-style3  .image-box .about-shape li:nth-child(1)' => 'right: {{VALUE}}px',
				),
				'default' => '-48',
				'description' => esc_html__( 'Use unit px', 'finbuzz-core' ),
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'image3__addon_shape1_top_position',
				
				'label'   => esc_html__( 'Top Shape Position', 'finbuzz-core' ),
				'selectors' => array(
				  '{{WRAPPER}} .image-style3  .image-box .about-shape li:nth-child(1)' => 'top: {{VALUE}}px',
				),
				'default' => '-48',
				'description' => esc_html__( 'Use unit px', 'finbuzz-core' ),
			),
			array(
				'mode' => 'section_end',
			),

			//Image Shape 2 style

			array(
				'mode'    => 'section_start',
				'id'      => 'image3__addon_shape2_style',
				'label'   => esc_html__( 'Image Shape 2', 'finbuzz-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
				'condition'   => array( 'style' => array( 'style3' ) ),
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'image3__addon_shape2_right_position',
				
				'label'   => esc_html__( 'Right Shape Position', 'finbuzz-core' ),
				'selectors' => array(
				  '{{WRAPPER}} .image-style3  .image-box .about-shape li:nth-child(2)' => 'right: {{VALUE}}px',
				),
				'default' => '-70',
				'description' => esc_html__( 'Use unit px', 'finbuzz-core' ),
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'image3__addon_shape2_top_position',
				
				'label'   => esc_html__( 'Top Shape Position', 'finbuzz-core' ),
				'selectors' => array(
				  '{{WRAPPER}} .image-style3  .image-box .about-shape li:nth-child(2)' => 'top: {{VALUE}}px',
				),
				'default' => '90',
				'description' => esc_html__( 'Use unit px', 'finbuzz-core' ),
			),
			array(
				'mode' => 'section_end',
			),
            
			//Image Shape 3 style
			array(
				'mode'    => 'section_start',
				'id'      => 'image3__addon_shape3_style',
				'label'   => esc_html__( 'Image Shape 3', 'finbuzz-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
				'condition'   => array( 'style' => array( 'style3' ) ),
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'image3__addon_shape3_left_position',
				
				'label'   => esc_html__( 'Left Shape Position', 'finbuzz-core' ),
				'selectors' => array(
				  '{{WRAPPER}} .image-style3  .image-box .about-shape li:nth-child(3)' => 'left: {{VALUE}}px',
				),
				'default' => '-50',
				'description' => esc_html__( 'Use unit px', 'finbuzz-core' ),
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'image3__addon_shape3_bottom_position',
				
				'label'   => esc_html__( 'Bottom Shape Position', 'finbuzz-core' ),
				'selectors' => array(
				  '{{WRAPPER}} .image-style3  .image-box .about-shape li:nth-child(3)' => 'bottom: {{VALUE}}px',
				),
				'default' => '-50',
				'description' => esc_html__( 'Use unit px', 'finbuzz-core' ),
			),
			array(
				'mode' => 'section_end',
			),

			//Image Shape 4 style
			array(
				'mode'    => 'section_start',
				'id'      => 'image3__addon_shape4_style',
				'label'   => esc_html__( 'Image Shape 4', 'finbuzz-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
				'condition'   => array( 'style' => array( 'style3' ) ),
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'image3__addon_shape4_left_position',
				
				'label'   => esc_html__( 'Left Shape Position', 'finbuzz-core' ),
				'selectors' => array(
				  '{{WRAPPER}} .image-style3  .image-box .about-shape li:nth-child(4)' => 'left: {{VALUE}}px',
				),
				'default' => '-50',
				'description' => esc_html__( 'Use unit px', 'finbuzz-core' ),
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'image3__addon_shape4_top_position',
				
				'label'   => esc_html__( 'Bottom Shape Position', 'finbuzz-core' ),
				'selectors' => array(
				  '{{WRAPPER}} .image-style3  .image-box .about-shape li:nth-child(4)' => 'top: {{VALUE}}px',
				),
				'default' => '-16',
				'description' => esc_html__( 'Use unit px', 'finbuzz-core' ),
			),
			array(
				'mode' => 'section_end',
			),

			//Image Addon Style 3 end

			array(
				'mode'    => 'section_start',
				'id'      => 'count_style',
				'label'   => esc_html__( 'Count', 'finbuzz-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
				'condition'   => array( 'style' => array( 'style2' ) ),
			),
			array (
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'    => 'count_typo',
				'label'   => esc_html__( 'Count Typo', 'finbuzz-core' ),
				'selector' => '{{WRAPPER}} .image-style2 .rtin-image .success-box .content .success-count',
				'condition'   => array( 'style' => array( 'style2' ) ),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'count_color',
				'label'   => esc_html__( 'Count Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .image-style2 .rtin-image .success-box .content .success-count' => 'color: {{VALUE}}'
					
				),
				'condition'   => array( 'style' => array( 'style2' ) ),
			),
			array(
				'mode' => 'section_end',
			),
			array(
				'mode'    => 'section_start',
				'id'      => 'title_style',
				'label'   => esc_html__( 'Title', 'finbuzz-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
				'condition'   => array( 'style' => array( 'style2' ) ),
			),
			array (
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'    => 'title_typo',
				'label'   => esc_html__( 'Title Typo', 'finbuzz-core' ),
				'selector' => '{{WRAPPER}} .image-style2 .rtin-image .success-box .content .rtin-title',
				'condition'   => array( 'style' => array( 'style2' ) ),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'title_color',
				'label'   => esc_html__( 'Title Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .image-style2 .rtin-image .success-box .content  .rtin-title' => 'color: {{VALUE}}',
					'{{WRAPPER}} .image-style2 .rtin-image .success-box .content .rtin-title a' => 'color: {{VALUE}}',
				),
				'condition'   => array( 'style' => array( 'style2' ) ),
			),
			array(
				'mode' => 'section_end',
			),
			array(
				'mode'    => 'section_start',
				'id'      => 'icon_style',
				'label'   => esc_html__( 'Icon Style', 'finbuzz-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
				'condition'   => array( 'style' => array( 'style2' ) ),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'icon_color',
				'label'   => esc_html__( 'Icon Box Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .image-style2 .rtin-image .success-box .success-count::after' => 'background-color: {{VALUE}}',
				),
				'condition'   => array( 'style' => array( 'style2' ) ),
			),
			array(
				'mode' => 'section_end',
			),
			//Image Addon Style 4,5
			array(
				'mode'    => 'section_start',
				'id'      => 'overlay_style',
				'label'   => esc_html__( 'Image Background Overlay', 'finbuzz-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
				'condition'   => array( 'style' => array( 'style4','style5' )),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'overlay_color',
				'label'   => esc_html__( 'Image Overlay Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .image-style4 .image-box:after' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .image-style5 .image-box:after' => 'background-color: {{VALUE}}',
				),
				'condition'   => array( 'style' => array( 'style4','style5')),
			),
			array(
				'type'    => Controls_Manager::SLIDER,
				'id'      => 'image_overlay_size',
				'label'   => esc_html__( 'Percentage', 'finbuzz-core' ),
				'default' => [
					'size' => .5,
				],
				'range' => [
					'px' => [
						'max' => 1,
						'min' => 0.10,
						'step' => 0.01,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .image-style4 .image-box:after' => 'opacity: {{SIZE}};',
					'{{WRAPPER}} .image-style5 .image-box:after' => 'opacity: {{SIZE}};',
				],
				'condition'   => array( 'style' => array( 'style4','style5')),
			),
			array(
				'mode' => 'section_end',
			),
			/**Image addon style 6 shape position */
			array(
				'mode'    => 'section_start',
				'id'      => 'image_style6_shape_position',
				'label'   => esc_html__( 'Shape Image Position', 'finbuzz-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
				'condition'   => array( 'style' => array( 'style6')),
			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'image_style6_shape_position1',
				'label'       => esc_html__( 'Image Position 1', 'finbuzz-core' ),
				'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => -200,
                        'max' => 1000, 
                    ],
					'%' => [
						'min' => -20,
						'max' => 100,
					],
                ],
                'default' => [
					'unit' => 'px',
				],
				'selectors' => array(
					'{{WRAPPER}} .image-style6 .rtin-image .image-shape li:nth-child(1)' => 'top: {{SIZE}}{{UNIT}}',
				),
			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'image_style6_shape_position2',
				'label'       => esc_html__( 'Shape Image Position 2', 'finbuzz-core' ),
				'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => -200,
                        'max' => 1000, 
                    ],
					'%' => [
						'min' => -20,
						'max' => 100,
					],
                ],
				'selectors' => array(
					'{{WRAPPER}} .image-style6 .rtin-image .image-shape li:nth-child(1)' => 'left: {{SIZE}}{{UNIT}}',
				),
			),
			array(
				'mode' => 'section_end',
			),
			//Image Addon Style 7
			array(
				'mode'    => 'section_start',
				'id'      => 'image_shape_position',
				'label'   => esc_html__( 'Image Shape Position', 'finbuzz-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
				'condition'   => array( 'style' => array( 'style7')),
			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'image_style7_shape_position1',
				'label'       => esc_html__( 'Shape Image 1 Position ', 'finbuzz-core' ),
				'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => -1000,
                        'max' => 1000, 
                    ],
					'%' => [
						'min' => -50,
						'max' => 100,
					],
                ],
				'selectors' => array(
					'{{WRAPPER}} .image-style7 .image-box .images-shape li:nth-child(2)' => 'bottom: {{SIZE}}{{UNIT}}',
				),
			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'image_style7_shape_position2',
				'label'       => esc_html__( 'Shape Image 2 Position', 'finbuzz-core' ),
				'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => -1000,
                        'max' => 1000, 
                    ],
					'%' => [
						'min' => -50,
						'max' => 100,
					],
                ],
				'selectors' => array(
					'{{WRAPPER}} .image-style7 .image-box .images-shape li:nth-child(4)' => 'bottom: {{SIZE}}{{UNIT}}',
				),
			),
			array(
				'mode' => 'section_end',
			),
			array(
				'mode'    => 'section_start',
				'id'      => 'mask_image_position',
				'label'   => esc_html__( 'Mask Image Position', 'finbuzz-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
				'condition'   => array( 'style' => array( 'style7')),
			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'mask_image_position1',
				'label'       => esc_html__( 'Mask Image Position 1', 'finbuzz-core' ),
				'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => -200,
                        'max' => 1000, 
                    ],
					'%' => [
						'min' => -50,
						'max' => 100,
					],
                ],
                'default' => [
					'unit' => '%',
				],
				'selectors' => array(
					'{{WRAPPER}} .image-style7 .image-box .mask-image' => 'top: {{SIZE}}{{UNIT}}',
				),
			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'mask_image_position2',
				'label'       => esc_html__( 'Mask Image Position 2', 'finbuzz-core' ),
				'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => -200,
                        'max' => 1000, 
                    ],
					'%' => [
						'min' => -50,
						'max' => 100,
					],
                ],
				'selectors' => array(
					'{{WRAPPER}} .image-style7 .image-box .mask-image' => 'right: {{SIZE}}{{UNIT}}',
				),
			),
			array(
				'mode' => 'section_end',
			),
			
			array(
				'mode'    => 'section_start',
				'id'      => 'success_image_position',
				'label'   => esc_html__( 'Success Image Position', 'finbuzz-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
				'condition'   => array( 'style' => array( 'style7')),
			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'succ_image_position1',
				'label'       => esc_html__( 'Success Image Position 1', 'finbuzz-core' ),
				'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => -200,
                        'max' => 1000, 
                    ],
					'%' => [
						'min' => -50,
						'max' => 100,
					],
                ],
                'default' => [
					'unit' => 'px',
				],
				'selectors' => array(
					'{{WRAPPER}} .image-style7 .image-box .images-shape li:nth-child(1)' => 'bottom: {{SIZE}}{{UNIT}}',
				),
			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'succ_image_position2',
				'label'       => esc_html__( 'Success Image Position 2', 'finbuzz-core' ),
				'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000, 
                    ],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
                ],
				'selectors' => array(
					'{{WRAPPER}} .image-style7 .image-box .images-shape li:nth-child(1)' => 'left: {{SIZE}}{{UNIT}}',
				),
			),
			array(
				'mode' => 'section_end',
			),
			array(
				'mode'    => 'section_start',
				'id'      => 'image11_shape_image',
				'label'   => esc_html__( 'Shape Image 3', 'finbuzz-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
				'condition'   => array( 'style' => array( 'style11')),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'image11_shape_display',
				'label'       => esc_html__( 'Shape Display', 'finbuzz-core' ),
				'label_on'    => esc_html__( 'On', 'finbuzz-core' ),
				'label_off'   => esc_html__( 'Off', 'finbuzz-core' ),
				'default'     => 'yes',
				'description' => esc_html__( 'Show or Hide Content. Default: onn', 'finbuzz-core' ),
			),
			array(
				'mode' => 'section_end',
			),
			// image style 14 settings
			array(
				'mode'    => 'section_start',
				'id'      => 'img_position',
				'label'   => esc_html__( 'Image 2 Position', 'finbuzz-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
				'condition'   => array( 'style' => array( 'style14')),
			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'image2_position1',
				'label'       => esc_html__( 'Image 2 Position 1', 'finbuzz-core' ),
				'size_units' => [ 'px', '%' ],
				'mode'		  =>'responsive',
                'range' => [
                    'px' => [
                        'min' => -500,
                        'max' => 1000, 
                    ],
					'%' => [
						'min' => -50,
						'max' => 100,
					],
                ],
                'default' => [
					'unit' => 'px',
				],
				'selectors' => array(
					'{{WRAPPER}} .image-style14 .image-box .item-2' => 'bottom: {{SIZE}}{{UNIT}}',
				),
			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'image2_position2',
				'mode'		  =>'responsive',
				'label'       => esc_html__( 'Image 2 Position 2', 'finbuzz-core' ),
				'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => -800,
                        'max' => 120, 
                    ],
					'%' => [
						'min' => -50,
						'max' => 100,
					],
                ],
                'default' => [
					'unit' => 'px',
				],
				'selectors' => array(
					'{{WRAPPER}} .image-style14 .image-box .item-2' => 'right: {{SIZE}}{{UNIT}}',
				),
			),
			array(
				'mode' => 'section_end',
			),


			// image style 9 settings
			array(
				'mode'    => 'section_start',
				'id'      => 'image_size_sec',
				'label'   => esc_html__( 'Image 2 Position', 'finbuzz-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
				'condition'   => array( 'style' => array( 'style9')),
			),

			array(
				'type'    => Group_Control_Css_Filter::get_type(),
				'mode'    => 'group',		
				'name' => 'css_filters',
				'selector' => '{{WRAPPER}} .image-box img',
			),

			array(
				'type'    => Controls_Manager::SLIDER,
				'id'      => 'image_size',
				'label'   => esc_html__( 'Image Size', 'finbuzz-core' ),
				'range' => [
					'px' => [
						'max' => 1500,
						'min' => 5,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .image-box img' => 'max-width: {{SIZE}}px',
				],
				
			),

			array(
				'mode' => 'section_end',
			),


		);
		return $fields;
	}

	protected function render() {
		$data = $this->get_settings();

		switch ( $data['style'] ) {
			case 'style14':
			$template = 'image-14';
			break;
			case 'style13':
			$template = 'image-13';
			break;
			case 'style12':
			$template = 'image-12';
			break;
			case 'style11':
			$template = 'image-11';
			break;
			case 'style10':
			$template = 'image-10';
			break;
			case 'style9':
			$template = 'image-9';
			break;
			case 'style8':
			$template = 'image-8';
			break;
			case 'style7':
			$template = 'image-7';
			break;
			case 'style6':
			$template = 'image-6';
			break;
			case 'style5':
			$template = 'image-5';
			break;
			case 'style4':
			$template = 'image-4';
			break;
			case 'style3':
			$this->rt_load_scripts();
			$template = 'image-3';
			break;
			case 'style2':
			$this->rt_wow_load_scripts();
			$template = 'image-2';
			break;
			default:
			$template = 'image-1';
			break;
		}
	
		return $this->rt_template( $template, $data );
	}
}