<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Typography;
use radiustheme\Finbuzz\Helper;

if ( ! defined( 'ABSPATH' ) ) exit;
class Pricing_Plan extends Custom_Widget_Base {
    public function __construct( $data = [], $args = null ){
        $this->rt_name = esc_html__( 'Pricing Plan', 'finbuzz-core' );
        $this->rt_base = 'rt-pricing-plan';
        parent::__construct( $data, $args );
    }
    public function rt_fields(){
        $repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
			'text', 
            array(
                'type'  => Controls_Manager::TEXT,
				'label' => esc_html__( 'Features Name', 'finbuzz-core' ),
				'label_block' => true,
            ),
		);
        $fields=array(
            array(
                'mode'    => 'section_start',
                'id'      => 'sec_general',
                'label'   => esc_html__( 'General', 'finbuzz-core' ),
            ),
            array(
                'type'        => Controls_Manager::TEXT,
                'id'          => 'package_name',
                'label'       => esc_html__( 'Package Name', 'finbuzz-core' ),
                'default'     => "Starter Plan",
            ),
            array(
                'type'        => Controls_Manager::TEXTAREA,
                'id'          => 'package_text',
                'label'       => esc_html__( 'Package Text', 'finbuzz-core' ),
                'default'     => "Financa dummy text of the printing and typesetting industry.",
            ),
            array(
                'type'        => Controls_Manager::TEXT,
                'id'          => 'currency_icon',
                'label'       => esc_html__( 'Currency Icon', 'finbuzz-core' ),
                'default'     => "$",
            ),
            array(
                'type'        => Controls_Manager::TEXT,
                'id'          => 'price',
                'label'       => esc_html__( 'Price', 'finbuzz-core' ),
                'description' => esc_html__( 'Prefix of currency.', 'finbuzz-core' ),
                'default'     => "39",
            ),
            array(
                'type'        => Controls_Manager::TEXT,
                'id'          => 'unit',
                'label'       => esc_html__( 'Price Unit', 'finbuzz-core' ),
                'description' => esc_html__( 'Prefix of currency.', 'finbuzz-core' ),
                'default'     => ".00",
            ),
            array(
                'type'        => Controls_Manager::TEXT,
                'id'          => 'duration',
                'label'       => esc_html__( 'Duration', 'finbuzz-core' ),
                'Description' => esc_html__( 'Use prefix if you want', 'finbuzz-core' ),
                'default'     => "Per Month",
            ),
            array(
                'type'        => Controls_Manager::TEXT,
                'id'          => 'button_text',
                'label'       => esc_html__( 'Button Text', 'finbuzz-core' ),
                'default'     => "Buy This Plan",
            ),
            array(
                'type'        => Controls_Manager::URL,
                'id'          => 'button_url',
                'label'       => esc_html__( 'Button URL', 'finbuzz-core' ),
                'default'     => ['url' => '#'],
            ),
            array (
				'type'    => Controls_Manager::REPEATER,
				'id'      => 'features',
				'label'   => esc_html__( 'Feature List', 'neeon-core' ),
				'fields' => $repeater->get_controls(),
				'default' => array(
					['text' => 'Finance Consulting',],
					['text' => 'Business Economiext printing', ],
					['text' => 'industr um has been', ],
					['text' => 'Investment typesetting', ],
				),
			),
            array(
                'mode' => 'section_end',
            ),
            array(
                'mode'    => 'section_start',
                'id'      => 'package_name_style',
                'label'   => esc_html__( 'Package Name Style', 'finbuzz-core' ),
                'tab'     => Controls_Manager::TAB_STYLE,
            ),
            array (
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'    => 'package_name_typo',
				'label'   => esc_html__( 'Package Name Typography', 'finbuzz-core' ),
				'selector' => '{{WRAPPER}} .pricing-plan .pricing-title',
			),
            array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'package_name_color',
				'label'   => esc_html__( 'Package Name Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .pricing-plan .pricing-title' => 'color: {{VALUE}}',
				)
			),
            array (
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'    => 'package_text_typo',
				'label'   => esc_html__( 'Package Text Typography', 'finbuzz-core' ),
				'selector' => '{{WRAPPER}} .pricing-plan p',
			),
            array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'package_text_color',
				'label'   => esc_html__( 'Package Text Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .pricing-plan p' => 'color: {{VALUE}}',
				)
			),
            array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'currency_color',
				'label'   => esc_html__( 'Currency Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .pricing-plan .price_and_currency .price-details .currency ' => 'color: {{VALUE}}',
				)
			),
            array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'package_price_color',
				'label'   => esc_html__( 'Package Price Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .pricing-plan .price_and_currency .price-details' => 'color: {{VALUE}}',
				)
			),
            array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'package_unit_color',
				'label'   => esc_html__( 'Package Unit Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .pricing-plan .price_and_currency .price-details .unit' => 'color: {{VALUE}}',
				)
			),
            array (
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'    => 'package_feature_typo',
				'label'   => esc_html__( 'Feature List Typography', 'finbuzz-core' ),
				'selector' => '{{WRAPPER}} .pricing-plan .pricing-features li .pricing-features-text',
			),
            array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'package_feature_color',
				'label'   => esc_html__( 'Feature List Text Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .pricing-plan .pricing-features li .pricing-features-text' => 'color: {{VALUE}}',
				)
			),
            array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'package_feature_circle_color',
				'label'   => esc_html__( 'Feature List Circle Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .pricing-plan .pricing-features li .pricing-features-text i' => 'color: {{VALUE}}',
				)
			),
            array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'package_feature_box_color',
				'label'   => esc_html__( 'Pricing Box Background', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .pricing-plan' => 'background-color: {{VALUE}}',
				)
			),
            array(
                'mode' => 'section_end',
            )

        );
        return $fields;
    }
    protected function render(){
        $data = $this->get_settings();
        $template = 'pricing-plan';
        return $this->rt_template( $template, $data );
    } 
}    
