<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit;

class Progress_Circle extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ){
		$this->rt_name = __( 'RT Progress Circle', 'finbuzz-core' );
		$this->rt_base = 'rt-progress-circle';
		parent::__construct( $data, $args );
	}

	private function rt_load_scripts(){
		wp_enqueue_script( 'easypiechart' );
		wp_enqueue_script( 'appear' );
	}

	public function rt_fields(){
		$fields = array(
			
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_general',
				'label'   => esc_html__( 'General', 'finbuzz-core' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'style',
				'label'   => esc_html__( 'Progress Layout Style', 'finbuzz-core' ),
				'options' => array(
					'style1' => esc_html__( 'Style 1' , 'finbuzz-core' ),
					'style2' => esc_html__( 'Style 2' , 'finbuzz-core' ),
				),
				'default' => 'style1',
			),
			array(
				'type' => Controls_Manager::CHOOSE,
				'id'      => 'content_align',
				'mode'    => 'responsive',
				'label'   => esc_html__( 'Alignment', 'finbuzz-core' ),
				'options' => array(
					'left' => array(
						'title' => __( 'Left', 'elementor' ),
						'icon' => 'eicon-text-align-left',
					),
					'center' => array(
						'title' => __( 'Center', 'elementor' ),
						'icon' => 'eicon-text-align-center',
					),
					'right' => array(
						'title' => __( 'Right', 'elementor' ),
						'icon' => 'eicon-text-align-right',
					),
				),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}}' => 'text-align: {{VALUE}};',
					'{{WRAPPER}} .progress-circle .style-2 '=> 'justify-content: {{VALUE}};',
				),
			),
			array(
				'type'    => Controls_Manager::ICONS,
				'id'      => 'icon_class',
				'label'   => esc_html__( 'Icon', 'finbuzz-core' ),
				'default' => array(
			      'value' => 'fas fa-users inner-icon',
			      'library' => 'fa-solid',
				),
				'condition'  =>array('style'=>array('style2'))	
			),	
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'number',
				'label'       => esc_html__( 'Circle Number', 'finbuzz-core' ),
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
				'default' => [
                    'size' => 80,
                ],
			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'circle_size',
				'label'       => esc_html__( 'Circle Size', 'finbuzz-core' ),
                'range' => [
                    'px' => [
                        'min' => 100,
                        'max' => 300,
                        'step' => 10,
                    ],
                ],
				'default' => [
                    'size' => 160,
                ],
			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'circle_border',
				'label'       => esc_html__( 'Circle thickness', 'finbuzz-core' ),
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 20,
                        'step' => 1,
                    ],
                ],
				'default' => [
                    'size' => 8,
                ],
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'title',
				'label'   => esc_html__( 'Title', 'finbuzz-core' ),
				'default' => esc_html__( 'Projects', 'finbuzz-core' ),
			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'speed',
				'label'       => esc_html__( 'Animation Speed', 'finbuzz-core' ),
                'range' => [
                    'px' => [
                        'min' => 100,
                        'max' => 5000,
                        'step' => 100,
                    ],
                ],
				'default' => [
                    'size' => 2000,
                ],
			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'duration',
				'label'       => esc_html__( 'Counter Number Animation Speed', 'finbuzz-core' ),
                'range' => [
                    'px' => [
                        'min' => 100,
                        'max' => 3000,
                        'step' => 100,
                    ],
                ],
				'default' => [
                    'size' => 1000,
                ],
			),
			array (
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'shape_display',
				'label'       => esc_html__( 'Right Display', 'finbuzz-core' ),
				'label_on'    => esc_html__( 'Show', 'finbuzz-core' ),
				'label_off'   => esc_html__( 'Hide', 'finbuzz-core' ),
				'default'     => '',
				'condition'  =>array('style'=>array('style2'))
			),
			array(
				'mode' => 'section_end',
			),

			/**Style Options */
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_style',
				'label'   => esc_html__( 'Style', 'finbuzz-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
			),
			array (
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'    => 'count_typo',
				'label'   => esc_html__( 'Count Number Typo', 'finbuzz-core' ),
				'selector' => '{{WRAPPER}} .progress-circle  .count-number',
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'count_color',
				'label'   => esc_html__( 'Count Number Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .progress-circle  .count-number' => 'color: {{VALUE}}',
				),
			),
			array (
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'    => 'title_typo',
				'label'   => esc_html__( 'Title Style', 'finbuzz-core' ),
				'selector' => '{{WRAPPER}} .progress-circle  .title',
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'title_color',
				'label'   => esc_html__( 'Title Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .progress-circle  .title' => 'color: {{VALUE}}',
				),
			),
			
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'bgcolor_color',
				'label'   => esc_html__( 'Circle BG Color', 'finbuzz-core' ),
				'default' => '#cccccc',
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'fgcolor_color',
				'label'   => esc_html__( 'Circle FG Color', 'finbuzz-core' ),
				'default' => '#fa360a',
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'fgcolor_dot_color',
				'label'   => esc_html__( 'Circle Rounded Dot Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .progress-circle .chart-bar.style-2:after' => 'background: {{VALUE}}',
				),
				'condition'  =>array('style'=>array('style2'))
			),
			array(
				'mode' => 'section_end',
			),
			array(
				'mode'    	=> 'section_start',
				'id'      	=> 'icon_sec_style',
				'label'   	=> esc_html__( 'Icon Style', 'finbuzz-core' ),
				'tab'     	=> Controls_Manager::TAB_STYLE,
				'condition' =>array('style'=>array('style2'))
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'icon_size',
				'label'   => esc_html__( 'Icon Size', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .progress-circle .style-2 .rtin-icon' => 'font-size: {{VALUE}}px',
					
				),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'icon_color',
				'label'   => esc_html__( 'Icon Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .progress-circle .style-2 .rtin-icon' => 'color: {{VALUE}}',
				),
			),
			array(
				'mode' => 'section_end',
			),
		);
		return $fields;
	}

	protected function render() {
		$data = $this->get_settings();
		$this->rt_load_scripts();
		switch ( $data['style'] ) {
			case 'style2':
			$template = 'progress-circle-2';
			break;
			default:
			$template = 'progress-circle';
			break;
		}
		return $this->rt_template( $template, $data );
	}
}