<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit;

class Shape_Animation extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ){
		$this->rt_name = esc_html__( 'RT Shape Animation', 'finbuzz-core' );
		$this->rt_base = 'rt-shape-animation';
		parent::__construct( $data, $args );
	}
	
	private function rt_load_scripts(){
		wp_enqueue_script( 'rt-wow' );
	}	
	
	public function rt_fields(){
		$fields = array(
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_general',
				'label'   => esc_html__( 'General', 'finbuzz-core' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'style',
				'label'   => esc_html__( 'Image Style', 'finbuzz-core' ),
				'options' => array(
					'style1' => esc_html__( 'Style 1' , 'finbuzz-core' ),
					'style2' => esc_html__( 'Style 2', 'finbuzz-core' ),
					'style3' => esc_html__( 'Style 3', 'finbuzz-core' ),
					'style4' => esc_html__( 'Style 4', 'finbuzz-core' ),
					'style5' => esc_html__( 'Style 5', 'finbuzz-core' ),
					'style6' => esc_html__( 'Style 6', 'finbuzz-core' ),
					'style7' => esc_html__( 'Style 7', 'finbuzz-core' ),
					'style8' => esc_html__( 'Style 8', 'finbuzz-core' ),
				),
				'default' => 'style1',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'left_animation',
				'label'   => esc_html__( 'Animation', 'finbuzz-core' ),
				'options' => array(
                    'none' => esc_html__( 'none', 'finbuzz-core' ),
					'bounce' => esc_html__( 'bounce', 'finbuzz-core' ),
					'flash' => esc_html__( 'flash', 'finbuzz-core' ),
					'pulse' => esc_html__( 'pulse', 'finbuzz-core' ),
					'rubberBand' => esc_html__( 'rubberBand', 'finbuzz-core' ),
					'shakeX' => esc_html__( 'shakeX', 'finbuzz-core' ),
					'shakeY' => esc_html__( 'shakeY', 'finbuzz-core' ),
					'headShake' => esc_html__( 'headShake', 'finbuzz-core' ),
					'swing' => esc_html__( 'swing', 'finbuzz-core' ),					
					'fadeIn' => esc_html__( 'fadeIn', 'finbuzz-core' ),
					'fadeInDown' => esc_html__( 'fadeInDown', 'finbuzz-core' ),
					'fadeInLeft' => esc_html__( 'fadeInLeft', 'finbuzz-core' ),
					'fadeInRight' => esc_html__( 'fadeInRight', 'finbuzz-core' ),
					'fadeInUp' => esc_html__( 'fadeInUp', 'finbuzz-core' ),					
					'bounceIn' => esc_html__( 'bounceIn', 'finbuzz-core' ),
					'bounceInDown' => esc_html__( 'bounceInDown', 'finbuzz-core' ),
					'bounceInLeft' => esc_html__( 'bounceInLeft', 'finbuzz-core' ),
					'bounceInRight' => esc_html__( 'bounceInRight', 'finbuzz-core' ),
					'bounceInUp' => esc_html__( 'bounceInUp', 'finbuzz-core' ),			
					'slideInDown' => esc_html__( 'slideInDown', 'finbuzz-core' ),
					'slideInLeft' => esc_html__( 'slideInLeft', 'finbuzz-core' ),
					'slideInRight' => esc_html__( 'slideInRight', 'finbuzz-core' ),
					'slideInUp' => esc_html__( 'slideInUp', 'finbuzz-core' ), 
                ),
				'default' => 'fadeInLeft',
			),
			
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'right_animation',
				'label'   => esc_html__( 'Animation', 'finbuzz-core' ),
				'options' => array(
                    'none' => esc_html__( 'none', 'finbuzz-core' ),
					'bounce' => esc_html__( 'bounce', 'finbuzz-core' ),
					'flash' => esc_html__( 'flash', 'finbuzz-core' ),
					'pulse' => esc_html__( 'pulse', 'finbuzz-core' ),
					'rubberBand' => esc_html__( 'rubberBand', 'finbuzz-core' ),
					'shakeX' => esc_html__( 'shakeX', 'finbuzz-core' ),
					'shakeY' => esc_html__( 'shakeY', 'finbuzz-core' ),
					'headShake' => esc_html__( 'headShake', 'finbuzz-core' ),
					'swing' => esc_html__( 'swing', 'finbuzz-core' ),					
					'fadeIn' => esc_html__( 'fadeIn', 'finbuzz-core' ),
					'fadeInDown' => esc_html__( 'fadeInDown', 'finbuzz-core' ),
					'fadeInLeft' => esc_html__( 'fadeInLeft', 'finbuzz-core' ),
					'fadeInRight' => esc_html__( 'fadeInRight', 'finbuzz-core' ),
					'fadeInUp' => esc_html__( 'fadeInUp', 'finbuzz-core' ),					
					'bounceIn' => esc_html__( 'bounceIn', 'finbuzz-core' ),
					'bounceInDown' => esc_html__( 'bounceInDown', 'finbuzz-core' ),
					'bounceInLeft' => esc_html__( 'bounceInLeft', 'finbuzz-core' ),
					'bounceInRight' => esc_html__( 'bounceInRight', 'finbuzz-core' ),
					'bounceInUp' => esc_html__( 'bounceInUp', 'finbuzz-core' ),			
					'slideInDown' => esc_html__( 'slideInDown', 'finbuzz-core' ),
					'slideInLeft' => esc_html__( 'slideInLeft', 'finbuzz-core' ),
					'slideInRight' => esc_html__( 'slideInRight', 'finbuzz-core' ),
					'slideInUp' => esc_html__( 'slideInUp', 'finbuzz-core' ), 
                ),
				'default' => 'fadeInRight',
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'delay',
				'label'   => esc_html__( 'Delay', 'finbuzz-core' ),
				'default' => '0.50s',
				'description' => esc_html__( 'Use delay 0.50s default', 'finbuzz-core' ),
			),
			
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'duration',
				'label'   => esc_html__( 'duration', 'finbuzz-core' ),
				'default' => '2s',
				'description' => esc_html__( 'Use delay 2s default', 'finbuzz-core' ),
			),
			
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'left_position',
				'mode'    => 'responsive',
				'label'   => esc_html__( 'Left Shape Position', 'finbuzz-core' ),
				'selectors' => array(
				  '{{WRAPPER}} .rt-animate-image .left-holder' => 'top: {{VALUE}}px',
				  
				  
				),
				'default' => '0',
				'description' => esc_html__( 'Use unit px', 'finbuzz-core' ),
			),
			
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'right_position',
				'mode'    => 'responsive',
				'label'   => esc_html__( 'Right Shape Position', 'finbuzz-core' ),
				'selectors' => array(
				  '{{WRAPPER}} .rt-animate-image .right-holder' => 'top: {{VALUE}}px',
				),
				'default' => '0',
				'description' => esc_html__( 'Use unit px', 'finbuzz-core' ),
				'condition'   =>array('style'=>array('style1','style2','style3','style4','style5','style8'))
			),
			
			array(
				'mode' => 'section_end',
			),
		);
		return $fields;
	}

	protected function render() {
		$data = $this->get_settings();

		switch ( $data['style'] ) {
			case 'style8':
			$template = 'shape-animation-8';
			break;
			case 'style7':
			$template = 'shape-animation-7';
			break;
			case 'style6':
			$template = 'shape-animation-6';
			break;
			case 'style5':
			$template = 'shape-animation-5';
			break;
			case 'style4':
			$template = 'shape-animation-4';
			break;
			case 'style3':
			$template = 'shape-animation-3';
			break;
			case 'style2':
			$template = 'shape-animation-2';
			break;
			default:
			$template = 'shape-animation-1';
			break;
		}
		
		$this->rt_load_scripts();
	
		return $this->rt_template( $template, $data );
	}
}