<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Image_Size;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit;

class Title extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ){
		$this->rt_name = esc_html__( 'RT Section Title', 'finbuzz-core' );
		$this->rt_base = 'rt-title';
		parent::__construct( $data, $args );
	}

	public function rt_fields(){
		$fields = array(
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_general',
				'label'   => esc_html__( 'Section Title', 'finbuzz-core' ),
			),
			/*box title*/
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'style',
				'label'   => esc_html__( 'Title Style', 'finbuzz-core' ),
				'options' => array(
					'style1' => esc_html__( 'Title Style 1' , 'finbuzz-core' ),
					'style2' => esc_html__( 'Title Style 2', 'finbuzz-core' ),
				),
				'default' => 'style1',
			),
			array(
				'type' => Controls_Manager::CHOOSE,
				'id'      => 'content_align',
				'mode'    => 'responsive',
				'label'   => esc_html__( 'Alignment', 'finbuzz-core' ),
				'options' => array(
					'left' => array(
						'title' => __( 'Left', 'elementor' ),
						'icon' => 'eicon-text-align-left',
					),
					'center' => array(
						'title' => __( 'Center', 'elementor' ),
						'icon' => 'eicon-text-align-center',
					),
					'right' => array(
						'title' => __( 'Right', 'elementor' ),
						'icon' => 'eicon-text-align-right',
					),
					'justify' => array(
						'title' => __( 'Justified', 'elementor' ),
						'icon' => 'eicon-text-align-justify',
					),
				),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}}' => 'text-align: {{VALUE}};',
				),
				'condition'   => array( 'style' => array( 'style1', 'style2' ) ),
			),
			
			/*Icon Start*/
			array(					 
			   'type'    => Controls_Manager::CHOOSE,
			   'options' => array(
			     'icon' => array(
			       'title' => esc_html__( 'Left', 'finbuzz-core' ),
			       'icon' => 'fa fa-smile-o',
			     ),
			     'image' => array(
			       'title' => esc_html__( 'Center', 'finbuzz-core' ),
			       'icon' => 'fa fa-image',
			     ),		     
			   ),
			   'id'      => 'icontype',
			   'label'   => esc_html__( 'Media Type', 'finbuzz-core' ),
			   'default' => 'icon',
			   'label_block' => false,
			   'toggle' => false,
			),
			array(
				'type'    => Controls_Manager::ICONS,
				'id'      => 'icon_class',
				'label'   => esc_html__( 'Icon', 'finbuzz-core' ),
				'default' => array(
			      'value' => 'fas fa-smile-wink',
			      'library' => 'fa-solid',
			  ),	
			  	'condition'   => array('icontype' => array( 'icon' ) ),
			),	
			array(
				'type'    => Controls_Manager::MEDIA,
				'id'      => 'icon_image',
				'label'   => esc_html__( 'Image', 'finbuzz-core' ),
				'default' => array(
                    'url' => Utils::get_placeholder_image_src(),
                ),
				'condition'   => array('icontype' => array( 'image' ) ),
				'description' => esc_html__( 'Recommended full image', 'finbuzz-core' ),
			),
			array(
				'type'    => Group_Control_Image_Size::get_type(),
				'mode'    => 'group',				
				'label'   => esc_html__( 'image size', 'finbuzz-core' ),	
				'name' => 'icon_image_size', 
				'separator' => 'none',		
				'condition'   => array('icontype' => array( 'image' ) ),
			),
			/*Icon end*/
			array(
				'type'    => Controls_Manager::TEXTAREA,
				'id'      => 'title',
				'label'   => esc_html__( 'Title', 'finbuzz-core' ),
				'default' => 'Wellcome To Finbuzz',
			),
			array(
				'type'    => Controls_Manager::TEXTAREA,
				'id'      => 'sub_title',
				'label'   => esc_html__( 'Sub Title', 'finbuzz-core' ),
				'default' => esc_html__( 'SUB TITLE', 'finbuzz-core' ),
				'condition'   => array( 'style' => array('style2') ),
			),			
			array(
				'type'    => Controls_Manager::WYSIWYG,
				'id'      => 'content',
				'label'   => esc_html__( 'Content', 'finbuzz-core' ),
				'default' => esc_html__( 'Our agency can only be as strong as our people our team agenhave run their businesses designed.', 'finbuzz-core' ),
				'condition'   => array( 'style' => array( 'style1','style2' ) ),
			),
			array(
				'mode' => 'section_end',
			),


			/***Style Option * */
			
			/*Title Style Option*/
			
			array (
				'mode'    => 'section_start',
				'id'      => 'section_title_style',
				'label'   => esc_html__( 'Title Style', 'finbuzz-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
				
			),
			array (
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'    => 'section_title_typo',
				'label'   => esc_html__( 'Title Typo', 'finbuzz-core' ),
				'selector' => '{{WRAPPER}} .sec-title .rtin-title',
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'section_title_color',
				'label'   => esc_html__( 'Title Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .sec-title .rtin-title' => 'color: {{VALUE}}',
				),
			),
			array(
				'mode' => 'section_end',
			),


			/**Subtitle Style */
			array(
				'mode'    => 'section_start',
				'id'      => 'section_subtitle',
				'label'   => esc_html__( 'Subtitle Text', 'finbuzz-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
				'condition'   => array( 'style' => array('style2' ) ),
				
			),
			array (
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'    => 'sub_title_typo',
				'label'   => esc_html__( 'Sub Title Style', 'finbuzz-core' ),
				'selector' => '{{WRAPPER}} .sec-title .sub-title',
				'condition'   => array( 'style' => array('style2' ) ),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'section_subtitle_color',
				'label'   => esc_html__( 'Sub Title Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .sec-title .sub-title' => 'color: {{VALUE}}',
				),
			),
			array(
				'mode' => 'section_end',
			),

			/**Content Style  */

			array(
				'mode'    => 'section_start',
				'id'      => 'section_content',
				'label'   => esc_html__( 'Content Text', 'finbuzz-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
				
				
			),
			array (
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'    => 'content',
				'label'   => esc_html__( 'Content Title Style', 'finbuzz-core' ),
				'selector' => '{{WRAPPER}} .rtin-text',
				
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'content_color',
				'label'   => esc_html__( 'Content Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .content' => 'color: {{VALUE}}',
				),
				
			),
			array(
				'mode' => 'section_end',
			),


			/**Icon Style */

			array(
				'mode'    => 'section_start',
				'id'      => 'section_icon',
				'label'   => esc_html__( 'Icon Style', 'finbuzz-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'icon_color',
				'label'   => esc_html__( 'Icon Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .sec-title .rtin-icon i' => 'color: {{VALUE}}',
				),
			),
			array(
				'mode' => 'section_end',
			),


		);
		return $fields;
	}

	protected function render() {
		$data = $this->get_settings();

		switch ( $data['style'] ) {
			
			case 'style2':
			$template = 'title-2';
			break;
			default:
			$template = 'title-1';
			break;
		}

		return $this->rt_template( $template, $data );
	}
}