<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Utils;
use Elementor\Group_Control_Background;

if ( ! defined( 'ABSPATH' ) ) exit;

class Video extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ){
		$this->rt_name = esc_html__( 'RT Video', 'finbuzz-core' );
		$this->rt_base = 'rt-video';
		parent::__construct( $data, $args );
	}
	
	private function rt_load_scripts(){
		wp_enqueue_script( 'magnific-popup' );
	}
	private function rt_load_scripts2(){
		wp_enqueue_style(  'swiper-slider' );
		wp_enqueue_script('swiper-slider');
	}
	public function rt_fields(){
		$repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
			'image', [
				'type'  => Controls_Manager::MEDIA,
				'label' => esc_html__( 'Image', 'finbuzz-core' ),
				'label_block' => true,
				'description' => esc_html__( 'Recommended above 710 px height  image', 'finbuzz-core' ),
			]
		);
		$repeater->add_control(
			'video_slider_url', [
				'type'  => Controls_Manager::URL,
				'label' => esc_html__( 'Video URL', 'finbuzz-core' ),
				'label_block' => true,
			]
		);
		$fields = array(
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_general',
				'label'   => esc_html__( 'General', 'finbuzz-core' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'style',
				'label'   => esc_html__( 'Style', 'finbuzz-core' ),
				'options' => array(
					'style1' => esc_html__( 'Style 1', 'finbuzz-core' ),
					'style2' => esc_html__( 'Style 2', 'finbuzz-core' ),
					'style3' => esc_html__( 'Style 3', 'finbuzz-core' ),
					'style4' => esc_html__( 'Style 4', 'finbuzz-core' ),
					'style5' => esc_html__( 'Style 5 (Slider)', 'finbuzz-core' ),
					'style6' => esc_html__( 'Style 6', 'finbuzz-core' ),
					'style7' => esc_html__( 'Style 7', 'finbuzz-core' ),
					'style8' => esc_html__( 'Style 8', 'finbuzz-core' ),
					'style9' => esc_html__( 'Style 9', 'finbuzz-core' ),
				),
				'default' => 'style1',
			),
			array(
				'type' => Controls_Manager::CHOOSE,
				'id'      => 'content_align',
				'mode'    => 'responsive',
				'label'   => esc_html__( 'Alignment', 'finbuzz-core' ),
				'options' => array(
					'left' => array(
						'title' => __( 'Left', 'finbuzz-core' ),
						'icon' => 'eicon-text-align-left',
					),
					'center' => array(
						'title' => __( 'Center', 'finbuzz-core' ),
						'icon' => 'eicon-text-align-center',
					),
					'right' => array(
						'title' => __( 'Right', 'finbuzz-core' ),
						'icon' => 'eicon-text-align-right',
					),
					'justify' => array(
						'title' => __( 'Justified', 'finbuzz-core' ),
						'icon' => 'eicon-text-align-justify',
					),
				),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .rt-video .rtin-video' => 'text-align: {{VALUE}};',
				),
				'condition'   => array( 'style' => array('style3')),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'bag_color',
				'label'   => esc_html__( 'Image Overlay Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .rt-video.video-style1 .rtin-video .item-img:after' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .rt-video.video-style7 .rtin-video .item-img:after' => 'background-color: {{VALUE}}',
				),
				'condition'   	=> array( 'style' => array( 'style1','style7') ),
			),
			array(
				'type'    => Controls_Manager::SLIDER,
				'id'      => 'image_overlay_size',
				'label'   => esc_html__( 'Percentage', 'finbuzz-core' ),
				'default' => [
					'size' => .6,
				],
				'range' => [
					'px' => [
						'max' => 1,
						'min' => 0.10,
						'step' => 0.01,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rt-video.video-style1 .rtin-video .item-img:after' => 'opacity: {{SIZE}};',
					'{{WRAPPER}} .rt-video.video-style7 .rtin-video .item-img:after' => 'opacity: {{SIZE}};',
				],
				'condition'   	=> array( 'style' => array( 'style1','style7') ),
			),
			array(
				'type'    		=> Controls_Manager::TEXTAREA,
				'id'      		=> 'title',
				'label'   		=> esc_html__( 'Title', 'finbuzz-core' ),
				'default' 		=> esc_html__( 'We Provide High-Quality  Finance& Business Solutions', 'finbuzz-core' ),
				'condition'   	=> array( 'style' => array( 'style1', 'style4') ),
			),
			array(
				'type'    => Controls_Manager::URL,
				'id'      => 'title_url',
				'label'   => esc_html__( 'Title URL (Optional)', 'finbuzz-core' ),
				'placeholder' => 'https://title-link.com',
				'condition'   	=> array( 'style' => array( 'style1','style4') ),
			),
			array(
				'type'    		=> Controls_Manager::TEXT,
				'id'      		=> 'video_title',
				'label_block'	=>true,
				'label'   		=> esc_html__( 'Video Title', 'finbuzz-core' ),
				'default' 		=> esc_html__( 'Watch The Video.', 'finbuzz-core' ),
				'condition'   	=> array( 'style' => array( 'style1','style3','style4','style6','style7', 'style8', 'style9') ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'video_btn_style',
				'label'   => esc_html__( 'Video Icon Style', 'finbuzz-core' ),
				'options' => array(
					'icon-style1' => esc_html__( 'Style 1', 'finbuzz-core' ),
					'icon-style2' => esc_html__( 'Style 2', 'finbuzz-core' ),
					'icon-style3' => esc_html__( 'Style 3', 'finbuzz-core' ),
				),
				'default' => 'icon-style1',
				'condition'   	=> array( 'style' => array( 'style3') ),
			),
			array(
				'type'    		=> Controls_Manager::TEXT,
				'id'      		=> 'support_text',
				'label_block'	=>true,
				'label'   		=> esc_html__( 'Support Text', 'finbuzz-core' ),
				'default' 		=> esc_html__( '12/7 Support Team', 'finbuzz-core' ),
				'condition'   	=> array( 'style' => array( 'style2' ) ),
			),
			array(
				'type'    		=> Controls_Manager::TEXT,
				'id'      		=> 'phone',
				'label_block'	=>true,
				'label'   		=> esc_html__( 'Phone', 'finbuzz-core' ),
				'default' 		=> esc_html__( '+123-55-05800', 'finbuzz-core' ),
				'condition'   	=> array( 'style' => array( 'style2' ) ),
			),
			array(
				'type'    => Controls_Manager::URL,
				'id'      => 'videourl',
				'label'   => esc_html__( 'Video URL', 'finbuzz-core' ),
				'placeholder' => 'https://your-link.com',
				'condition'   => array( 'style' => array('style1','style2','style3','style4','style6','style7', 'style8', 'style9')),
			),
			array(
				'type'    => Controls_Manager::MEDIA,
				'id'      => 'video_image',
				'label'   => esc_html__( 'Image', 'finbuzz-core' ),
				'default' => array(
                    'url' => Utils::get_placeholder_image_src(),
                ),
				'description' => esc_html__( 'Recommended full image', 'finbuzz-core' ),
				'condition'   	=> array( 'style' => array( 'style1','style2','style4','style7') ),
			),
			array(
				'type'    => Group_Control_Image_Size::get_type(),
				'mode'    => 'group',				
				'label'   => esc_html__( 'image size', 'finbuzz-core' ),	
				'name' => 'icon_image_size', 
				'separator' => 'none',	
				'condition'   	=> array( 'style' => array( 'style1','style2','style4','style7') ),	
			),
			array(
				'type'    => Controls_Manager::DIMENSIONS,
				'id'      => 'video_padding',
				'mode'    => 'responsive',
				'label'   => esc_html__( 'Padding', 'finbuzz-core' ),
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .rt-video .rtin-video .item-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .rt-video.video-style2 .rtin-video .video-info' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				],
				'condition'   	=> array( 'style' => array( 'style1','style2') ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'shape_display',
				'label'       => esc_html__( 'Shape Display', 'finbuzz-core' ),
				'label_on'    => esc_html__( 'On', 'finbuzz-core' ),
				'label_off'   => esc_html__( 'Off', 'finbuzz-core' ),
				'default'     => 'off',
				'description' => esc_html__( 'Show or Hide More Button . Default: Off', 'finbuzz-core' ),
				'condition'   	=> array( 'style' => array( 'style1','style2') ),
			),
			array (
				'type'    => Controls_Manager::REPEATER,
				'id'      => 'videos',
				'label'   => esc_html__( 'Add as many videos as you want', 'consalty-core' ),
				'fields' => $repeater->get_controls(),
				'condition'   	=> array( 'style' => array( 'style5' ) ),				
			),
			array(
				'mode' => 'section_end',
			),
			// Slider options
			array(
				'mode'        => 'section_start',
				'id'          => 'sec_slider',
				'label'       => esc_html__( 'Slider Options', 'finbuzz-core' ),
				'condition'   => array( 'style' => array('style5') ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'slider_autoplay',
				'label'       => esc_html__( 'Autoplay', 'finbuzz-core' ),
				'default'     => 'off',
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'slider_loop',
				'label'       => esc_html__( 'Loop', 'finbuzz-core' ),
				'default'     => 'off',
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'centered_slide',
				'label'       => esc_html__( 'Center Slide', 'finbuzz-core' ),
				'default'     => 'false',
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'navigation',
				'label'       => esc_html__( 'Navigation', 'finbuzz-core' ),
				'default'     => 'yes',
			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'slider_per_group',
				'label'       => esc_html__( 'Slides Per Group', 'finbuzz-core' ),
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 6,
                    ],
                ],
                'size_units' => [ 'px'],
                'default' => [
                    'size' => 1,
                ],
			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'autoplayspeed',
				'label'       => esc_html__( 'Autoplay speed', 'finbuzz-core' ),
				'condition'   => array( 'slider_autoplay' => 'yes' ),
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 10000,
                        'step' => 500,
                    ],
                ],
                'size_units' => [ 'px'],
                'default' => [
                    'size' => 2000,
                ],
			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'speed',
				'label'       => esc_html__( 'Slider Speed', 'finbuzz-core' ),
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 10000,
                        'step' => 500,
                    ],
                ],
                'size_units' => [ 'px'],
                'default' => [
                    'size' => 2000,
                ],
			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'space',
				'label'       => esc_html__( 'Inter slider spacing', 'finbuzz-core' ),
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'size_units' => [ 'px'],
                'default' => [
                    'size' => 30,
                ],
			),

			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'item',
				'label'       => esc_html__( 'Desktop items', 'finbuzz-core' ),
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 6,
                        'step' => 1,
                    ],
                ],
                'size_units' => [ 'px'],
                'default' => [
                    'size' => 2,
                ],
			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'medium_item',
				'label'       => esc_html__( 'Medium Desktop items', 'finbuzz-core' ),
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 6,
                        'step' => 1,
                    ],
                ],
                'size_units' => [ 'px'],
                'default' => [
                    'size' => 2,
                ],
			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'item_tablet',
				'label'       => esc_html__( 'Tablet items', 'finbuzz-core' ),
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 10,
                        'step' => 1,
                    ],
                ],
                'size_units' => [ 'px'],
                'default' => [
                    'size' => 2,
                ],
				
			),

			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'item_mobile',
				'label'       => esc_html__( 'Mobile items', 'finbuzz-core' ),
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 10,
                        'step' => 1,
                    ],
                ],
                'size_units' => [ 'px'],
                'default' => [
                    'size' => 1,
                ],
				
			),
			array(
				'mode' => 'section_end',
			),
			/*Style Option*/
			array(
				'mode'    => 'section_start',
				'id'      => 'title_style',
				'label'   => esc_html__( 'Title', 'finbuzz-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
				'condition'   	=> array( 'style' => array( 'style1','style3','style4','style6','style7', 'style8', 'style9') ),
			),
			array (
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'    => 'title_typo',
				'label'   => esc_html__( 'Title Typo', 'finbuzz-core' ),
				'selector' => '{{WRAPPER}} .rt-video-style9 .play-text, {{WRAPPER}} .rt-video-style8 .play-text, {{WRAPPER}} .rt-video .rtin-video .item-content .title h2',
				'condition'   	=> array( 'style' => array( 'style1','style4')),
			),
			
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'title_color',
				'label'   => esc_html__( 'Title Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .rt-video .rtin-video .item-content .title h2' => 'color: {{VALUE}}',
					'{{WRAPPER}} .rt-video .rtin-video .item-content .title h2 a' => 'color: {{VALUE}}',
					'{{WRAPPER}} .rt-video.video-style3 .rtin-play .play-text ' => 'color: {{VALUE}}',
					'{{WRAPPER}} .rt-video.video-style6  .play-text ' => 'color: {{VALUE}}',
					'{{WRAPPER}} .video-style4 .rtin-video .video-content .title h2 ' => 'color: {{VALUE}}',
					'{{WRAPPER}} .rt-video-style8 .play-text' => 'color: {{VALUE}}',
					'{{WRAPPER}} .rt-video-style9 .play-text' => 'color: {{VALUE}}',
				),
			),
			array (
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'    => 'video_typo',
				'label'   => esc_html__( 'Video Typo', 'finbuzz-core' ),
				'selector' => '{{WRAPPER}} .rt-video.video-style3 .rtin-play .play-text',
				'condition'   	=> array( 'style' => 'style3','style7', 'style8'),
			),
			array(
				'mode' => 'section_end',
			),
			// Button Icon Style 8 
			array(
				'mode'    => 'section_start',
				'id'      => 'icon_style8',
				'label'   => esc_html__( 'Icon Style', 'finbuzz-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
				'condition'   	=> array( 'style' => array( 'style8', 'style9') ),
			),

			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'icon_color8',
				'label'   => esc_html__( 'Icon Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .rt-video-style9 .play-icon svg' => 'color: {{VALUE}}',
					'{{WRAPPER}} .rt-video-style8 path' => 'fill: {{VALUE}}',
				),
			),

			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'icon_hover_color8',
				'label'   => esc_html__( 'Icon Hover Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .rt-video-style8:hover path' => 'fill: {{VALUE}}',
					'{{WRAPPER}} .rt-video-style9:hover .play-icon svg' => 'color: {{VALUE}}',
				),
			),

			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'icon_border_color8',
				'label'   => esc_html__( 'Icon Border Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .rt-video-style9 .play-icon::before' => 'border-color: {{VALUE}}',
					'{{WRAPPER}} .rt-video-style9 .play-icon::after' => 'border-color: {{VALUE}}',
					'{{WRAPPER}} .rt-video-style8 .play-icon' => 'border-color: {{VALUE}}',
				),
			),

			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'hover_icon_border_color8',
				'label'   => esc_html__( 'Icon Hover Border Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .rt-video-style8:hover .play-icon' => 'border-color: {{VALUE}}',
					'{{WRAPPER}} .rt-video-style9:hover .play-icon' => 'border-color: {{VALUE}}',
				),
			),

			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'hover_icon_bg_color9',
				'label'   => esc_html__( 'Icon Background Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .rt-video-style9 .play-icon' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .rt-video-style8 .play-icon' => 'background-color: {{VALUE}}',
				),
			),

			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'hover_icon_bg_color8',
				'label'   => esc_html__( 'Icon Hover Background Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .rt-video-style9:hover .play-icon' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .rt-video-style8:hover .play-icon' => 'background-color: {{VALUE}}',
				),
			),

			array(
				'mode' => 'section_end',
			),


			// Button style 1
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_button_style',
				'label'   => esc_html__( 'Button Style', 'panpie-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
				'condition'   	=> array( 'style' => array( 'style1') ),
			),
			array (
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'    => 'button_typo',
				'label'   => esc_html__( 'Button Typo', 'panpie-core' ),
				'selector' => '{{WRAPPER}} .rt-video .play-btn',
			),
			// Tab For Normal view.
			array(
				'mode' => 'tabs_start',
				'id'   => 'meta_tabs_start',
			),			
			array(
				'mode'  => 'tab_start',
				'id'    => 'rt_tab_1',
				'label' => esc_html__( 'Normal', 'neeon-core' ),
			),
			
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'button_text_color',
				'label'   => esc_html__( 'Button Text Color', 'panpie-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .rt-video .play-btn' => 'color: {{VALUE}}',
				),
			),
			array(
				'name'      => 'btn2_bg_color',
				'mode'     => 'group',
				'type'     => Group_Control_Background::get_type(),
				'label'    => __( 'Background Hover', 'bizcon-core' ),
				'selector' => '{{WRAPPER}} .rt-video .play-btn',
			),
			array(
				'mode' => 'tab_end',
			),
			array(
				'mode'  => 'tab_start',
				'id'    => 'rt_tab_2',
				'label' => esc_html__( 'Hover', 'neeon-core' ),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'button_text_hover_color',
				'label'   => esc_html__( 'Button Text Color', 'panpie-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .rt-video .play-btn' => 'color: {{VALUE}}',
				),
			),
			array(
				'mode' => 'tab_end',
			),
			array(
				'mode' => 'tabs_end',
			),	
			array(
				'mode' => 'section_end',
			),
			// Icon style
			array(
				'mode'    => 'section_start',
				'id'      => 'video_icon',
				'label'   => esc_html__( 'Video Icon Style', 'finbuzz-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
				'condition'   	=> array( 'style' => array( 'style2','style3','style6','style7') ),
			),			
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'video_icon_size',
				'label'   => esc_html__( 'Icon Size', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}}  .video-style2 .rtin-video .rtin-play .play-icon' => 'font-size: {{VALUE}}px',
					'{{WRAPPER}}  .video-style3 .rtin-video .rtin-play .play-icon' => 'font-size: {{VALUE}}px',
					'{{WRAPPER}}  .rt-video.video-style3.icon-style2 .rtin-play .play-icon i' => 'font-size: {{VALUE}}px',
					'{{WRAPPER}}  .video-style6 .rtin-play i' => 'font-size: {{VALUE}}px',
				),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'video_icon_color',
				'label'   => esc_html__( 'Icon Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}}  .video-style2 .rtin-video  .rtin-play .play-icon' => 'color: {{VALUE}}',
					'{{WRAPPER}}  .video-style3 .rtin-video  .rtin-play .play-icon' => 'color: {{VALUE}}',
					'{{WRAPPER}}  .video-style6 .rtin-play i' => 'color: {{VALUE}}',
				),
			),
			
			array(
				'mode' => 'section_end',
			),
		);
		return $fields;
	}

	protected function render() {
		$data = $this->get_settings();
		$this->rt_load_scripts();
		switch ( $data['style'] ) {
			case 'style9':
			$template = 'video-9';
			break;
			case 'style8':
			$template = 'video-8';
			break;
			case 'style7':
			$template = 'video-7';
			break;
			case 'style6':
			$template = 'video-6';
			break;
			case 'style5':
			$this->rt_load_scripts2();
			$template = 'video-5';
			break;
			case 'style4':
			$template = 'video-4';
			break;
			case 'style3':
			$template = 'video-3';
			break;
			case 'style2':
			$template = 'video-2';
			break;
			default:
			$template = 'video';
			break;
		}
		return $this->rt_template( $template, $data );
	}
}