<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;

use FinbuzzTheme;
use FinbuzzTheme_Helper;
use \RT_Postmeta;

if ( ! defined( 'ABSPATH' ) ) exit;

if ( !class_exists( 'RT_Postmeta' ) ) {
	return;
}

$Postmeta = RT_Postmeta::getInstance();

$prefix = FINBUZZ_CORE_CPT_PREFIX;

/*-------------------------------------
#. Layout Settings
---------------------------------------*/
$nav_menus = wp_get_nav_menus( array( 'fields' => 'id=>name' ) );
$nav_menus = array( 'default' => __( 'Default', 'finbuzz-core' ) ) + $nav_menus;
$sidebars  = array( 'default' => __( 'Default', 'finbuzz-core' ) ) + FinbuzzTheme_Helper::custom_sidebar_fields();

$Postmeta->add_meta_box( "{$prefix}_page_settings", __( 'Layout Settings', 'finbuzz-core' ), array( 'page', 'post', 'finbuzz_team', 'finbuzz_service', 'finbuzz_portfolio', 'finbuzz_testim' ), '', '', 'high', array(
	'fields' => array(
	
		"{$prefix}_layout_settings" => array(
			'label'   => __( 'Layouts', 'finbuzz-core' ),
			'type'    => 'group',
			'value'  => array(	
			
				"{$prefix}_layout" => array(
					'label'   => __( 'Layout', 'finbuzz-core' ),
					'type'    => 'select',
					'options' => array(
						'default'       => __( 'Default', 'finbuzz-core' ),
						'full-width'    => __( 'Full Width', 'finbuzz-core' ),
						'left-sidebar'  => __( 'Left Sidebar', 'finbuzz-core' ),
						'right-sidebar' => __( 'Right Sidebar', 'finbuzz-core' ),
					),
					'default'  => 'default',
				),		
				'finbuzz_sidebar' => array(
					'label'    => __( 'Custom Sidebar', 'finbuzz-core' ),
					'type'     => 'select',
					'options'  => $sidebars,
					'default'  => 'default',
				),
				"{$prefix}_page_menu" => array(
					'label'    => __( 'Main Menu', 'finbuzz-core' ),
					'type'     => 'select',
					'options'  => $nav_menus,
					'default'  => 'default',
				),
				"{$prefix}_tr_header" => array(
					'label'    	  => __( 'Transparent Header', 'finbuzz-core' ),
					'type'     	  => 'select',
					'options'  	  => array(
						'default' => __( 'Default', 'finbuzz-core' ),
						'on'      => __( 'Enabled', 'finbuzz-core' ),
						'off'     => __( 'Disabled', 'finbuzz-core' ),
					),
					'default'  => 'default',
				),
				"{$prefix}_top_bar" => array(
					'label' 	  => __( 'Top Bar', 'finbuzz-core' ),
					'type'  	  => 'select',
					'options' => array(
						'default' => __( 'Default', 'finbuzz-core' ),
						'on'      => __( 'Enabled', 'finbuzz-core' ),
						'off'     => __( 'Disabled', 'finbuzz-core' ),
					),
					'default'  	  => 'default',
				),
				"{$prefix}_top_bar_style" => array(
					'label' 	=> __( 'Top Bar Layout', 'finbuzz-core' ),
					'type'  	=> 'select',
					'options'	=> array(
						'default' => __( 'Default', 'finbuzz-core' ),
						'1'       => __( 'Layout 1', 'finbuzz-core' ),
						'2'       => __( 'Layout 2', 'finbuzz-core' ),
						'3'       => __( 'Layout 3', 'finbuzz-core' ),
						'4'       => __( 'Layout 4', 'finbuzz-core' ),
						'5'       => __( 'Layout 5', 'finbuzz-core' ),
						'6'       => __( 'Layout 6', 'finbuzz-core' ),
						'7'       => __( 'Layout 7', 'finbuzz-core' ),
					),
					'default'   => 'default',
				),
				"{$prefix}_header_opt" => array(
					'label' 	  => __( 'Header On/Off', 'finbuzz-core' ),
					'type'  	  => 'select',
					'options' => array(
						'default' => __( 'Default', 'finbuzz-core' ),
						'on'      => __( 'Enabled', 'finbuzz-core' ),
						'off'     => __( 'Disabled', 'finbuzz-core' ),
					),
					'default'  	  => 'default',
				),
				"{$prefix}_header" => array(
					'label'   => __( 'Header Layout', 'finbuzz-core' ),
					'type'    => 'select',
					'options' => array(
						'default' => __( 'Default', 'finbuzz-core' ),
						'1'       => __( 'Layout 1', 'finbuzz-core' ),
						'2'       => __( 'Layout 2', 'finbuzz-core' ),
						'3'       => __( 'Layout 3', 'finbuzz-core' ),
						'4'       => __( 'Layout 4', 'finbuzz-core' ),
						'5'       => __( 'Layout 5', 'finbuzz-core' ),
						'6'       => __( 'Layout 6', 'finbuzz-core' ),
						'7'       => __( 'Layout 7', 'finbuzz-core' ),
						'8'       => __( 'Layout 8', 'finbuzz-core' ),
						'9'       => __( 'Layout 9', 'finbuzz-core' ),
						'10'      => __( 'Layout 10', 'finbuzz-core' ),
						'11'      => __( 'Layout 11', 'finbuzz-core' ),
						'12'      => __( 'Layout 12', 'finbuzz-core' ),
					),
					'default'  => 'default',
				),
				"{$prefix}_footer" => array(
					'label'   => __( 'Footer Layout', 'finbuzz-core' ),
					'type'    => 'select',
					'options' => array(
						'default' => __( 'Default', 'finbuzz-core' ),
						'1'       => __( 'Layout 1', 'finbuzz-core' ),
						'2'       => __( 'Layout 2', 'finbuzz-core' ),
						'3'       => __( 'Layout 3', 'finbuzz-core' ),
						'4'       => __( 'Layout 4', 'finbuzz-core' ),
						'5'       => __( 'Layout 5', 'finbuzz-core' ),
						'6'       => __( 'Layout 6', 'finbuzz-core' ),
						'7'       => __( 'Layout 7', 'finbuzz-core' ),
						'8'       => __( 'Layout 8', 'finbuzz-core' ),
					),
					'default'  => 'default',
				),
				"{$prefix}_footer_area" => array(
					'label' 	  => __( 'Footer Area', 'finbuzz-core' ),
					'type'  	  => 'select',
					'options' => array(
						'default' => __( 'Default', 'finbuzz-core' ),
						'on'      => __( 'Enabled', 'finbuzz-core' ),
						'off'     => __( 'Disabled', 'finbuzz-core' ),
					),
					'default'  	  => 'default',
				),
				"{$prefix}_footer_top_logo_area" => array(
					'label' 	  => __( 'Footer Top Logo Area', 'finbuzz-core' ),
					'type'  	  => 'select',
					'options' => array(
						'default' => __( 'Default', 'finbuzz-core' ),
						'on'      => __( 'Enabled', 'finbuzz-core' ),
						'off'     => __( 'Disabled', 'finbuzz-core' ),
					),
					'default'  	  => 'default',
				),
				"{$prefix}_footer_cta_area" => array(
					'label' 	  => __( 'Footer CTA Area', 'finbuzz-core' ),
					'type'  	  => 'select',
					'options' => array(
						'default' => __( 'Default', 'finbuzz-core' ),
						'on'      => __( 'Enabled', 'finbuzz-core' ),
						'off'     => __( 'Disabled', 'finbuzz-core' ),
					),
					'default'  	  => 'default',
				),
				"{$prefix}_copyright_area" => array(
					'label' 	  => __( 'Copyright Area', 'finbuzz-core' ),
					'type'  	  => 'select',
					'options' => array(
						'default' => __( 'Default', 'finbuzz-core' ),
						'on'      => __( 'Enabled', 'finbuzz-core' ),
						'off'     => __( 'Disabled', 'finbuzz-core' ),
					),
					'default'  	  => 'default',
				),
				"{$prefix}_top_padding" => array(
					'label'   => __( 'Content Padding Top', 'finbuzz-core' ),
					'type'    => 'select',
					'options' => array(
						'default' => __( 'Default', 'finbuzz-core' ),
						'0px'     => __( '0px', 'finbuzz-core' ),
						'10px'    => __( '10px', 'finbuzz-core' ),
						'20px'    => __( '20px', 'finbuzz-core' ),
						'30px'    => __( '30px', 'finbuzz-core' ),
						'40px'    => __( '40px', 'finbuzz-core' ),
						'50px'    => __( '50px', 'finbuzz-core' ),
						'60px'    => __( '60px', 'finbuzz-core' ),
						'70px'    => __( '70px', 'finbuzz-core' ),
						'80px'    => __( '80px', 'finbuzz-core' ),
						'90px'    => __( '90px', 'finbuzz-core' ),
						'100px'   => __( '100px', 'finbuzz-core' ),
						'110px'   => __( '110px', 'finbuzz-core' ),
						'120px'   => __( '120px', 'finbuzz-core' ),
					),
					'default'  => 'default',
				),
				"{$prefix}_bottom_padding" => array(
					'label'   => __( 'Content Padding Bottom', 'finbuzz-core' ),
					'type'    => 'select',
					'options' => array(
						'default' => __( 'Default', 'finbuzz-core' ),
						'0px'     => __( '0px', 'finbuzz-core' ),
						'10px'    => __( '10px', 'finbuzz-core' ),
						'20px'    => __( '20px', 'finbuzz-core' ),
						'30px'    => __( '30px', 'finbuzz-core' ),
						'40px'    => __( '40px', 'finbuzz-core' ),
						'50px'    => __( '50px', 'finbuzz-core' ),
						'60px'    => __( '60px', 'finbuzz-core' ),
						'70px'    => __( '70px', 'finbuzz-core' ),
						'80px'    => __( '80px', 'finbuzz-core' ),
						'90px'    => __( '90px', 'finbuzz-core' ),
						'100px'   => __( '100px', 'finbuzz-core' ),
						'110px'   => __( '110px', 'finbuzz-core' ),
						'120px'   => __( '120px', 'finbuzz-core' ),
					),
					'default'  => 'default',
				),
				"{$prefix}_banner" => array(
					'label'   => __( 'Banner', 'finbuzz-core' ),
					'type'    => 'select',
					'options' => array(
						'default' => __( 'Default', 'finbuzz-core' ),
						'on'	  => __( 'Enable', 'finbuzz-core' ),
						'off'	  => __( 'Disable', 'finbuzz-core' ),
					),
					'default'  => 'default',
				),
				"{$prefix}_breadcrumb" => array(
					'label'   => __( 'Breadcrumb', 'finbuzz-core' ),
					'type'    => 'select',
					'options' => array(
						'default' => __( 'Default', 'finbuzz-core' ),
						'on'      => __( 'Enable', 'finbuzz-core' ),
						'off'	  => __( 'Disable', 'finbuzz-core' ),
					),
					'default'  => 'default',
				),
				"{$prefix}_banner_type" => array(
					'label'   => __( 'Banner Background Type', 'finbuzz-core' ),
					'type'    => 'select',
					'options' => array(
						'default' => __( 'Default', 'finbuzz-core' ),
						'bgimg'   => __( 'Background Image', 'finbuzz-core' ),
						'bgcolor' => __( 'Background Color', 'finbuzz-core' ),
					),
					'default' => 'default',
				),
				"{$prefix}_banner_bgimg" => array(
					'label' => __( 'Banner Background Image', 'finbuzz-core' ),
					'type'  => 'image',
					'desc'  => __( 'If not selected, default will be used', 'finbuzz-core' ),
				),
				"{$prefix}_banner_bgcolor" => array(
					'label' => __( 'Banner Background Color', 'finbuzz-core' ),
					'type'  => 'color_picker',
					'desc'  => __( 'If not selected, default will be used', 'finbuzz-core' ),
				),		
				"{$prefix}_page_bgimg" => array(
					'label' => __( 'Page/Post Background Image', 'finbuzz-core' ),
					'type'  => 'image',
					'desc'  => __( 'If not selected, default will be used', 'finbuzz-core' ),
				),
				"{$prefix}_page_bgcolor" => array(
					'label' => __( 'Page/Post Background Color', 'finbuzz-core' ),
					'type'  => 'color_picker',
					'desc'  => __( 'If not selected, default will be used', 'finbuzz-core' ),
				),
			)
		)
	),
) );

/*-------------------------------------
#. Team
---------------------------------------*/

$Postmeta->add_meta_box( 'finbuzz_team_settings', __( 'Team Member Settings', 'finbuzz-core' ), array( 'finbuzz_team' ), '', '', 'high', array(
	'fields' => array(
		'finbuzz_team_position' => array(
			'label' => __( 'Position', 'finbuzz-core' ),
			'type'  => 'text',
		),
		'finbuzz_team_socials_header' => array(
			'label' => __( 'Socials', 'finbuzz-core' ),
			'type'  => 'header',
			'desc'  => __( 'Enter your social links here', 'finbuzz-core' ),
		),
		'finbuzz_team_socials' => array(
			'type'  => 'group',
			'value'  => FinbuzzTheme_Helper::team_socials()
		),
	)
) );

/*-------------------------------------
#. Service
---------------------------------------*/

$Postmeta->add_meta_box( 'finbuzz_service_style_box', __( 'Service Info', 'finbuzz-core' ), array( 'finbuzz_service' ), '', '', 'high', array(
	'fields' => array(
		'service_video_link' => array(
			'label' => __( 'Service Video Link', 'finbuzz-core' ),
			'type'  => 'text',
		),
	),
) );

//Flat icon uses metabox
$Postmeta->add_meta_box( 'finbuzz_service_media', __( 'Service Icon image', 'finbuzz-core' ),array( "finbuzz_service" ),'',
		'side',
		'default', array(
		'fields' => array(
			"finbuzz_service_icon" => array(
			  'label' => __( 'Service Icon', 'finbuzz-core' ),
			  'type'  => 'icon_select',
			  'desc'  => __( "Choose a Icon for your service", 'finbuzz-core' ),
			  'options' => FinbuzzTheme_Helper::get_icons(),
			),
			"finbuzz_service_img" => array(
				'label' => __( 'Service Icon Image 1', 'insurex-core' ),
				'type'  => 'image',
				'desc'  => __( "Upload Servie image in case of icon not selected", 'finbuzz-core' ),
			),
			"finbuzz_service_hover_img" => array(
				'label' => __( 'Service Icon Image 2', 'insurex-core' ),
				'type'  => 'image',
				'desc'  => __( "Upload Servie image in case of icon not selected", 'finbuzz-core' ),
			),
		)
) );

/*-------------------------------------
#. Gallery
---------------------------------------*/
$Postmeta->add_meta_box( 'finbuzz_gallery_info', __( 'Gallery Info', 'finbuzz-core' ), array( 'finbuzz_gallery' ), '', '', 'high', array(
	'fields' => array(
		'finbuzz_port_gallery' => array(
			'label' => __( 'Gallery', 'finbuzz-core' ),
			'type'  => 'gallery',
		),
	),
) );


/*-------------------------------------
#. portfolio
---------------------------------------*/
$Postmeta->add_meta_box( 'finbuzz_portfolio_info', __( 'Portfolio Info', 'finbuzz-core' ), array( 'finbuzz_portfolio' ), '', '', 'high', array(
	'fields' => array(
		'portfolio_client_name' => array(
			'label' => __( 'Clients Name', 'finbuzz-core' ),
			'type'  => 'text',
		),
		'portfolio_start_date' => array(
			'label' => __( 'Start Date', 'finbuzz-core' ),
			'type'  => 'date_picker',
			'format' => 'mm/dd/yy',
		),
		'portfolio_end_date' => array(
			'label' => __( 'End Date', 'finbuzz-core' ),
			'type'  => 'date_picker',
			'format' => 'mm/dd/yy',
		),
		'portfolio_website' => array(
			'label' => __( 'Website', 'finbuzz-core' ),
			'type'  => 'text',
		),
		'portfolio_serial_num' => array(
			'label' => __( 'Portfolio Serial Number', 'finbuzz-core' ),
			'type'  => 'text',
		),
	),
) );

/*-------------------------------------
#. Testimonial
---------------------------------------*/
$Postmeta->add_meta_box( 'finbuzz_testimonial_info', __( 'Testimonial Info', 'finbuzz-core' ), array( 'finbuzz_testim' ), '', '', 'high', array(
	'fields' => array(
		'finbuzz_tes_designation' => array(
			'label' => __( 'Designation', 'finbuzz-core' ),
			'type'  => 'text',
		),		
		'finbuzz_tes_rating' => array(
			'label' => __( 'Select the Rating', 'finbuzz-core' ),
			'type'  => 'select',
			'options' => array(
				'default' => __( 'Default', 'finbuzz-core' ),
				'1'    => '1',
				'2'    => '2',
				'3'    => '3',
				'4'    => '4',
				'5'    => '5'
				),
			'default'  => 'default',
		),
	)
) );