<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

class FinbuzzTheme_About_Widget extends WP_Widget {
	public function __construct() {
		parent::__construct(
            'finbuzz_about_author', // Base ID
            esc_html__( 'Finbuzz : About Author', 'finbuzz-core' ), // Name
            array( 'description' => esc_html__( 'About Author Widget', 'finbuzz-core' ) ) // Args
            );
	}

	public function widget( $args, $instance ){
		echo wp_kses_post( $args['before_widget'] );
		if ( !empty( $instance['title'] ) ) {
			$html = apply_filters( 'widget_title', $instance['title'] );
			echo $html = $args['before_title'] . $html .$args['after_title'];
		}
		else {
			$html = '';
		}
		?>
		<div class="author-widget" style="background-image: url(<?php echo wp_get_attachment_image_url($instance['bg_image'],'full') ; ?>)">
		    <div class="author-widget-wrap">
				<?php
					if( !empty( $instance['subtitle'] ) ){ ?>
						<h3><a><?php echo esc_html( $instance['subtitle'] ); ?></a></h3>
					<?php }  
					if( !empty( $instance['phone'] ) ){ ?>
					<div class="phone-number-layout">
						<div class="author-icon">
							<div>
								<i class="fas fa-phone-alt"></i>
							</div>
						</div>
						<div class="phone">
							<a href="tel:<?php echo esc_attr( $instance['phone'] ); ?>"><?php echo esc_html( $instance['phone'] ); ?>
						</a>
						</div>
					</div>
					<?php }   
					if( !empty( $instance['phone2'] ) ){ ?>
					<div class="phone-number-layout mb-0">
						<div class="author-icon">
							<div>
								<i class="fas fa-phone-alt"></i>
							</div>
						</div>
						<div class="phone">
								<a href="tel:<?php echo esc_attr( $instance['phone2'] ); ?>"><?php echo esc_html( $instance['phone2'] ); ?>
								</a>
						</div>
					</div>
					<?php }
				?>
			</div>
		</div>

		<?php
		echo wp_kses_post( $args['after_widget'] );
	}

	public function update( $new_instance, $old_instance ){
		$instance              = array();
		$instance['title']     = ( ! empty( $new_instance['title'] ) ) ? sanitize_text_field( $new_instance['title'] ) : '';
		$instance['bg_image']      = ( ! empty( $new_instance['bg_image'] ) ) ? sanitize_text_field( $new_instance['bg_image'] ) : '';
		$instance['phone']     = ( ! empty( $new_instance['phone'] ) ) ? sanitize_text_field( $new_instance['phone'] ) : '';
		$instance['phone2']     = ( ! empty( $new_instance['phone2'] ) ) ? sanitize_text_field( $new_instance['phone2'] ) : '';
		$instance['subtitle']   = ( ! empty( $new_instance['subtitle'] ) ) ? wp_kses_post( $new_instance['subtitle'] ) : '';
		return $instance;
	}

	public function form( $instance ){
		$defaults = array(
			'title'   		=> esc_html__( 'About Author' , 'finbuzz-core' ),
			'subtitle'		=> '',
			'phone'   		=> '',
			'bg_image'    	=> '',
			'phone2'   		=> '',
			);
		$instance = wp_parse_args( (array) $instance, $defaults );

		$fields = array(
			'title'     => array(
				'label' => esc_html__( 'Title', 'finbuzz-core' ),
				'type'  => 'text',
			),
			'bg_image'    => array(
				'label'   => esc_html__( 'background image', 'blogxer-core' ),
				'type'    => 'image',
			),
			'subtitle' => array(
				'label'   => esc_html__( 'Sub Title', 'techkit-core' ),
				'type'    => 'text',
			),
			'phone'     => array(
				'label' => esc_html__( 'Phone Number', 'finbuzz-core' ),
				'type'  => 'text',
			),      
			'phone2'     => array(
				'label' => esc_html__( 'Phone Number', 'finbuzz-core' ),
				'type'  => 'text',
			),
			
		);

		RT_Widget_Fields::display( $fields, $instance, $this );
	}
}


