<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

$finbuzz_theme_data = wp_get_theme();
	$action  = 'finbuzz_theme_init';
	do_action( $action );

	define( 'FINBUZZ_VERSION', ( WP_DEBUG ) ? time() : $finbuzz_theme_data->get( 'Version' ) );
	define( 'FINBUZZ_AUTHOR_URI', $finbuzz_theme_data->get( 'AuthorURI' ) );
	define( 'FINBUZZ_NAME', 'finbuzz' );

	// DIR
	define( 'FINBUZZ_BASE_DIR',    get_template_directory(). '/' );
	define( 'FINBUZZ_INC_DIR',     FINBUZZ_BASE_DIR . 'inc/' );
	define( 'FINBUZZ_VIEW_DIR',    FINBUZZ_INC_DIR . 'views/' );
	define( 'FINBUZZ_LIB_DIR',     FINBUZZ_BASE_DIR . 'lib/' );
	define( 'FINBUZZ_WID_DIR',     FINBUZZ_INC_DIR . 'widgets/' );
	define( 'FINBUZZ_PLUGINS_DIR', FINBUZZ_INC_DIR . 'plugins/' );
	define( 'FINBUZZ_MODULES_DIR', FINBUZZ_INC_DIR . 'modules/' );
	define( 'FINBUZZ_ASSETS_DIR',  FINBUZZ_BASE_DIR . 'assets/' );
	define( 'FINBUZZ_CSS_DIR',     FINBUZZ_ASSETS_DIR . 'css/' );
	define( 'FINBUZZ_JS_DIR',      FINBUZZ_ASSETS_DIR . 'js/' );
	define( 'FINBUZZ_WOO_DIR',     FINBUZZ_BASE_DIR . 'woocommerce/' );

	// URL
	define( 'FINBUZZ_BASE_URL',    get_template_directory_uri(). '/' );
	define( 'FINBUZZ_ASSETS_URL',  FINBUZZ_BASE_URL . 'assets/' );
	define( 'FINBUZZ_CSS_URL',     FINBUZZ_ASSETS_URL . 'css/' );
	define( 'FINBUZZ_JS_URL',      FINBUZZ_ASSETS_URL . 'js/' );
	define( 'FINBUZZ_IMG_URL',     FINBUZZ_ASSETS_URL . 'img/' );
	define( 'FINBUZZ_LIB_URL',     FINBUZZ_BASE_URL . 'lib/' );

	//Other Plugins active or not
	define( 'FINBUZZ_BBPRESS_IS_ACTIVE', class_exists( 'bbPress' ) );
	// icon trait Plugin Activation
	require_once FINBUZZ_INC_DIR . 'icon-trait.php';
	// Includes
	require_once FINBUZZ_INC_DIR . 'finbuzz-register-widget.php';
	require_once FINBUZZ_INC_DIR . 'helper-functions.php';
	require_once FINBUZZ_INC_DIR . 'finbuzz.php';
	require_once FINBUZZ_INC_DIR . 'general.php';
	require_once FINBUZZ_INC_DIR . 'scripts.php';
	require_once FINBUZZ_INC_DIR . 'template-vars.php';
	require_once FINBUZZ_INC_DIR . 'includes.php';
	require_once FINBUZZ_INC_DIR . 'lc-helper.php';
	require_once FINBUZZ_INC_DIR . 'lc-utility.php';

	// Includes Modules
	require_once FINBUZZ_MODULES_DIR . 'rt-post-related.php';
	require_once FINBUZZ_MODULES_DIR . 'rt-gallery-related.php';
	require_once FINBUZZ_MODULES_DIR . 'rt-portfolio-related.php';
	require_once FINBUZZ_MODULES_DIR . 'rt-service-related.php';
	require_once FINBUZZ_MODULES_DIR . 'rt-team-related.php';
	require_once FINBUZZ_MODULES_DIR . 'rt-breadcrumbs.php';

	// TGM Plugin Activation
	require_once FINBUZZ_LIB_DIR . 'class-tgm-plugin-activation.php';
	require_once FINBUZZ_INC_DIR . 'tgm-config.php';

	add_editor_style( 'style-editor.css' );

	// Update Breadcrumb Separator
	add_action('bcn_after_fill', 'finbuzz_hseparator_breadcrumb_trail', 1);
	function finbuzz_hseparator_breadcrumb_trail($object){
		$object->opt['hseparator'] = '<span class="dvdr"> - </span>';
		return $object;
	}

