<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */
namespace radiustheme\finbuzz\Customizer\Settings;

use radiustheme\finbuzz\Customizer\FinbuzzTheme_Customizer;
use radiustheme\finbuzz\Customizer\Controls\Customizer_Switch_Control;
use radiustheme\finbuzz\Customizer\Controls\Customizer_Heading_Control;
use radiustheme\finbuzz\Customizer\Controls\Customizer_Image_Radio_Control;
use WP_Customize_Media_Control;
use WP_Customize_Color_Control;


class FinbuzzTheme_Footer_CTA_Settings extends FinbuzzTheme_Customizer {

    public function __construct() {
	    parent::instance();
        $this->populated_default_data();
        // Add Controls
        add_action( 'customize_register', array( $this, 'register_footer_controls' ) );
	}
    public function register_footer_controls( $wp_customize ) {
        //Footer Cta Area

        $wp_customize->add_setting( 'footer_cta_area',
            array(
                'default' => $this->defaults['footer_cta_area'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_switch_sanitization',
            )
        );
        $wp_customize->add_control( new Customizer_Switch_Control( $wp_customize, 'footer_cta_area',
            array(
                'label' => __( 'Footer CTA Area', 'finbuzz' ),
                'section' => 'footer_cta_section',
            )
        ) );
        
        $wp_customize->add_setting( 'footer_cta_area_title',
            array(
                'default' => $this->defaults['footer_cta_area_title'],
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_textarea_field',
                )
            );
        $wp_customize->add_control( 'footer_cta_area_title',
            array(
                'label' => __( 'Footer CTA Title', 'finbuzz' ),
                'section' => 'footer_cta_section',
                'type' => 'textarea',
            )
        );

        // Footer background image
		$wp_customize->add_setting( 'fctabgimg',
            array(
                'default' => $this->defaults['fctabgimg'],
                'transport' => 'refresh',
                'sanitize_callback' => 'absint',
            )
        );
        $wp_customize->add_control( new WP_Customize_Media_Control( $wp_customize, 'fctabgimg',
            array(
                'label' => __( 'Footer CTA Image', 'finbuzz' ),
                'description' => esc_html__( 'This is the description for the Media Control', 'finbuzz' ),
                'section' => 'footer_cta_section',
                'mime_type' => 'image',
                'button_labels' => array(
                    'select' => __( 'Select File', 'finbuzz' ),
                    'change' => __( 'Change File', 'finbuzz' ),
                    'default' => __( 'Default', 'finbuzz' ),
                    'remove' => __( 'Remove', 'finbuzz' ),
                    'placeholder' => __( 'No file selected', 'finbuzz' ),
                    'frame_title' => __( 'Select File', 'finbuzz' ),
                    'frame_button' => __( 'Choose File', 'finbuzz' ),
                ),
            )
        ) );

        $wp_customize->add_setting( 'fctaphone_title',
        array(
            'default' => $this->defaults['fctaphone_title'],
            'transport' => 'refresh',
            'sanitize_callback' => 'rttheme_text_sanitization',
            )
        );
        $wp_customize->add_control( 'fctaphone_title',
            array(
                'label' => __( 'Phone Title', 'finbuzz' ),
                'section' => 'footer_cta_section',
                'type' => 'text',
            )
        );
        $wp_customize->add_setting( 'fctaemail_title',
        array(
            'default' => $this->defaults['fctaemail_title'],
            'transport' => 'refresh',
            'sanitize_callback' => 'rttheme_text_sanitization',
            )
        );
        $wp_customize->add_control( 'fctaemail_title',
            array(
                'label' => __( 'Email Title', 'finbuzz' ),
                'section' => 'footer_cta_section',
                'type' => 'text',
            )
        );
        $wp_customize->add_setting( 'fctaphone_number',
        array(
            'default' => $this->defaults['fctaphone_number'],
            'transport' => 'refresh',
            'sanitize_callback' => 'rttheme_text_sanitization',
            )
        );
        $wp_customize->add_control( 'fctaphone_number',
            array(
                'label' => __( 'Phone Number', 'finbuzz' ),
                'section' => 'footer_cta_section',
                'type' => 'text',
            )
        );
        $wp_customize->add_setting( 'fctaemail_address',
        array(
            'default' => $this->defaults['fctaemail_address'],
            'transport' => 'refresh',
            'sanitize_callback' => 'rttheme_text_sanitization',
            )
        );
        $wp_customize->add_control( 'fctaemail_address',
            array(
                'label' => __( 'Phone Number', 'finbuzz' ),
                'section' => 'footer_cta_section',
                'type' => 'text',
            )
        );
    }
}
/**
 * Initialise our Customizer settings only when they're required
 */
if ( class_exists( 'WP_Customize_Control' ) ) {
	new FinbuzzTheme_Footer_CTA_Settings();
}