<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */
namespace radiustheme\finbuzz\Customizer\Settings;

use radiustheme\finbuzz\Customizer\FinbuzzTheme_Customizer;
use radiustheme\finbuzz\Customizer\Controls\Customizer_Switch_Control;
use radiustheme\finbuzz\Customizer\Controls\Customizer_Heading_Control;
use radiustheme\finbuzz\Customizer\Controls\Customizer_Separator_Control;
use radiustheme\finbuzz\Customizer\Controls\Customizer_Image_Radio_Control;
use WP_Customize_Media_Control;
use WP_Customize_Color_Control;

/**
 * Adds the individual sections, settings, and controls to the theme customizer
 */
class FinbuzzTheme_Service_Post_Settings extends FinbuzzTheme_Customizer {

	public function __construct() {
	    parent::instance();
        $this->populated_default_data();
        // Add Controls
        add_action( 'customize_register', array( $this, 'register_service_post_controls' ) );
	}

    /**
     * Gallery Post Controls
     */
    public function register_service_post_controls( $wp_customize ) {
		
		$wp_customize->add_setting( 'services_style',
            array(
                'default' => $this->defaults['services_style'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_radio_sanitization'
            )
        );
        $wp_customize->add_control( new Customizer_Image_Radio_Control( $wp_customize, 'services_style',
            array(
                'label' => __( 'Service Archive Layout', 'finbuzz' ),
                'description' => esc_html__( 'Select the Service layout for service page', 'finbuzz' ),
                'section' => 'rttheme_service_settings',
                'choices' => array(
                    'style1' => array(
                        'image' => trailingslashit( get_template_directory_uri() ) . 'assets/img/post-style-1.png',
                        'name' => __( 'Layout 1', 'finbuzz' )
                    ),
                    'style2' => array(
                        'image' => trailingslashit( get_template_directory_uri() ) . 'assets/img/post-style-3.png',
                        'name' => __( 'Layout 2', 'finbuzz' )
                    ),
                )
            )
        ) );

        // Gallery option
        $wp_customize->add_setting( 'service_excerpt_limit',
            array(
                'default' => $this->defaults['service_excerpt_limit'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_text_sanitization',
            )
        );
        $wp_customize->add_control( 'service_excerpt_limit',
            array(
                'label' => __( 'Service Content Limit', 'finbuzz' ),
                'section' => 'rttheme_service_settings',
                'type' => 'number',
            )
        );
		
		$wp_customize->add_setting( 'service_ar_icon',
            array(
                'default' => $this->defaults['service_ar_icon'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_switch_sanitization',
            )
        );
        $wp_customize->add_control( new Customizer_Switch_Control( $wp_customize, 'service_ar_icon',
            array(
                'label' => __( 'Service Icon', 'finbuzz' ),
                'section' => 'rttheme_service_settings',
            )
        ));
		
		
		
		$wp_customize->add_setting( 'service_ar_button',
            array(
                'default' => $this->defaults['service_ar_button'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_switch_sanitization',
            )
        );
        $wp_customize->add_control( new Customizer_Switch_Control( $wp_customize, 'service_ar_button',
            array(
                'label' => __( 'Service Button', 'finbuzz' ),
                'section' => 'rttheme_service_settings',
            )
        ));
		
		
		$wp_customize->add_setting('service_single_heading', array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
        ));
        $wp_customize->add_control(new Customizer_Heading_Control($wp_customize, 'service_single_heading', array(
            'label' => __( 'Single Service', 'finbuzz' ),
            'section' => 'rttheme_service_settings',
        )));
		// Related Gallery Post
		$wp_customize->add_setting('service_related_heading', array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
        ));
        $wp_customize->add_control(new Customizer_Heading_Control($wp_customize, 'service_related_heading', array(
            'label' => __( 'Related Service Settings', 'finbuzz' ),
            'section' => 'rttheme_service_settings',
        )));
		
		$wp_customize->add_setting( 'show_related_service',
            array(
                'default' => $this->defaults['show_related_service'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_switch_sanitization',
            )
        );
        $wp_customize->add_control( new Customizer_Switch_Control( $wp_customize, 'show_related_service',
            array(
                'label' => __( 'Show Related Service', 'finbuzz' ),
                'section' => 'rttheme_service_settings',
            )
        ));
		
		$wp_customize->add_setting( 'service_related_title',
            array(
                'default' => $this->defaults['service_related_title'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_text_sanitization',
            )
        );
        $wp_customize->add_control( 'service_related_title',
            array(
                'label' => __( 'Related Title', 'finbuzz' ),
                'section' => 'rttheme_service_settings',
                'type' => 'text',
				'active_callback'   => 'rttheme_is_related_service_enabled',
            )
        );
		
		
		
		
		$wp_customize->add_setting( 'related_service_number',
            array(
                'default' => $this->defaults['related_service_number'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_text_sanitization',
            )
        );
        $wp_customize->add_control( 'related_service_number',
            array(
                'label' => __( 'Service Post', 'finbuzz' ),
                'section' => 'rttheme_service_settings',
                'type' => 'number',
				'active_callback'   => 'rttheme_is_related_service_enabled',
            )
        );
		
		$wp_customize->add_setting( 'related_service_title_limit',
            array(
                'default' => $this->defaults['related_service_title_limit'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_text_sanitization',
            )
        );
        $wp_customize->add_control( 'related_service_title_limit',
            array(
                'label' => __( 'Title Limit', 'finbuzz' ),
                'section' => 'rttheme_service_settings',
                'type' => 'number',
				'active_callback'   => 'rttheme_is_related_service_enabled',
            )
        );

    }

}

/**
 * Initialise our Customizer settings only when they're required
 */
if ( class_exists( 'WP_Customize_Control' ) ) {
	new FinbuzzTheme_Service_Post_Settings();
}
