<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */
namespace radiustheme\finbuzz\Customizer\Settings;

use radiustheme\finbuzz\Customizer\FinbuzzTheme_Customizer;

/**
 * Adds the individual sections, settings, and controls to the theme customizer
 */
class FinbuzzTheme_Slug_Settings extends FinbuzzTheme_Customizer {

	public function __construct() {
        parent::instance();
        $this->populated_default_data();
        // Register Page Controls
        add_action( 'customize_register', array( $this, 'register_slug_controls' ) );
	}

    public function register_slug_controls( $wp_customize ) {

	    $wp_customize->add_setting( 'team_admin_title',
		    array(
			    'default' => $this->defaults['team_admin_title'],
			    'transport' => 'refresh',
			    'sanitize_callback' => 'rttheme_text_sanitization'
		    )
	    );
	    $wp_customize->add_control( 'team_admin_title',
		    array(
			    'label' => __( 'Team Admin Title', 'finbuzz' ),
			    'section' => 'post_type_slug_section',
			    'type' => 'text',
		    )
	    );

	
		$wp_customize->add_setting( 'team_slug',
            array(
                'default' => $this->defaults['team_slug'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_text_sanitization'
            )
        );
        $wp_customize->add_control( 'team_slug',
            array(
                'label' => __( 'Team Slug', 'finbuzz' ),
                'section' => 'post_type_slug_section',
                'type' => 'text',
            )
        );
	    $wp_customize->add_setting( 'services_admin_title',
		    array(
			    'default' => $this->defaults['services_admin_title'],
			    'transport' => 'refresh',
			    'sanitize_callback' => 'rttheme_text_sanitization'
		    )
	    );
	    $wp_customize->add_control( 'services_admin_title',
		    array(
			    'label' => __( 'Service Admin Title', 'finbuzz' ),
			    'section' => 'post_type_slug_section',
			    'type' => 'text',
		    )
	    );
		$wp_customize->add_setting( 'service_slug',
            array(
                'default' => $this->defaults['service_slug'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_text_sanitization'
            )
        );
        $wp_customize->add_control( 'service_slug',
            array(
                'label' => __( 'Service Slug', 'finbuzz' ),
                'section' => 'post_type_slug_section',
                'type' => 'text',
            )
        );
	    $wp_customize->add_setting( 'portfolios_admin_title',
		    array(
			    'default' => $this->defaults['portfolios_admin_title'],
			    'transport' => 'refresh',
			    'sanitize_callback' => 'rttheme_text_sanitization'
		    )
	    );
	    $wp_customize->add_control( 'portfolios_admin_title',
		    array(
			    'label' => __( 'Portfolio Admin Title', 'finbuzz' ),
			    'section' => 'post_type_slug_section',
			    'type' => 'text',
		    )
	    );
		$wp_customize->add_setting( 'portfolio_slug',
            array(
                'default' => $this->defaults['portfolio_slug'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_text_sanitization'
            )
        );
        $wp_customize->add_control( 'portfolio_slug',
            array(
                'label' => __( 'Portfolio Slug', 'finbuzz' ),
                'section' => 'post_type_slug_section',
                'type' => 'text',
            )
        );
	    $wp_customize->add_setting( 'galleries_admin_title',
		    array(
			    'default' => $this->defaults['galleries_admin_title'],
			    'transport' => 'refresh',
			    'sanitize_callback' => 'rttheme_text_sanitization'
		    )
	    );
	    $wp_customize->add_control( 'galleries_admin_title',
		    array(
			    'label' => __( 'Gallery Admin Title', 'finbuzz' ),
			    'section' => 'post_type_slug_section',
			    'type' => 'text',
		    )
	    );
        $wp_customize->add_setting( 'gallery_slug',
            array(
                'default' => $this->defaults['gallery_slug'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_text_sanitization'
            )
        );
        $wp_customize->add_control( 'gallery_slug',
            array(
                'label' => __( 'Gallery Slug', 'finbuzz' ),
                'section' => 'post_type_slug_section',
                'type' => 'text',
            )
        );

	    $wp_customize->add_setting( 'testimonials_admin_title',
		    array(
			    'default' => $this->defaults['testimonials_admin_title'],
			    'transport' => 'refresh',
			    'sanitize_callback' => 'rttheme_text_sanitization'
		    )
	    );
	    $wp_customize->add_control( 'testimonials_admin_title',
		    array(
			    'label' => __( 'Testimonial Admin Title', 'finbuzz' ),
			    'section' => 'post_type_slug_section',
			    'type' => 'text',
		    )
	    );
		$wp_customize->add_setting( 'testimonial_slug',
            array(
                'default' => $this->defaults['testimonial_slug'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_text_sanitization'
            )
        );
        $wp_customize->add_control( 'testimonial_slug',
            array(
                'label' => __( 'Testimonial Slug', 'finbuzz' ),
                'section' => 'post_type_slug_section',
                'type' => 'text',
            )
        );

        $wp_customize->add_setting( 'logoshowcase_slug',
            array(
                'default' => $this->defaults['logoshowcase_slug'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_text_sanitization'
            )
        );
        $wp_customize->add_control( 'logoshowcase_slug',
            array(
                'label' => __( 'Logo Showcase Slug', 'finbuzz' ),
                'section' => 'post_type_slug_section',
                'type' => 'text',
            )
        );
		
		// Category
		$wp_customize->add_setting( 'team_cat_slug',
            array(
                'default' => $this->defaults['team_cat_slug'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_text_sanitization'
            )
        );
        $wp_customize->add_control( 'team_cat_slug',
            array(
                'label' => __( 'Team Category Slug', 'finbuzz' ),
                'section' => 'post_type_slug_section',
                'type' => 'text',
            )
        );
		
		$wp_customize->add_setting( 'service_cat_slug',
            array(
                'default' => $this->defaults['service_cat_slug'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_text_sanitization'
            )
        );
        $wp_customize->add_control( 'service_cat_slug',
            array(
                'label' => __( 'Service Category Slug', 'finbuzz' ),
                'section' => 'post_type_slug_section',
                'type' => 'text',
            )
        );
		
		$wp_customize->add_setting( 'portfolio_cat_slug',
            array(
                'default' => $this->defaults['portfolio_cat_slug'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_text_sanitization'
            )
        );
        $wp_customize->add_control( 'portfolio_cat_slug',
            array(
                'label' => __( 'Portfolio Category Slug', 'finbuzz' ),
                'section' => 'post_type_slug_section',
                'type' => 'text',
            )
        );
		
		$wp_customize->add_setting( 'testim_cat_slug',
            array(
                'default' => $this->defaults['testim_cat_slug'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_text_sanitization'
            )
        );
        $wp_customize->add_control( 'testim_cat_slug',
            array(
                'label' => __( 'Testimonial Category Slug', 'finbuzz' ),
                'section' => 'post_type_slug_section',
                'type' => 'text',
            )
        );
        
        $wp_customize->add_setting( 'gallery_cat_slug',
            array(
                'default' => $this->defaults['gallery_cat_slug'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_text_sanitization'
            )
        );
        $wp_customize->add_control( 'gallery_cat_slug',
            array(
                'label' => __( 'Gallery Category Slug', 'finbuzz' ),
                'section' => 'post_type_slug_section',
                'type' => 'text',
            )
        );

        

    }

}

/**
 * Initialise our Customizer settings only when they're required
 */
if ( class_exists( 'WP_Customize_Control' ) ) {
	new FinbuzzTheme_Slug_Settings();
}
