<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

if( ! function_exists( 'finbuzz_related_team' )){
	
	function finbuzz_related_team(){
		$thumb_size = 'finbuzz-size7';
		$post_id = get_the_id();	
		$number_of_avail_post = '';
		$current_post = array( $post_id );
		$title_length = FinbuzzTheme::$options['related_team_title_limit'] ? FinbuzzTheme::$options['related_team_title_limit'] : '';
		$related_post_number = FinbuzzTheme::$options['related_team_number'];
		
		$content 	= get_the_content();
		$content 	= apply_filters( 'the_content', $content );
		
		$team_related_title  = get_post_meta( get_the_ID(), 'team_related_title', true );

		# Making ready to the Query ...
		$query_type = FinbuzzTheme::$options['related_post_query'];

		$args = array(
			'post_type'				 => 'finbuzz_team',
			'post__not_in'           => $current_post,
			'posts_per_page'         => $related_post_number,
			'no_found_rows'          => true,
			'post_status'            => 'publish',
			'ignore_sticky_posts'    => true,
			'update_post_term_cache' => false,
		);

		# Checking Related Posts Order ----------
		if( FinbuzzTheme::$options['related_post_sort'] ){

			$post_order = FinbuzzTheme::$options['related_post_sort'];

			if( $post_order == 'rand' ){

				$args['orderby'] = 'rand';
			}
			elseif( $post_order == 'views' ){

				$args['orderby']  = 'meta_value_num';
				$args['meta_key'] = 'finbuzz_views';
			}
			elseif( $post_order == 'popular' ){

				$args['orderby'] = 'comment_count';
			}
			elseif( $post_order == 'modified' ){

				$args['orderby'] = 'modified';
				$args['order']   = 'ASC';
			}
			elseif( $post_order == 'recent' ){

				$args['orderby'] = '';
				$args['order']   = '';
			}
		}


		# Get related posts by author ----------
		if( $query_type == 'author' ){
			$args['author'] = get_the_author_meta( 'ID' );
		}

		# Get related posts by tags ----------
		elseif( $query_type == 'tag' ){
			$tags_ids  = array();
			$post_tags = get_the_terms( $post_id, 'post_tag' );

			if( ! empty( $post_tags ) ){
				foreach( $post_tags as $individual_tag ){
					$tags_ids[] = $individual_tag->term_id;
				}

				$args['tag__in'] = $tags_ids;
			}
		}

		# Get related posts by categories ----------
		else{
			
			$terms = get_the_terms( $post_id, 'finbuzz_team_category' );
			if($terms ){
				if ( $terms && ! is_wp_error( $terms ) ) {
			 
					$port_cat_links = array();
				 
					foreach ( $terms as $term ) {
						$port_cat_links[] = $term->term_id;
					}
				}
				
				
				$args['tax_query'] = array (
					array (
						'taxonomy' => 'finbuzz_team_category',
						'field'    => 'ID',
						'terms'    => $port_cat_links,
					)
				);
			}
			
		}

		# Get the posts ----------
		$related_query = new wp_query( $args );
		/*the_carousel*/
		
		
		$count_post = $related_query->post_count;
		if ( $count_post < 4 ) {
			$number_of_avail_post = false;
		} else {
			$number_of_avail_post = true;
		}
		$swiper_data=array(
			'slidesPerView' 	=>2,
			'centeredSlides'	=>false,
			'loop'				=>true,
			'spaceBetween'		=>20,
			'slideToClickedSlide' =>true,
			'slidesPerGroup' => 1,
			'autoplay'				=>array(
				'delay'  => 1,
			),
			'speed'      =>500,
			'breakpoints' =>array(
				'0'    =>array('slidesPerView' =>1),
				'576'    =>array('slidesPerView' =>2),
				'768'    =>array('slidesPerView' =>2),
				'992'    =>array('slidesPerView' =>2),
				'1200'    =>array('slidesPerView' =>3),				
				'1600'    =>array('slidesPerView' =>3)				
			),
			'auto'   =>false
		);

		$swiper_data = json_encode( $swiper_data );
		
		
		if( $related_query->have_posts() ) { ?>
		
		<div class="team-default team-multi-layout-1 team-grid-style1  rt-related-post team-related-post">
			<div class="rt-related-slider" data-xld = '<?php echo esc_attr($swiper_data);?>'>
				<div class="section-title">
				<?php if ( FinbuzzTheme::$options['team_related_title'] ) { ?>
				<h3 class="related-title"><?php echo wp_kses( FinbuzzTheme::$options['team_related_title'] , 'alltext_allow' );?></h3><?php } ?>
					<?php if ( $count_post > 3 ){ ?>
						<div class="swiper-button">
							<div class="swiper-button-prev"><i class="fas fa-chevron-left"></i></div>
							<div class="swiper-button-next"><i class="fas fa-chevron-right"></i></div>
						</div>
					<?php } ?>
					
				</div>
				
				<div class="swiper-wrapper">
					<?php
						while ( $related_query->have_posts() ) {
						$related_query->the_post();
						$trimmed_title = wp_trim_words( get_the_title(), $title_length, '' );
						$id = get_the_ID();
						$socials       	= get_post_meta( $id, 'finbuzz_team_socials', true );
						$social_fields 	= FinbuzzTheme_Helper::team_socials();
						$position   	= get_post_meta( $id, 'finbuzz_team_position', true );
					?>
						<div class="swiper-slide">						
							<div class="rtin-item">
								<div class="rtin-content-wrap">		
									<div class="team-thumb">
										<figure>
											<a href="<?php the_permalink();?>">
												<?php
												if ( has_post_thumbnail() ){
													the_post_thumbnail( $thumb_size );
												}
												else {
													if ( !empty( FinbuzzTheme::$options['no_preview_image']['id'] ) ) {
														echo wp_get_attachment_image( FinbuzzTheme::$options['no_preview_image']['id'], $thumb_size );
													}
													else {
														echo '<img class="wp-post-image" src="' . FinbuzzTheme_Helper::get_img( 'noimage_400X400.jpg' ) . '" alt="'. the_title_attribute( array( 'echo'=> false ) ) .'">';
													}
												}
												?>
											</a>
											<?php if ( FinbuzzTheme::$options['related_team_social'] ) { ?>
													<ul class="rtin-social-icon">
														<?php foreach ( $socials as $key => $social ): ?>
															<?php if ( !empty( $social ) ): ?>
																<li><a target="_blank" href="<?php echo esc_url( $social );?>"><i class="fab <?php echo esc_attr( $social_fields[$key]['icon'] );?>" aria-hidden="true"></i></a></li>
															<?php endif; ?>
														<?php endforeach; ?>
													</ul>
											<?php } ?>
										</figure>
									</div>
									<div class="rtin-content">
										<h3 class="rtin-title"><a href="<?php the_permalink();?>"><?php echo wp_kses( $trimmed_title , 'alltext_allow' ); ?></a></h3>
										<?php if ( FinbuzzTheme::$options['related_team_position'] ) { ?>
										<div class="rtin-designation"><?php echo esc_html( $position );?></div>
										<?php } ?>
									</div>
								</div>
							</div>
						</div>
					<?php } ?>
				</div>
			</div>
		</div>
		<?php }
		wp_reset_postdata();
	}
}
?>