<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

add_action( 'template_redirect', 'finbuzz_template_vars' );
if( !function_exists( 'finbuzz_template_vars' ) ) {
    function finbuzz_template_vars() {
        // Single Pages
        if( is_single() || is_page() ) {
            $post_type = get_post_type();
            $post_id   = get_the_id();
            switch( $post_type ) {
                case 'page':
                $prefix = 'page';
                break;
				case 'finbuzz_service':
                $prefix = 'service';
                break;		  
                case 'finbuzz_portfolio':
                $prefix = 'portfolio';
                break;
                case 'finbuzz_gallery':
                $prefix = 'gallery';
                break;  		  
                case 'finbuzz_team':
                $prefix = 'team';
                break;  
                case 'product':
                $prefix = 'product';
                break;
                default:
                $prefix = 'single_post';
                break;
            }
			
			$layout_settings    = get_post_meta( $post_id, 'finbuzz_layout_settings', true );
            
            FinbuzzTheme::$layout = ( empty( $layout_settings['finbuzz_layout'] ) || $layout_settings['finbuzz_layout']  == 'default' ) ? FinbuzzTheme::$options[$prefix . '_layout'] : $layout_settings['finbuzz_layout'];

			FinbuzzTheme::$tr_header = ( empty( $layout_settings['finbuzz_tr_header'] ) || $layout_settings['finbuzz_tr_header'] == 'default' ) ? FinbuzzTheme::$options['tr_header'] : $layout_settings['finbuzz_tr_header'];
            
            FinbuzzTheme::$top_bar = ( empty( $layout_settings['finbuzz_top_bar'] ) || $layout_settings['finbuzz_top_bar'] == 'default' ) ? FinbuzzTheme::$options['top_bar'] : $layout_settings['finbuzz_top_bar'];
            
            FinbuzzTheme::$top_bar_style = ( empty( $layout_settings['finbuzz_top_bar_style'] ) || $layout_settings['finbuzz_top_bar_style'] == 'default' ) ? FinbuzzTheme::$options['top_bar_style'] : $layout_settings['finbuzz_top_bar_style'];
			
			FinbuzzTheme::$header_opt = ( empty( $layout_settings['finbuzz_header_opt'] ) || $layout_settings['finbuzz_header_opt'] == 'default' ) ? FinbuzzTheme::$options['header_opt'] : $layout_settings['finbuzz_header_opt'];
            
            FinbuzzTheme::$header_style = ( empty( $layout_settings['finbuzz_header'] ) || $layout_settings['finbuzz_header'] == 'default' ) ? FinbuzzTheme::$options['header_style'] : $layout_settings['finbuzz_header'];
			
            FinbuzzTheme::$footer_style = ( empty( $layout_settings['finbuzz_footer'] ) || $layout_settings['finbuzz_footer'] == 'default' ) ? FinbuzzTheme::$options['footer_style'] : $layout_settings['finbuzz_footer'];
			
			FinbuzzTheme::$footer_area = ( empty( $layout_settings['finbuzz_footer_area'] ) || $layout_settings['finbuzz_footer_area'] == 'default' ) ? FinbuzzTheme::$options['footer_area'] : $layout_settings['finbuzz_footer_area'];
			
            FinbuzzTheme::$footer_top_logo_area = ( empty( $layout_settings['finbuzz_footer_top_logo_area'] ) || $layout_settings['finbuzz_footer_top_logo_area'] == 'default' ) ? FinbuzzTheme::$options['footer_top_logo_area'] : $layout_settings['finbuzz_footer_top_logo_area'];

            FinbuzzTheme::$footer_cta_area = ( empty( $layout_settings['finbuzz_footer_cta_area'] ) || $layout_settings['finbuzz_footer_cta_area'] == 'default' ) ? FinbuzzTheme::$options['footer_cta_area'] : $layout_settings['finbuzz_footer_cta_area'];
			
            $padding_top = ( empty( $layout_settings['finbuzz_top_padding'] ) || $layout_settings['finbuzz_top_padding'] == 'default' ) ? FinbuzzTheme::$options[$prefix . '_padding_top'] : $layout_settings['finbuzz_top_padding'];
			
            FinbuzzTheme::$padding_top = (int) $padding_top;
            
            $padding_bottom = ( empty( $layout_settings['finbuzz_bottom_padding'] ) || $layout_settings['finbuzz_bottom_padding'] == 'default' ) ? FinbuzzTheme::$options[$prefix . '_padding_bottom'] : $layout_settings['finbuzz_bottom_padding'];
			
            FinbuzzTheme::$padding_bottom = (int) $padding_bottom;
			
            FinbuzzTheme::$has_banner = ( empty( $layout_settings['finbuzz_banner'] ) || $layout_settings['finbuzz_banner'] == 'default' ) ? FinbuzzTheme::$options[$prefix . '_banner'] : $layout_settings['finbuzz_banner'];
            
            FinbuzzTheme::$has_breadcrumb = ( empty( $layout_settings['finbuzz_breadcrumb'] ) || $layout_settings['finbuzz_breadcrumb'] == 'default' ) ? FinbuzzTheme::$options[ $prefix . '_breadcrumb'] : $layout_settings['finbuzz_breadcrumb'];
            
            FinbuzzTheme::$bgtype = ( empty( $layout_settings['finbuzz_banner_type'] ) || $layout_settings['finbuzz_banner_type'] == 'default' ) ? FinbuzzTheme::$options[$prefix . '_bgtype'] : $layout_settings['finbuzz_banner_type'];
            
            FinbuzzTheme::$bgcolor = empty( $layout_settings['finbuzz_banner_bgcolor'] ) ? FinbuzzTheme::$options[$prefix . '_bgcolor'] : $layout_settings['finbuzz_banner_bgcolor'];
			
			if( !empty( $layout_settings['finbuzz_banner_bgimg'] ) ) {
                $attch_url      = wp_get_attachment_image_src( $layout_settings['finbuzz_banner_bgimg'], 'full', true );
                FinbuzzTheme::$bgimg = $attch_url[0];
            } elseif( !empty( FinbuzzTheme::$options[$prefix . '_bgimg'] ) ) {
                $attch_url      = wp_get_attachment_image_src( FinbuzzTheme::$options[$prefix . '_bgimg'], 'full', true );
                FinbuzzTheme::$bgimg = $attch_url[0];
            } else {
                FinbuzzTheme::$bgimg = FINBUZZ_IMG_URL . 'banner.png';
            }
			
            FinbuzzTheme::$pagebgcolor = empty( $layout_settings['finbuzz_page_bgcolor'] ) ? FinbuzzTheme::$options[$prefix . '_page_bgcolor'] : $layout_settings['finbuzz_page_bgcolor'];			
            
            if( !empty( $layout_settings['finbuzz_page_bgimg'] ) ) {
                $attch_url      = wp_get_attachment_image_src( $layout_settings['finbuzz_page_bgimg'], 'full', true );
                FinbuzzTheme::$pagebgimg = $attch_url[0];
            } elseif( !empty( FinbuzzTheme::$options[$prefix . '_page_bgimg'] ) ) {
                $attch_url      = wp_get_attachment_image_src( FinbuzzTheme::$options[$prefix . '_page_bgimg'], 'full', true );
                FinbuzzTheme::$pagebgimg = $attch_url[0];
            }
        }
        
        // Blog and Archive
        elseif( is_home() || is_archive() || is_search() || is_404() ) {
            if( is_search() ) {
                $prefix = 'search';
            } else if( is_404() ) {
                $prefix                                = 'error';
                FinbuzzTheme::$options[$prefix . '_layout'] = 'full-width';
            } else if( function_exists( 'is_woocommerce' ) && is_woocommerce() ) {
                $prefix = 'shop';
            } elseif( is_post_type_archive( "finbuzz_service" ) || is_tax( "finbuzz_service_category" ) ) {
                $prefix = 'service_archive';            
            } elseif( is_post_type_archive( "finbuzz_portfolio" ) || is_tax( "finbuzz_portfolio_category" ) ) {
                $prefix = 'portfolio_archive'; 
            } elseif( is_post_type_archive( "finbuzz_gallery" ) || is_tax( "finbuzz_gallery_category" ) ) {
                    $prefix = 'gallery_archive';
			} elseif( is_post_type_archive( "finbuzz_team" ) || is_tax( "finbuzz_team_category" ) ) {
                $prefix = 'team_archive'; 
			} else {
                $prefix = 'blog';
            }
            
            FinbuzzTheme::$layout         		= FinbuzzTheme::$options[$prefix . '_layout'];
            FinbuzzTheme::$tr_header      		= FinbuzzTheme::$options['tr_header'];
            FinbuzzTheme::$top_bar        		= FinbuzzTheme::$options['top_bar'];
            FinbuzzTheme::$header_opt      		= FinbuzzTheme::$options['header_opt'];
            FinbuzzTheme::$footer_area     		= FinbuzzTheme::$options['footer_area'];
            FinbuzzTheme::$footer_top_logo_area  = FinbuzzTheme::$options['footer_top_logo_area'];
            FinbuzzTheme::$footer_cta_area      =  FinbuzzTheme::$options['footer_cta_area'] ;
            FinbuzzTheme::$top_bar_style  		= FinbuzzTheme::$options['top_bar_style'];
            FinbuzzTheme::$header_style   		= FinbuzzTheme::$options['header_style'];
            FinbuzzTheme::$footer_style   		= FinbuzzTheme::$options['footer_style'];
            FinbuzzTheme::$padding_top    		= FinbuzzTheme::$options[$prefix . '_padding_top'];
            FinbuzzTheme::$padding_bottom 		= FinbuzzTheme::$options[$prefix . '_padding_bottom'];
            FinbuzzTheme::$has_banner     		= FinbuzzTheme::$options[$prefix . '_banner'];
            FinbuzzTheme::$has_breadcrumb 		= FinbuzzTheme::$options[$prefix . '_breadcrumb'];
            FinbuzzTheme::$bgtype         		= FinbuzzTheme::$options[$prefix . '_bgtype'];
            FinbuzzTheme::$bgcolor        		= FinbuzzTheme::$options[$prefix . '_bgcolor'];
            if( !empty( FinbuzzTheme::$options[$prefix . '_bgimg'] ) ) {
                $attch_url      = wp_get_attachment_image_src( FinbuzzTheme::$options[$prefix . '_bgimg'], 'full', true );
                FinbuzzTheme::$bgimg = $attch_url[0];
            } else {
                FinbuzzTheme::$bgimg = FINBUZZ_IMG_URL . 'banner.png';
            }
			
            FinbuzzTheme::$pagebgcolor = FinbuzzTheme::$options[$prefix . '_page_bgcolor'];
            if( !empty( FinbuzzTheme::$options[$prefix . '_page_bgimg'] ) ) {
                $attch_url      = wp_get_attachment_image_src( FinbuzzTheme::$options[$prefix . '_page_bgimg'], 'full', true );
                FinbuzzTheme::$pagebgimg = $attch_url[0];
            }
			
			
        }
    }
}

// Add body class
add_filter( 'body_class', 'finbuzz_body_classes' );
if( !function_exists( 'finbuzz_body_classes' ) ) {
    function finbuzz_body_classes( $classes ) {
		
		// Header
    	if ( FinbuzzTheme::$options['sticky_menu'] == 1 ) {
			$classes[] = 'sticky-header';
		}
		if ( FinbuzzTheme::$options['services_style'] == 'style2' ) {
			$classes[] = 'service-style-2';
		}
        $classes[] = 'header-style-'. FinbuzzTheme::$header_style;		
        $classes[] = 'footer-style-'. FinbuzzTheme::$footer_style;
	

        if ( FinbuzzTheme::$top_bar == 1 || FinbuzzTheme::$top_bar == 'on' ){
            $classes[] = 'has-topbar topbar-style-'. FinbuzzTheme::$top_bar_style;
        }
		
        if ( FinbuzzTheme::$tr_header === 1 || FinbuzzTheme::$tr_header === "on" ){
           $classes[] = 'trheader';
        }
        
        $classes[] = ( FinbuzzTheme::$layout == 'full-width' ) ? 'no-sidebar' : 'has-sidebar';
		
		$classes[] = ( FinbuzzTheme::$layout == 'left-sidebar' ) ? 'left-sidebar' : 'right-sidebar';
        
        if( isset( $_COOKIE["shopview"] ) && $_COOKIE["shopview"] == 'list' ) {
            $classes[] = 'product-list-view';
        } else {
            $classes[] = 'product-grid-view';
        }
		if ( is_singular('post') ) {
			$classes[] =  ' post-detail-' . FinbuzzTheme::$options['post_style'];
        }
        if(finbuzz_has_footer_widget()===true){
            $classes[] = 'has-footer-widget';
        }
        else{
            $classes[] = 'no-footer-widget';
        }
        return $classes;
    }
}

function finbuzz_has_footer_widget(){
    for($i=1;$i<=3;$i++){
        for($j=$i;$j<=4;$j++){
            if(is_active_sidebar( 'footer-style-'.$i.'-'.$j )){
                return true;
            }
        }
    }
    return false;
}