<?php

use RadiusTheme\SB\Helpers\Fns;

if( ! function_exists( 'rtsb' ) ){
	return;
}

class WidgetSupport{
	/**
	 * @var null
	 */
	protected static $instance = null;
	/**
	 * The single instance of the class.
	 *
	 * @var object
	 */
	private $widgets;
	/**
	 * @return singleTon ShopbuilderSupport|null
	 */
	public static function instance( $widgets ) {
		if ( ! self::$instance ) {
			self::$instance = new self();
		}
		self::$instance->widgets = $widgets;
		return self::$instance;
	}
	/**
	 * The function name comes from the widget base name "rtsb-products-archive". This is for theme support prefix with render.
	 *
	 * @return void
	 */



	public function render_rtsb_products_default_loop(  ) {
		add_action('finbuzz_action_buttons', [$this, 'actions_button_control' ] );
		$controllers = $this->widgets->get_settings_for_display();
		if ( empty( $controllers['show_pagination'] ) ) {
			remove_action( 'woocommerce_after_shop_loop', [WC_Functions::instance(),'finbuzz_products_paginations'], 10 );
		}
	}
	public function actions_button_control( $product ) {
		if( ! $product ){
			return ;
		}

		$product_id = $product->get_id();

		$controllers = $this->widgets->get_settings_for_display();
		if ( ! empty( $controllers['wishlist_button'] ) ) { ?>

			<?php  do_action( 'rtsb/modules/wishlist/print_button', $product_id ); ?>

			<?php
		}
		if ( ! empty( $controllers['comparison_button'] ) ) { ?>

			<?php do_action( 'rtsb/modules/compare/print_button', $product_id ); ?>

			<?php
		}
		if ( ! empty( $controllers['quick_view_button'] ) ) { ?>

			<?php  do_action( 'rtsb/modules/quick_view/print_button', $product_id ); ?>

			<?php
		}
	}
	public function widget_controls_rtsb_products_archive() {
		// Archive page
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-products-archive', [ $this, 'product_archive_widget_control' ], 11 );

	}
	public function widget_controls_rtsb_products_archive_custom() {
		// Archive page
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-products-archive-custom', [ $this, 'rtsb_products_archive_custom_control' ], 11 );
	}
	public function widget_controls_rtsb_upsells_product_slider() {
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-upsells-product-slider', [ $this, 'custom_upsell_related_product_widget_control' ], 11 );
	}
	public function widget_controls_rtsb_upsells_product_custom() {
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-upsells-product-custom', [ $this, 'custom_upsell_related_product_widget_control' ], 11 );
	}
	public function widget_controls_rtsb_upsells_product() {
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-upsells-product', [ $this, 'related_upsell_crossell_product_widget_control' ], 11 );

	}
	public function widget_controls_rtsb_related_product_custom() {
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-related-product-custom', [ $this, 'custom_upsell_related_product_widget_control' ], 11 );
	}
	public function widget_controls_rtsb_related_products_slider() {
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-related-products-slider', [ $this, 'custom_upsell_related_product_widget_control' ], 11 );
	}

	public function widget_controls_rtsb_related_product() {
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-related-product', [ $this, 'related_product_default_slider_control' ], 11 );
		$this->related_product_theme_slider_control();

	}
	public function widget_controls_rtsb_crosssell_product_slider() {
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-crosssell-product-slider', [ $this, 'custom_upsell_related_product_widget_control' ], 11 );
	}
	public function widget_controls_rtsb_cross_sell_product_custom() {
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-cross-sell-product-custom', [ $this, 'custom_upsell_related_product_widget_control' ], 11 );
	}
	public function widget_controls_rtsb_cross_sells() {
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-cross-sells', [ $this, 'related_upsell_crossell_product_widget_control' ], 11 );

	}
	function related_product_theme_slider_control(){
		add_filter( 'rdtheme_has_slider_for_related_post_box', [ $this, 'has_slider_for_related_post_box' ], 11  );
		add_filter( 'rdtheme_related_product_class', [ $this, 'rdtheme_related_product_class' ], 11, 2 );
		add_filter( 'finbuzz_related_products_carousel_options', [ $this, 'related_products_carousel_options' ], 11 );
	}
	public function has_slider_for_related_post_box( $has_slider ) {
		$controllers = $this->widgets->get_settings_for_display();

		if( empty( $controllers['slider_activate'] )){
			$has_slider = false;
		}
		return $has_slider;
	}
	public function rdtheme_related_product_class( $product_class, $has_slider ) {
		if( $has_slider ){
			return $product_class;
		}
		$controllers = $this->widgets->get_settings_for_display();
		$product_class .= 'col-lg-'.absint( $controllers['columns'] ) ;
		return $product_class;
	}
	public function related_products_carousel_options( $swiper_data ) {
		$controllers = $this->widgets->get_settings_for_display();
		$swiper_data['breakpoints']['1600']['slidesPerView'] = floor( 12 / absint( $controllers['columns'] ) );
		$swiper_data['auto'] = boolval( $controllers['autoplay'] );
		$swiper_data['speed'] = absint( $controllers['speed'] );
		$swiper_data['show_arrow'] = boolval( $controllers['show_arrows'] );
		return $swiper_data;
	}
	public function render_rtsb_upsells_product(){
		wc_load_cart();
		$this->render_rtsb_products_default_loop();
	}
	public function render_rtsb_related_product(){
		wc_load_cart();
		$this->render_rtsb_products_default_loop();
	}

	public function related_product_default_slider_control( $fields ) {
		unset( $fields['space_between'] );
		unset( $fields['loop'] );
		unset( $fields['autoplay_delay'] );
		unset( $fields['pauseon_mouseenter'] );
		unset( $fields['show_dots'] );
		unset( $fields['left_arrow_icon'] );
		unset( $fields['right_arrow_icon'] );

		unset( $fields['slider_dots_style'] );
		unset( $fields['dots_gap'] );
		unset( $fields['dots_size'] );
		unset( $fields['dot_color'] );
		unset( $fields['dot_active_color'] );

		unset( $fields['slider_arrow_icon_size']['default'] );
		unset( $fields['slider_arrow_size']);

		$fields['columns']['type'] = 'select';
		$fields['columns']['options'] = [
			'12' => esc_html__( 'Full Width', 'shopbuilder' ),
			'6' => esc_html__( '2 Columns', 'shopbuilder' ),
			'4' => esc_html__( '3 Columns', 'shopbuilder' ),
			'3' => esc_html__( '4 Columns', 'shopbuilder' ),
			'2' => esc_html__( '6 Columns', 'shopbuilder' ),
		];
		$fields['columns']['default'] = '4';
		$fields['slider_activate']['default'] = 'yes';
		$fields['speed']['separator'] = 'default';
		return $this->product_loop_widget_control( $fields );
	}
	public function related_upsell_crossell_product_widget_control( $fields ){
		return $this->product_loop_widget_control( $fields );
	}
	public function custom_upsell_related_product_widget_control( $fields ) {
		return $this->product_loop_widget_price($fields);
	}
	public function rtsb_products_archive_custom_control( $fields ) {
		return $this->product_loop_widget_price($fields);
	}
	function product_loop_widget_price( $fields ){
		$fields['product_price_color']['selectors']['.woocommerce {{WRAPPER}} div.product p.price']='color:{{VALUE}}';

		return $fields;
	}
	public function product_archive_widget_control( $fields ) {

		$fields = $this->product_loop_widget_control( $fields );
		unset( $fields['image_gap']['default'] );
		unset($fields['row_gap']['selectors']);
		unset($fields['image_gap']['selectors']);
		unset($fields['image_gap']['default']['size']);
		unset($fields['view_mode']);
		unset($fields['list_image_width']);
		$fields['row_gap']['default']['size']='40';
		$fields['row_gap']['selectors']['.woocommerce {{WRAPPER}}  .rt-product-block'] = 'padding-bottom: {{SIZE}}{{UNIT}};';
		$fields['image_gap']['selectors']['.woocommerce {{WRAPPER}} .rt-product-block .rt-thumb-wrapper'] = 'margin-bottom: {{SIZE}}{{UNIT}};';
		return $fields;
	}
	public function product_loop_widget_control( $fields ) {

		unset( $fields['module_width']['default'] );
		unset( $fields['module_height']['default'] );
		unset( $fields['module_item_alignment']);

		$fields['product_image_bg_color']['selectors']['.woocommerce {{WRAPPER}} .rt-product-block .rt-thumb-wrapper'] = 'background-color: {{VALUE}};';
		$fields['product_image_height']['selectors']['.woocommerce {{WRAPPER}} .rt-product-block .rt-thumb-wrapper img'] = 'height: {{SIZE}}{{UNIT}}';
		$fields['product_image_auto_fit']['selectors']['.woocommerce {{WRAPPER}} .rt-product-block .rt-thumb-wrapper img'] = 'object-position:center center; object-fit: cover';
		$fields['product_image_padding']['selectors']['.woocommerce {{WRAPPER}} .rt-product-block .rt-thumb-wrapper'] = 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}';
		$fields['product_title_typography']['selector'] =  '{{WRAPPER}} .rt-product-block .price-title-box .rt-title';
		$fields['product_title_color']['selectors'] =  [ '{{WRAPPER}} .rt-product-block .price-title-box .rt-title a' => 'color: {{VALUE}};', ];
		$fields['product_title_padding']['selectors'] =  [
			'{{WRAPPER}} .rt-product-block .price-title-box .rt-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
		];
		$fields['product_price_typography']['selector'] =  '{{WRAPPER}} .rt-product-block .price-title-box .rt-price';
		$fields['product_price_color']['selectors'] =  [ '{{WRAPPER}} .rt-product-block .price-title-box .rt-price  del' => 'color: {{VALUE}};', ];
		$fields['product_reguler_price_color']['selectors'] =  [ '{{WRAPPER}} .rt-product-block .price-title-box .rt-price' => 'color: {{VALUE}};', ];
		$fields['product_price_padding']['selectors'] =  [ '{{WRAPPER}} .rt-product-block .price-title-box .rt-price' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};', ];

		// Flash Sale
		$fields['flash_sale_typography']['selector'] =  '.woocommerce {{WRAPPER}} span.onsale';
		$fields['product_flash_sale_color']['selectors'] =  [
			'.woocommerce {{WRAPPER}} span.onsale' => 'color: {{VALUE}};'
		];
		$fields['flash_sale_bg_color']['selectors'] =  [
			'.woocommerce {{WRAPPER}} span.onsale' =>'background-color: {{VALUE}};'
		];
		$fields['flash_sale_badge_width']['selectors'] =  [
			'.woocommerce {{WRAPPER}} span.onsale' => 'width: {{SIZE}}{{UNIT}};',
		];
		$fields['flash_sale_badge_height']['selectors'] =  [
			'.woocommerce {{WRAPPER}} span.onsale' => 'height: {{SIZE}}{{UNIT}};',
		];
		$fields['flash_sale_badge_border_radius']['selectors'] =  [
			'.woocommerce {{WRAPPER}} span.onsale' => 'border-radius: {{SIZE}}{{UNIT}};',
		];

		/**
		 *
		 * Star Rating
		 */
		$fields['review_star_icon_default_color']['selectors'] = [
			'{{WRAPPER}} .rating-custom .star-rating:before' => 'color: {{VALUE}};'
		];

		$fields['review_star_icon_color']['selectors'] = [
			'{{WRAPPER}} .rating-custom .star-rating span:before' => 'color: {{VALUE}};'
		];

		$fields['review_star_icon_size']['selectors'] = [
			'{{WRAPPER}} .rating-custom .star-rating' => 'font-size: {{SIZE}}{{UNIT}};',
		];

		$fields['review_star_icon_specing' ]['selectors']  = [
			'{{WRAPPER}} .products .product .rdtheme-star-rating' => 'letter-spacing: {{SIZE}}{{UNIT}};width: inherit;',
			'{{WRAPPER}} .products .product .rdtheme-star-rating:before' => 'position: static;',
		];

		$fields['review_star_icon_margin']['selectors'] = [
			'{{WRAPPER}} .rating-custom .star-rating' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}; padding: 0;',
		];

		/**
		 *
		 * Add to cart
		 */
		$fields['cart_button_typography']['selector'] = '{{WRAPPER}} .rt-product-block :is(a.add_to_cart_button, a.product_type_simple, a.product_type_grouped )';
		$fields['cart_button_text_color_normal']['selectors'] = [
			'{{WRAPPER}} .rt-product-block :is(a.add_to_cart_button, a.product_type_simple, a.product_type_grouped )' => 'color: {{VALUE}};'
		];
		$fields['cart_button_bg_color_normal']['selectors'] = [
			'{{WRAPPER}} .rt-product-block :is(a.add_to_cart_button, a.product_type_simple, a.product_type_grouped )' => 'background-color: {{VALUE}};'
		];
		$fields['cart_button_border']['selector'] = '{{WRAPPER}} .rt-product-block :is(a.add_to_cart_button, a.product_type_simple, a.product_type_grouped )';
		$fields['cart_button_text_color_hover']['selectors'] = [
			'{{WRAPPER}} .rt-product-block :is(a.add_to_cart_button, a.product_type_simple, a.product_type_grouped ):hover' => 'color: {{VALUE}};'
		];
		$fields['cart_button_bg_color_hover']['selectors'] = [
			'{{WRAPPER}} .rt-product-block :is(a.add_to_cart_button, a.product_type_simple, a.product_type_grouped ):hover' => 'background-color: {{VALUE}};'
		];
		$fields['cart_button_border_hover_color']['selector'] = '{{WRAPPER}} .rt-product-block :is(a.add_to_cart_button, a.product_type_simple, a.product_type_grouped ):hover';
		$fields['cart_button_border_radius']['selectors'] = [
			'{{WRAPPER}} .rt-product-block :is(a.add_to_cart_button, a.product_type_simple, a.product_type_grouped )' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
		];
		$fields['add_cart_button_padding']['selectors'] = [
			'{{WRAPPER}} .rt-product-block :is(a.add_to_cart_button, a.product_type_simple, a.product_type_grouped )' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
		];
		$fields['add_cart_button_margin']['selectors'] = [
			'{{WRAPPER}} .rt-product-block :is(a.add_to_cart_button, a.product_type_simple, a.product_type_grouped )' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
		];
		$fields['cart_height']['selectors'] = [
			'{{WRAPPER}} .rt-product-block :is(a.add_to_cart_button, a.product_type_simple, a.product_type_grouped )' => 'height: {{SIZE}}{{UNIT}};'
		];
		$fields['icon_align']['selectors'] = [
			'{{WRAPPER}} .rt-product-block :is(a.add_to_cart_button, a.product_type_simple, a.product_type_grouped )' => 'display: inline-flex;align-items: center',
			'{{WRAPPER}} .rt-product-block :is(a.add_to_cart_button, a.product_type_simple, a.product_type_grouped )' => 'flex-direction: {{VALUE}}',
		];
		$fields['cart_icon_gap']['selectors'] = [
			'{{WRAPPER}} .rt-product-block :is(a.add_to_cart_button, a.product_type_simple, a.product_type_grouped )' => 'gap: {{SIZE}}{{UNIT}}',
		];
		$fields['cart_icon_size']['selectors'] = [
			'{{WRAPPER}} .rt-product-block :is(a.add_to_cart_button, a.product_type_simple, a.product_type_grouped ) :is(i, span)' => 'font-size: {{SIZE}}{{UNIT}}',
		];
		$fields['module_item_gap']['selectors'] = [
			'.woocommerce {{WRAPPER}} .rt-product-block .rt-buttons-area .btn-icons' => 'gap: {{SIZE}}{{UNIT}}',
		];


		return $fields;
	}

	public function render_rtsb_products_archive() {
		wc_load_cart();
		$this->render_rtsb_products_default_loop();
		add_filter( 'finbuzz_pagination_args', [ $this, 'pagination_args' ] );

		$controllers = $this->widgets->get_settings_for_display();

		if ( ! empty( $controllers['show_pagination'] ) ) {
			$page = apply_filters( 'rtsb/builder/set/current/page/type', '' );

			if ( Fns::product_filters_has_ajax( $page ) ) {
				remove_action( 'woocommerce_after_shop_loop', [WC_Functions::class, 'finbuzz_products_paginations'], 10 );
			}
		}
	}
	public function pagination_args( $args ) {
		$controllers = $this->widgets->get_settings_for_display();
		if( ! empty( $controllers['prev_icon']['value'] )){
			$args['prev_text'] = Fns::icons_manager( $controllers['prev_icon'] );
		}
		if( ! empty( $controllers['next_icon']['value'] )) {
			$args['next_text'] = Fns::icons_manager($controllers['next_icon']);
		}
		return $args;
	}
	/**
	 * Widget Field.
	 * Single Add to cart
	 *
	 * @return array
	 */
	public function render_rtsb_product_add_to_cart(){
		$controllers = $this->widgets->get_settings_for_display();
		if( ! empty( $controllers['quantity_style'] ) && 'default' !== $controllers['quantity_style'] ){
			remove_action( 'woocommerce_before_quantity_input_field',  [ \WC_Functions::class, 'before_quantity_input_field'] , 10 );
			remove_action( 'woocommerce_after_quantity_input_field',  [ \WC_Functions::class, 'after_quantity_input_field' ], 10 );
		}
	}
	public function widget_controls_rtsb_product_add_to_cart() {
		// Archive page
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-product-add-to-cart', [ $this, 'rtsb_product_add_to_cart' ], 11 );

	}

	public function rtsb_product_add_to_cart( $fields ) {
		$fields['height']['selectors']=[
			'{{WRAPPER}} .rtsb-product-add-to-cart input[type=number], {{WRAPPER}} .rtsb-quantity-box-group:is(.rtsb-quantity-box-group-style-1,.rtsb-quantity-box-group-style-2) .rtsb-quantity-btn' => 'height: {{SIZE}}{{UNIT}}',
			'{{WRAPPER}} .rtsb-quantity-box-group:is(.rtsb-quantity-box-group-style-3,.rtsb-quantity-box-group-style-4) .rtsb-quantity-btn'=>'height: calc( {{SIZE}}{{UNIT}} / 2 )',
			'.rtsb-builder-content {{WRAPPER}} .single-add-to-cart-wrapper .quantity .input-group-btn' => 'height: {{SIZE}}{{UNIT}};',
		];
		$fields['cart_icon_size']['selectors']['{{WRAPPER}} .single-add-to-cart-wrapper .quantity .input-group-btn span.quantity-btn i'] = 'font-size: {{SIZE}}{{UNIT}}';

		return $fields;
	}
	// Cart Page

	public function widget_controls_rtsb_product_carttable() {
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-product-carttable', [ $this, 'rtsb_product_carttable_widget_controls' ], 11 );
	}

	public function rtsb_product_carttable_widget_controls( $fields ) {
		$fields['cart_table_border']['selector'] = $fields['cart_table_border']['selector'] . ',{{WRAPPER}} table.woocommerce-cart-form__contents tr th,{{WRAPPER}} table.woocommerce-cart-form__contents td';

		$fields['quantity_input_width']['selectors']['{{WRAPPER}} .woocommerce-cart-form input.qty,{{WRAPPER}} .woocommerce-cart-form .quantity .input-group-btn'] = 'width: {{SIZE}}{{UNIT}}';

		$fields['quantity_input_height']['selectors']['{{WRAPPER}} .woocommerce-cart-form input.qty,{{WRAPPER}} .woocommerce-cart-form .quantity .input-group-btn'] = 'height: {{SIZE}}{{UNIT}}';

		$fields['input_border']['selector'] = $fields['input_border']['selector'] . ',{{WRAPPER}} .woocommerce-cart-form input.qty,{{WRAPPER}} .woocommerce-cart-form .quantity .input-group-btn';

		$fields['input_text_color']['selectors']['{{WRAPPER}} .woocommerce-cart-form input.qty,{{WRAPPER}} .woocommerce-cart-form .quantity .input-group-btn,{{WRAPPER}} table.cart td.actions .coupon .input-text'] = 'color: {{VALUE}}';

		$fields['input_bg_color']['selectors']['{{WRAPPER}} .woocommerce-cart-form input.qty,{{WRAPPER}} .woocommerce-cart-form .quantity .input-group-btn'] = 'background-color: {{VALUE}}';

		return $fields;
	}
}