<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */
 
 
if ( FinbuzzTheme::$layout == 'full-width' ) {
	$finbuzz_layout_class = 'col-sm-12 col-12';
}
else{
	$finbuzz_layout_class = FinbuzzTheme_Helper::has_active_widget();
}

// Template
$iso						= 'no-equal-gallery';

if ( FinbuzzTheme::$options['gallery_archive_style'] == 'style1' ){
	$gallery_archive_layout = "gallery-default gallery-multi-layout-1";
	$template 				 = 'gallery-1';
}elseif( FinbuzzTheme::$options['gallery_archive_style'] == 'style2' ){
	$gallery_archive_layout = "gallery-default gallery-multi-layout-2";
	$template 				 = 'gallery-2';
}else{
	$gallery_archive_layout = "gallery-default gallery-multi-layout-1";
	$template 				 = 'gallery-1';
}

?>
<?php get_header(); ?>
<div id="primary" class="content-area">
	<div class="container">
		<div class="row">
			<?php
				if ( FinbuzzTheme::$layout == 'left-sidebar' ) {
					get_sidebar();
				}
			?>		
			<div class="<?php echo esc_attr( $gallery_archive_layout );?> <?php echo esc_attr( $finbuzz_layout_class );?>">
				<main id="main" class="site-main">
					<?php if(category_description(  )){ ?>
						<div class="category-description">
							<?php echo category_description(); ?>
						</div>
					<?php } ?>
					<?php if ( have_posts() ) :?>			

						<div class="row zoom-gallery <?php echo esc_attr( $iso );?>">
							<?php while ( have_posts() ) : the_post(); ?>
								<div class="col-lg-4 col-md-6 col-sm-6 col-xs-12">
									<?php get_template_part( 'template-parts/content', $template ); ?>
								</div>
							<?php endwhile; ?>
						</div>

					<?php FinbuzzTheme_Helper::pagination(); ?>	
					<?php else:?>
						<?php get_template_part( 'template-parts/content', 'none' );?>
					<?php endif;?>
				</main>
			</div>			
			<?php
				if( FinbuzzTheme::$layout == 'right-sidebar' ){				
					get_sidebar();
				}
			?>
		</div>	
	</div>
</div>
<?php get_footer(); ?>
