<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

$thumb_size = 'finbuzz-size1';

$finbuzz_has_entry_meta  = ( FinbuzzTheme::$options['blog_date'] || FinbuzzTheme::$options['blog_author_name'] || FinbuzzTheme::$options['blog_cats'] || FinbuzzTheme::$options['blog_comment_num'] || FinbuzzTheme::$options['blog_length'] && function_exists( 'finbuzz_reading_time' ) || FinbuzzTheme::$options['blog_view'] && function_exists( 'finbuzz_views' ) ) ? true : false;

$finbuzz_time_html       = sprintf( '<span>%s</span><span>%s</span>', get_the_time( 'd' ), get_the_time( 'M' ), get_the_time( 'Y' ) );
$finbuzz_time_html       = apply_filters( 'finbuzz_single_time', $finbuzz_time_html );

$finbuzz_comments_number = number_format_i18n( get_comments_number() );
$finbuzz_comments_html = $finbuzz_comments_number == 1 ? esc_html__( 'Comment: ' , 'finbuzz' ) : esc_html__( 'Comments: ' , 'finbuzz' );
$finbuzz_comments_html = $finbuzz_comments_html . '<span class="comment-number">'. $finbuzz_comments_number .'</span> ';

$id = get_the_ID();
$content = get_the_content();
$content = apply_filters( 'the_content', $content );
$content = wp_trim_words( get_the_excerpt(), FinbuzzTheme::$options['post_content_limit'], '' );


?>
<div id="post-<?php the_ID(); ?>" <?php post_class( 'blog-layout-2' ); ?>>
	<div class="blog-list content-search">
		<div class="entry-content">
			<?php if ( $finbuzz_has_entry_meta ) { ?>
			<ul class="entry-meta">
				<?php if ( FinbuzzTheme::$options['blog_date'] ) { ?>			
					<li class="blog-date">
					<i class="fas fa-calendar-alt"></i><?php echo get_the_date(); ?>	
					</li>	
				<?php } ?>
				<?php if ( FinbuzzTheme::$options['blog_author_name'] ) { ?>
					<li class="item-author"><i class="far fa-user"></i><?php esc_html_e( 'by ', 'finbuzz' );?><?php the_author_posts_link(); ?></li>
				<?php } ?>
				<?php $cat=get_the_category( $id ); ?>
				<?php  if ( FinbuzzTheme::$options['blog_cats'] && $cat) { ?>
				<li class="blog-cat"><i class="far fa-folder-open"></i><?php echo the_category( ', ' );?></li>
				<?php } ?>
				<?php if ( FinbuzzTheme::$options['blog_comment_num'] ) { ?>
				<li class="blog-comment"><i class="far fa-comments"></i><a href="<?php echo get_comments_link( get_the_ID() ); ?>"><?php echo wp_kses( $finbuzz_comments_html , 'alltext_allow' );?>
					</a>
			    </li>
				<?php } if ( FinbuzzTheme::$options['blog_length'] && function_exists( 'finbuzz_reading_time' ) ) { ?>
				<li class="meta-reading-time meta-item"><i class="far fa-clock"></i><?php echo finbuzz_reading_time(); ?></li>
				<?php } if ( FinbuzzTheme::$options['blog_view'] && function_exists( 'finbuzz_views' ) ) { ?>
				<li><i class="fas fa-signal"></i><span class="meta-views meta-item "><?php echo finbuzz_views(); ?></span></li>
				<?php } ?>
			</ul>
			<?php } ?>
			<h3 class="entry-title"><a href="<?php the_permalink();?>"><?php the_title();?></a></h3>
			<?php if(FinbuzzTheme::$options['blog_content']){ ?>
				<p><?php echo wp_kses( $content , 'alltext_allow' ); ?></p>
			<?php } ?>		
		</div>
	</div>
</div>