<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

$finbuzz_has_entry_meta  = ( FinbuzzTheme::$options['post_date'] || FinbuzzTheme::$options['post_author_name'] || FinbuzzTheme::$options['post_comment_num'] || FinbuzzTheme::$options['post_cats'] || ( FinbuzzTheme::$options['post_length'] && function_exists( 'finbuzz_reading_time' ) ) || ( FinbuzzTheme::$options['post_view'] && function_exists( 'finbuzz_views' ) ) ) ? true : false;

$finbuzz_comments_number = number_format_i18n( get_comments_number() );
$finbuzz_comments_html = $finbuzz_comments_number == 1 ? esc_html__( 'Comment' , 'finbuzz' ) : esc_html__( 'Comments' , 'finbuzz' );
$finbuzz_comments_html = '<span class="comment-number">'. $finbuzz_comments_number .'</span> '. $finbuzz_comments_html;
$finbuzz_author_bio = get_the_author_meta( 'description' );

$finbuzz_time_html       = sprintf( '<span>%s</span><span>%s</span>', get_the_time( 'd' ), get_the_time( 'M' ), get_the_time( 'Y' ) );
$finbuzz_time_html       = apply_filters( 'finbuzz_single_time', $finbuzz_time_html );

$author = $post->post_author;

$news_author_fb = get_user_meta( $author, 'finbuzz_facebook', true );
$news_author_tw = get_user_meta( $author, 'finbuzz_twitter', true );
$news_author_ld = get_user_meta( $author, 'finbuzz_linkedin', true );
$news_author_gp = get_user_meta( $author, 'finbuzz_gplus', true );
$news_author_pr = get_user_meta( $author, 'finbuzz_pinterest', true );
$finbuzz_author_designation = get_user_meta( $author, 'finbuzz_author_designation', true );
$animation_value  =  FinbuzzTheme::$options['animation'];

if ( empty(has_post_thumbnail() ) ) {
	$img_class ='no_image';
}else {
	$img_class ='show_image';
}

?>
<div id="post-<?php the_ID(); ?>" <?php post_class();?>>
	<div class="entry-header <?php echo esc_attr($img_class); ?> <?php echo esc_attr( $animation_value );?> fadeInUp" data-wow-delay="300ms" data-wow-duration="800ms">
		<?php if ( FinbuzzTheme::$options['post_featured_image'] == true ) { ?>
			<?php if ( has_post_thumbnail() ) { ?>
				<div class="entry-thumbnail-area"><?php the_post_thumbnail( 'finbuzz-size1' , ['class' => 'img-responsive'] ); ?>
				</div>
			<?php } ?>
		<?php } ?>
		<div class="entry-content">
			<?php if ( $finbuzz_has_entry_meta ) { ?>
				<div class="entry-meta">		
					<ul>
						<?php if ( FinbuzzTheme::$options['blog_date'] ) { ?>			
							<li class="blog-date">
							<i class="fas fa-calendar-alt"></i><?php echo get_the_date(); ?>
							</li>
						<?php } ?>
						<?php if ( FinbuzzTheme::$options['post_author_name'] ) { ?>
							<li class="item-author">
							<i class="far fa-user"></i><?php esc_html_e( 'by ', 'finbuzz' );?><?php the_author_posts_link(); ?>
							</li>	
						<?php } ?>
						<?php $cat=get_the_category( $id ); ?>
						<?php  if ( FinbuzzTheme::$options['post_cats'] && $cat) { ?>			
							<li class="blog-cat"><i class="far fa-folder-open"></i><?php echo the_category( ', ' );?></li>
						<?php } if ( FinbuzzTheme::$options['post_length'] && function_exists( 'finbuzz_reading_time' ) ) { ?>
						<li class="meta-reading-time meta-item"><i class="far fa-clock"></i><?php echo finbuzz_reading_time(); ?></li>
						<?php } if ( FinbuzzTheme::$options['post_view'] && function_exists( 'finbuzz_views' ) ) { ?>
						<li><i class="fas fa-signal"></i><span class="meta-views meta-item "><?php echo finbuzz_views(); ?></span></li>
						<?php } if ( FinbuzzTheme::$options['post_comment_num'] ) { ?>
						<li><i class="far fa-comments"></i><?php echo wp_kses( $finbuzz_comments_html , 'alltext_allow' ); ?></li>
						<?php } ?>
					</ul>
				</div>
			<?php } ?>			
			<div class="clear"></div>
			<div class="rt-single-content"><?php the_content();?>
				<?php wp_link_pages( array(
					'before'      => '<div class="page-links">' . esc_html__( 'Pages:', 'finbuzz' ),
					'after'       => '</div>',
					'link_before' => '<span class="page-number">',
					'link_after'  => '</span>',
				) ); ?>
			</div>
		</div>
		<?php if ( ( FinbuzzTheme::$options['post_tags'] && has_tag() ) || FinbuzzTheme::$options['post_share'] ) { ?>
			<div class="entry-footer">
				<div class="entry-footer-meta">
					<?php if ( FinbuzzTheme::$options['post_tags'] && has_tag() ) { ?>
					<div class="item-tags">
						<span><?php esc_html_e( 'Tags :', 'finbuzz' );?></span><?php echo get_the_term_list( $post->ID, 'post_tag', '' ); ?>
					</div>	
					<?php } if ( ( FinbuzzTheme::$options['post_share'] ) && ( function_exists( 'finbuzz_post_share' ) ) ) { ?>
					<div class="post-share"><span><?php esc_html_e( 'Share :', 'finbuzz' );?></span><?php finbuzz_post_share(); ?></div>
					<?php } ?>
				</div>
			</div>
		<?php } ?>
	</div>
	<!-- next/prev post -->
	<?php if ( FinbuzzTheme::$options['post_links'] ) { ?>
		<div class="<?php echo esc_attr( $animation_value );?> fadeInUp" data-wow-delay="500ms" 		data-wow-duration="800ms"><?php finbuzz_post_links_next_prev();?> 
		</div>
	<?php } ?>
	<!-- author bio -->
	<?php if ( FinbuzzTheme::$options['post_author_bio'] == '1' ) { ?>
		<div class="author-content <?php echo esc_attr( $animation_value );?> fadeInUp" data-wow-delay="500ms" 		data-wow-duration="800ms">
			<div class="media about-author">
				<div class="<?php if ( is_rtl() ) { ?> pull-right text-right <?php } else { ?> pull-left <?php } ?>">
					<?php echo get_avatar( $author, 105 ); ?>
				</div>
				<div class="media-body">
					<div class="about-author-info">
						<h3 class="author-title"><?php the_author_posts_link();?></h3>
						<div class="author-designation"><?php if ( !empty ( $finbuzz_author_designation ) ) {	echo esc_html( $finbuzz_author_designation ); } else {	$user_info = get_userdata( $author ); echo esc_html ( implode( ', ', $user_info->roles ) );	} ?></div>
					</div>
					<?php if ( $finbuzz_author_bio ) { ?>
					<div class="author-bio"><?php echo esc_html( $finbuzz_author_bio );?></div>
					<?php } ?>
					<ul class="author-box-social">
						<?php if ( ! empty( $news_author_fb ) ){ ?><li><a href="<?php echo esc_url( $news_author_fb ); ?>"><i class="fab fa-facebook-f"></i></a></li><?php } ?>
						<?php if ( ! empty( $news_author_tw ) ){ ?><li><a href="<?php echo esc_url( $news_author_tw ); ?>"><i class="fab fa-x-twitter"></i></a></li><?php } ?>
						<?php if ( ! empty( $news_author_gp ) ){ ?><li><a href="<?php echo esc_url( $news_author_gp ); ?>"><i class="fab fa-google-plus-g"></i></a></li><?php } ?>
						<?php if ( ! empty( $news_author_ld ) ){ ?><li><a href="<?php echo esc_url( $news_author_ld ); ?>"><i class="fab fa-linkedin-in"></i></a></li><?php } ?>
						<?php if ( ! empty( $news_author_pr ) ){ ?><li><a href="<?php echo esc_url( $news_author_pr ); ?>"><i class="fab fa-pinterest"></i></a></li><?php } ?>
					</ul>
				</div>
				<div class="clear"></div>
			</div>
		</div>			
	<?php } ?>
	<?php if( FinbuzzTheme::$options['show_related_post'] == '1' && is_single() && !empty ( finbuzz_related_post() ) ) { ?>
		<div class="related-post">
			<?php finbuzz_related_post(); ?>
		</div>
	<?php } ?>
	<?php
	if ( comments_open() || get_comments_number() ){ ?>
		<div class="<?php echo esc_attr( $animation_value );?> fadeInUp" data-wow-delay="600ms" 		data-wow-duration="800ms">
			<?php comments_template(); ?>
		</div>	
		<?php }
	?>
</div>		

